using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace HGrid
{
	/// <summary>
	/// Summary description for _Default.
	/// </summary>
	public class _Default : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label LabelTitle;
		protected System.Web.UI.WebControls.Label LabelPostBack;
		protected System.Web.UI.WebControls.TextBox txtExpandedFields;
		protected System.Web.UI.WebControls.DataGrid DataGrid1;
		protected System.Web.UI.WebControls.Label LabelWhatHappens;
		protected System.Web.UI.WebControls.Button ButtonSample;
		
		private string connectionstring = "server=SERVERNAME;database=Northwind;uid=USERNAME;password=PASSWORD;";

		private void Page_Load(object sender, System.EventArgs e)
		{
			//Clear the contents of the Label
			this.LabelPostBack.Text = "";

			if ( !Page.IsPostBack )
			{
				//Bind Master Details
				BindData();
			}
			else
			{
				//If it is a postback that is not from the grid, we have to expand the rows
				//the user had expanded before.  We have to check first who called this postback
				//by checking the Event Target
				if ( Request["__EVENTTARGET"] != null)
				{
					string strEventTarget = Request["__EVENTTARGET"].ToString().ToLower();
					if ( strEventTarget.IndexOf("datagrid1") == -1)
					{
						//Expanded what ever the user had expanded by Setting Mode
						//which will be used in ItemDataBound method.
						ViewState["Mode"] = "ShowDetails";
						//Not caused by datagrid
						//We need to rebind data and generate scripts.
						BindData();
					}
					else
					{
						ViewState["Mode"] = null;
					}
				}

			}
		}


		private void ButtonSample_Click(object sender, System.EventArgs e)
		{
			LabelPostBack.Text = "A Postback has occurred. txtExpandedFields has contents: <BR/><B>" + txtExpandedFields.Text + "</B>";
		}


		#region Database Methods
		private void BindData()
		{
			//============================Query For Master Rows===========================================================================================================================
			string QueryString = "SELECT OrderID, CustomerID, EmployeeID, ShipName, ShipAddress, ShipCity, ShipRegion, ShipPostalCode, ShipCountry FROM Orders";
			//============================================================================================================================================================================

			System.Data.SqlClient.SqlConnection conn = new System.Data.SqlClient.SqlConnection();
			try
			{
				conn.ConnectionString = connectionstring;
				if ( conn.State == System.Data.ConnectionState.Closed )
				{
					conn.Open();
				}
				
				System.Data.SqlClient.SqlDataAdapter adapter = new System.Data.SqlClient.SqlDataAdapter( QueryString, conn);
				DataSet ds = new DataSet();
				adapter.Fill( ds );
				DataGrid1.DataSource = ds;
				DataGrid1.DataBind();

			}
			catch( Exception ex1 )
			{
				Response.Write( "An error has occurred: " );
				Response.Write( ex1.Message.ToString() );
				Response.End();
				
			}
			finally
			{
				if ( conn.State == System.Data.ConnectionState.Open )
				{
					conn.Close();
				}
			}

			
		}

		private DataSet RunQuery(string QueryString)
		{
			System.Data.SqlClient.SqlConnection conn = new System.Data.SqlClient.SqlConnection();

			try
			{
				conn.ConnectionString = connectionstring;
				if ( conn.State == System.Data.ConnectionState.Closed )
				{
					conn.Open();
				}
				
				System.Data.SqlClient.SqlDataAdapter adapter = new System.Data.SqlClient.SqlDataAdapter( QueryString, conn);
				DataSet ds = new DataSet();
				adapter.Fill( ds );
				return ds;
			}
			catch(Exception ex1)
			{
				Response.Write("An Error has occurred.<BR />");
				Response.Write(ex1.Message.ToString());
				Response.End();
				//This line below will never execute.
				return null;
			}
			finally
			{
				if ( conn.State == System.Data.ConnectionState.Open )
				{
					conn.Close();
				}
			}
		}

		#endregion

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.DataGrid1.PageIndexChanged += new System.Web.UI.WebControls.DataGridPageChangedEventHandler(this.DataGrid1_PageIndexChanged);
			this.DataGrid1.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.DataGrid1_ItemDataBound);
			this.ButtonSample.Click += new System.EventHandler(this.ButtonSample_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		#region Datagrid Methods
		private void DataGrid1_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem )
			{
																					 
				string DetailsQuery = "SELECT C.CompanyName, OD.UnitPrice, OD.Quantity, OD.Discount, E.FirstName, E.LastName " +
					"FROM [Order Details] as OD, [Customers] as C, [Orders] as O, [Employees] as E " +
					"where OD.OrderID = O.OrderID and O.CustomerID = C.CustomerID and O.EmployeeID = E.EmployeeID and " +
					"O.OrderID = '" + e.Item.Cells[1].Text + "' and " +
					"C.CustomerID = '" + e.Item.Cells[2].Text + "' and " +
					"E.EmployeeID = '" + e.Item.Cells[3].Text + "'"; 

				
				//or better performance, and you not use a grid and bind labels, textbox's, etc...
				DataSet ds = this.RunQuery(DetailsQuery);
				DataGrid NewDg = new DataGrid();
				NewDg.AutoGenerateColumns = true;
				NewDg.Width = Unit.Percentage(100.00);
				NewDg.DataSource = ds;
				NewDg.DataBind();
				
				SetProps(NewDg);

				System.IO.StringWriter sw = new System.IO.StringWriter();
				System.Web.UI.HtmlTextWriter htw = new System.Web.UI.HtmlTextWriter(sw);
				NewDg.RenderControl( htw );

				string DivStart = "<DIV id='uniquename" + e.Item.ItemIndex.ToString() +"' style='DISPLAY: none; HEIGHT: 1px;'>";
				string DivBody = sw.ToString();
				string DivEnd = "</DIV>";
				string FullDIV = DivStart + DivBody + DivEnd;
					
				int LastCellPosition = e.Item.Cells.Count - 1;
				int NewCellPosition = e.Item.Cells.Count - 2;
				
				e.Item.Cells[0].ID = "CellInfo" + e.Item.ItemIndex.ToString();

				if ( ViewState["Mode"] != null && ViewState["Mode"].ToString() == "ShowDetails")
				{
					if ( this.txtExpandedFields.Text.IndexOf(e.Item.Cells[0].ClientID) != -1 )
					{
						//make it expand.
						FullDIV = FullDIV.Replace("DISPLAY: none","DISPLAY: block");
						e.Item.Cells[0].Text = "<A>-</A>";
					}
				}

				//match color
				if (e.Item.ItemType == ListItemType.Item)
				{
					e.Item.Cells[LastCellPosition].Text = e.Item.Cells[LastCellPosition].Text + "</td><tr><td bgcolor='f5f5f5'></td><td colspan='" + NewCellPosition +"'>" + FullDIV;
				}
				else
				{
					e.Item.Cells[LastCellPosition].Text = e.Item.Cells[LastCellPosition].Text + "</td><tr><td bgcolor='d3d3d3'></td><td colspan='" + NewCellPosition +"'>" + FullDIV;
				}
				e.Item.Cells[0].Attributes["onclick"] = "HideShowPanel('uniquename" + e.Item.ItemIndex.ToString() + "'); ChangeHLText('" + e.Item.Cells[0].ClientID + "'); SetExpanded('" + e.Item.Cells[0].ClientID + "','" + txtExpandedFields.ClientID + "');";
				e.Item.Cells[0].Attributes["onmouseover"] = "this.style.cursor='hand'";
				e.Item.Cells[0].Attributes["onmouseout"] = "this.style.cursor='hand'";
				
			}
		}

		private void DataGrid1_PageIndexChanged(object source, System.Web.UI.WebControls.DataGridPageChangedEventArgs e)
		{
			//clean up expanded records.
			txtExpandedFields.Text = "";
			DataGrid1.CurrentPageIndex = e.NewPageIndex;
			BindData();
		}

		public void SetProps(System.Web.UI.WebControls.DataGrid DG)
		{
			/****************************************************************************/
			DG.Font.Size = 8;
			DG.Font.Bold = false;
			DG.Font.Name = "tahoma";

			/*******************************Professional 2**********************************/
			//Border Props 
			DG.GridLines = GridLines.Both;
			DG.CellPadding = 3;
			DG.CellSpacing = 0;
			DG.BorderColor = System.Drawing.Color.FromName("#CCCCCC");
			DG.BorderWidth = System.Web.UI.WebControls.Unit.Pixel(1);

			
			//Header Props
			DG.HeaderStyle.BackColor = System.Drawing.Color.SteelBlue;
			DG.HeaderStyle.ForeColor = System.Drawing.Color.White;
			DG.HeaderStyle.Font.Bold = true;
			DG.HeaderStyle.Font.Size = 8;
			DG.HeaderStyle.Font.Name = "tahoma";

			DG.ItemStyle.BackColor = System.Drawing.Color.LightSteelBlue;

		}

		#endregion

	
	}
}
