<%@ Page Language="VB" AutoEventWireup="false" CodeFile="ViewProductsByCategory.aspx.vb" Inherits="ViewProductsByCategory" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Tag Cloud Demo :: View Products by Category</title>
    <link href="StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div align="right">
        [<a href="TagCloudDemo.aspx">Back</a>]
    </div>
    <div>
        <asp:FormView ID="CategoryInfo" runat="server" DataSourceID="CategoriesDataSource">
            <ItemTemplate>
                <h1>Viewing Products for <asp:Literal runat="server" Text='<%# Eval("CategoryName") %>'></asp:Literal></h1>
                <p>
                    <asp:Label runat="Server" Font-Italic="True" Text='<%# Eval("Description") %>'></asp:Label>
                </p>
            </ItemTemplate>
        </asp:FormView>
        <asp:SqlDataSource ID="CategoriesDataSource" runat="server" ConnectionString="<%$ ConnectionStrings:NorthwindConnectionString %>"
            SelectCommand="SELECT [CategoryName], [Description] FROM [Categories] WHERE ([CategoryID] = @CategoryID)">
            <SelectParameters>
                <asp:QueryStringParameter Name="CategoryID" QueryStringField="CategoryID" Type="Int32" />
            </SelectParameters>
        </asp:SqlDataSource>
        
        <br /><br />
        <asp:GridView ID="ProductsInCategory" runat="server" AutoGenerateColumns="False" CellPadding="4"
            DataSourceID="ProductsInCategoryDataSource" ForeColor="#333333" GridLines="None">
            <FooterStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
            <Columns>
                <asp:BoundField DataField="ProductName" HeaderText="Product" SortExpression="ProductName" />
                <asp:BoundField DataField="UnitPrice" DataFormatString="{0:c}" HeaderText="Price"
                    HtmlEncode="False" SortExpression="UnitPrice" />
            </Columns>
            <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
            <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
            <PagerStyle BackColor="#FFCC66" ForeColor="#333333" HorizontalAlign="Center" />
            <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
            <AlternatingRowStyle BackColor="White" />
        </asp:GridView>
        <asp:SqlDataSource ID="ProductsInCategoryDataSource" runat="server" ConnectionString="<%$ ConnectionStrings:NorthwindConnectionString %>"
            SelectCommand="SELECT [ProductName], [UnitPrice] FROM [Alphabetical list of products] WHERE ([CategoryID] = @CategoryID)">
            <SelectParameters>
                <asp:QueryStringParameter Name="CategoryID" QueryStringField="CategoryID" Type="Int32" />
            </SelectParameters>
        </asp:SqlDataSource>
    
    </div>
    </form>
</body>
</html>
