Imports System.data

Partial Class TagCloudDemo
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            PopulateCloud()
        End If
    End Sub

    Private Sub PopulateCloud()
        CloudMarkup.Text = String.Empty

        'First, read data from SqlDataSource
        Dim cloudData As DataView = CType(CategoriesProductsBreakdownDataSource.Select(DataSourceSelectArguments.Empty), DataView)

        'We need to determine each category's weight... a lot of options here on how to do this...
        Const SpacerMarkup As String = " "      'The markup injected between each item in the cloud
        Dim FontScale() As String = {"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"}

        'All database column names are centralized here. To customize this, simply modify the column names here
        Const WeightColumnName As String = "NumberOfProducts"
        Const TextColumnName As String = "CategoryName"
        Const NavigateUrlColumnName As String = "CategoryID"
        Const NavigateUrlFormatString As String = "~/ViewProductsByCategory.aspx?CategoryID={0}"

        Dim minWeight As Decimal = Decimal.MaxValue, maxWeight As Decimal = Decimal.MinValue

        For Each row As DataRowView In cloudData
            Dim numProductsObj As Object = row(WeightColumnName)
            If Not Convert.IsDBNull(numProductsObj) Then
                Dim numProductsDec As Decimal = Convert.ToDecimal(numProductsObj)

                If numProductsDec < minWeight Then minWeight = numProductsDec
                If numProductsDec > maxWeight Then maxWeight = numProductsDec
            End If
        Next

        'Output each category, using a font size relative to its place on the scale
        Dim scaleUnitLength As Decimal = (maxWeight - minWeight + 1) / Convert.ToDecimal(FontScale.Length)

        For Each row As DataRowView In cloudData
            Dim numProductsObj As Object = row("NumberOfProducts")
            If Not Convert.IsDBNull(numProductsObj) Then
                Dim numProductsDec As Decimal = Convert.ToDecimal(numProductsObj)

                Dim scaleValue As Integer = Math.Truncate((numProductsDec - minWeight) / scaleUnitLength)
                CloudMarkup.Text &= String.Format("<a href=""{0}"" style=""font-size:{1};"">{2}</a>{3}", _
                                            Page.ResolveUrl(String.Format(NavigateUrlFormatString, row(NavigateUrlColumnName).ToString())), _
                                            FontScale(scaleValue), row(TextColumnName).ToString(), SpacerMarkup)
            End If
        Next

    End Sub
End Class
