<%@ Page Language="VB" AutoEventWireup="false" CodeFile="TagCloudDemo.aspx.vb" Inherits="TagCloudDemo" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Tag Cloud Demo</title>
    <link href="StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <h1>Tag Cloud Demo</h1>
    <div>
        This demo shows a <a href="http://en.wikipedia.org/wiki/Tag_cloud"><em>tag cloud</em></a> in action.
        Each category from the Northwinds table is listed, with its size relative to the number of products
        for each category. Clicking on a category takes you to a page that lists the products for the selected
        category.
    </div>
    <p>&nbsp;</p>
    <div class="CloudBox">
        <asp:SqlDataSource ID="CategoriesProductsBreakdownDataSource" runat="server" ConnectionString="<%$ ConnectionStrings:NorthwindConnectionString %>"
            SelectCommand="SELECT Categories.CategoryID, Categories.CategoryName, COUNT(Products.ProductID) AS NumberOfProducts FROM Categories INNER JOIN Products ON Categories.CategoryID = Products.CategoryID GROUP BY Categories.CategoryID, Categories.CategoryName ORDER BY Categories.CategoryName">
        </asp:SqlDataSource>
                
        <asp:Literal ID="CloudMarkup" runat="server"></asp:Literal>
    </div>
    <p>&nbsp;</p>
    <div>
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" BackColor="LightGoldenrodYellow"
            BorderColor="Tan" BorderWidth="1px" CellPadding="2" DataKeyNames="CategoryID"
            DataSourceID="CategoriesProductsBreakdownDataSource" ForeColor="Black" GridLines="None">
            <FooterStyle BackColor="Tan" />
            <Columns>
                <asp:BoundField DataField="CategoryName" HeaderText="Category" SortExpression="CategoryName" />
                <asp:BoundField DataField="NumberOfProducts" HeaderText="Number Of Products" ReadOnly="True"
                    SortExpression="NumberOfProducts">
                    <ItemStyle HorizontalAlign="Center" />
                </asp:BoundField>
            </Columns>
            <SelectedRowStyle BackColor="DarkSlateBlue" ForeColor="GhostWhite" />
            <PagerStyle BackColor="PaleGoldenrod" ForeColor="DarkSlateBlue" HorizontalAlign="Center" />
            <HeaderStyle BackColor="Tan" Font-Bold="True" />
            <AlternatingRowStyle BackColor="PaleGoldenrod" />
        </asp:GridView>
    
    </div>
    </form>
</body>
</html>
