Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols

<WebService(Namespace:="http://tempuri.org/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
<Global.Microsoft.VisualBasic.CompilerServices.DesignerGenerated()> _
Public Class RoleProvider
     Inherits System.Web.Services.WebService

    Protected Function GetProvider(ByVal providerName As String, ByVal applicationName As String) As System.Web.Security.RoleProvider
        Dim provider As System.Web.Security.RoleProvider
        If (Not providerName Is Nothing) And (Not System.Web.Security.Roles.Providers(providerName) Is Nothing) Then
            provider = System.Web.Security.Roles.Providers(providerName)
        Else
            provider = System.Web.Security.Roles.Provider
        End If

        If Not applicationName Is Nothing Then
            provider.ApplicationName = applicationName
        End If

        Return provider
    End Function

    <WebMethod()> _
    Public Sub AddUsersToRoles(ByVal providerName As String, ByVal applicationName As String, ByVal usernames() As String, ByVal roleNames() As String)
        GetProvider(providerName, applicationName).AddUsersToRoles(usernames, roleNames)
    End Sub

    <WebMethod()> _
    Public Sub CreateRole(ByVal providerName As String, ByVal applicationName As String, ByVal roleName As String)
        GetProvider(providerName, applicationName).CreateRole(roleName)
    End Sub

    <WebMethod()> _
    Public Function DeleteRole(ByVal providerName As String, ByVal applicationName As String, ByVal roleName As String, ByVal throwOnPopulatedRole As Boolean) As Boolean
        Return GetProvider(providerName, applicationName).DeleteRole(roleName, throwOnPopulatedRole)
    End Function

    <WebMethod()> _
    Public Function FindUsersInRole(ByVal providerName As String, ByVal applicationName As String, ByVal roleName As String, ByVal usernameToMatch As String) As String()
        Return GetProvider(providerName, applicationName).FindUsersInRole(roleName, usernameToMatch)
    End Function

    <WebMethod()> _
    Public Function GetAllRoles(ByVal providerName As String, ByVal applicationName As String) As String()
        Return GetProvider(providerName, applicationName).GetAllRoles()
    End Function

    <WebMethod()> _
    Public Function GetRolesForUser(ByVal providerName As String, ByVal applicationName As String, ByVal username As String) As String()
        Return GetProvider(providerName, applicationName).GetRolesForUser(username)
    End Function

    <WebMethod()> _
    Public Function GetUsersInRole(ByVal providerName As String, ByVal applicationName As String, ByVal roleName As String) As String()
        Return GetProvider(providerName, applicationName).GetUsersInRole(roleName)
    End Function

    <WebMethod()> _
    Public Function IsUserInRole(ByVal providerName As String, ByVal applicationName As String, ByVal username As String, ByVal roleName As String) As Boolean
        Return GetProvider(providerName, applicationName).IsUserInRole(username, roleName)
    End Function

    <WebMethod()> _
    Public Sub RemoveUsersFromRoles(ByVal providerName As String, ByVal applicationName As String, ByVal usernames() As String, ByVal roleNames() As String)
        GetProvider(providerName, applicationName).RemoveUsersFromRoles(usernames, roleNames)
    End Sub

    <WebMethod()> _
    Public Function RoleExists(ByVal providerName As String, ByVal applicationName As String, ByVal roleName As String) As Boolean
        Return GetProvider(providerName, applicationName).RoleExists(roleName)
    End Function

End Class
