Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.Collections.Generic

<WebService(Namespace:="http://tempuri.org/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
<Global.Microsoft.VisualBasic.CompilerServices.DesignerGenerated()> _
Public Class MembershipProvider
     Inherits System.Web.Services.WebService

    Protected Function GetProvider(ByVal providerName As String, ByVal applicationName As String) As System.Web.Security.MembershipProvider
        Dim provider As System.Web.Security.MembershipProvider
        If (Not providerName Is Nothing) And (Not System.Web.Security.Membership.Providers(providerName) Is Nothing) Then
            provider = System.Web.Security.Membership.Providers(providerName)
        Else
            provider = System.Web.Security.Membership.Provider
        End If

        If Not applicationName Is Nothing Then
            provider.ApplicationName = applicationName
        End If

        Return provider
    End Function

    Protected Function ConvertUser(ByVal user As System.Web.Security.MembershipUser) As MembershipUser
        If user Is Nothing Then
            Return Nothing
        End If
        Dim membershipUser As MembershipUser = New MembershipUser()
        membershipUser.Comment = user.Comment
        membershipUser.CreationDate = user.CreationDate
        membershipUser.Email = user.Email
        membershipUser.IsApproved = user.IsApproved
        membershipUser.IsLockedOut = user.IsLockedOut
        membershipUser.IsOnline = user.IsOnline
        membershipUser.LastActivityDate = user.LastActivityDate
        membershipUser.LastLockoutDate = user.LastLockoutDate
        membershipUser.LastLoginDate = user.LastLoginDate
        membershipUser.LastPasswordChangedDate = user.LastPasswordChangedDate
        membershipUser.PasswordQuestion = user.PasswordQuestion
        membershipUser.ProviderName = user.ProviderName
        membershipUser.ProviderUserKey = user.ProviderUserKey
        membershipUser.UserName = user.UserName
        Return membershipUser
    End Function

    Protected Function ConvertUser(ByVal provider As System.Web.Security.MembershipProvider, ByVal user As MembershipUser) As System.Web.Security.MembershipUser
        If user Is Nothing Then
            Return Nothing
        End If
        Dim membershipUser As New System.Web.Security.MembershipUser(provider.Name, _
            user.UserName, _
            user.ProviderUserKey, _
            user.Email, _
            user.PasswordQuestion, _
            user.Comment, _
            user.IsApproved, _
            user.IsLockedOut, _
            user.CreationDate, _
            user.LastLoginDate, _
            user.LastActivityDate, _
            user.LastPasswordChangedDate, _
            user.LastLockoutDate)
        Return membershipUser
    End Function

    Protected Function BuildUserList(ByVal collection As System.Web.Security.MembershipUserCollection) As List(Of MembershipUser)
        If collection Is Nothing Then
            Return Nothing
        End If
        Dim list As New List(Of MembershipUser)
        Dim user As System.Web.Security.MembershipUser
        For Each user In collection
            list.Add(ConvertUser(user))
        Next
        Return list
    End Function

    <WebMethod()> _
    Public Function ChangePassword(ByVal providerName As String, ByVal applicationName As String, _
        ByVal username As String, ByVal oldPassword As String, ByVal newPassword As String) As Boolean
        Return GetProvider(providerName, applicationName).ChangePassword(username, oldPassword, newPassword)
    End Function

    <WebMethod()> _
    Public Function ChangePasswordQuestionAndAnswer(ByVal providerName As String, ByVal applicationName As String, _
        ByVal username As String, ByVal password As String, ByVal newPasswordQuestion As String, _
        ByVal newPasswordAnswer As String) As Boolean
        Return GetProvider(providerName, applicationName).ChangePasswordQuestionAndAnswer(username, password, newPasswordQuestion, newPasswordAnswer)
    End Function

    <WebMethod()> _
    Public Function CreateUser(ByVal providerName As String, ByVal applicationName As String, ByVal username As String, _
    ByVal password As String, ByVal email As String, ByVal passwordQuestion As String, ByVal passwordAnswer As String, _
    ByVal isApproved As Boolean, ByVal providerUserKey As Object, _
    ByRef status As System.Web.Security.MembershipCreateStatus) As MembershipUser
        Return ConvertUser(GetProvider(providerName, applicationName).CreateUser(username, password, email, passwordQuestion, _
        passwordAnswer, isApproved, providerUserKey, status))
    End Function

    <WebMethod()> _
    Public Function DeleteUser(ByVal providerName As String, ByVal applicationName As String, ByVal username As String, _
    ByVal deleteAllRelatedData As Boolean) As Boolean
        Return GetProvider(providerName, applicationName).DeleteUser(username, deleteAllRelatedData)
    End Function

    <WebMethod()> _
    Public Function FindUsersByEmail(ByVal providerName As String, ByVal applicationName As String, _
    ByVal emailToMatch As String, ByVal pageIndex As Integer, ByVal pageSize As Integer, _
    ByRef totalRecords As Integer) As List(Of MembershipUser)
        Return BuildUserList(GetProvider(providerName, applicationName).FindUsersByEmail(emailToMatch, pageIndex, pageSize, totalRecords))
    End Function

    <WebMethod()> _
    Public Function FindUsersByName(ByVal providerName As String, ByVal applicationName As String, _
    ByVal usernameToMatch As String, ByVal pageIndex As Integer, ByVal pageSize As Integer, _
    ByRef totalRecords As Integer) As List(Of MembershipUser)
        Return BuildUserList(GetProvider(providerName, applicationName).FindUsersByName(usernameToMatch, pageIndex, pageSize, totalRecords))
    End Function

    <WebMethod()> _
    Public Function GetAllUsers(ByVal providerName As String, ByVal applicationName As String, _
    ByVal pageIndex As Integer, ByVal pageSize As Integer, ByRef totalRecords As Integer) As List(Of MembershipUser)
        Return BuildUserList(GetProvider(providerName, applicationName).GetAllUsers(pageIndex, pageSize, totalRecords))
    End Function

    <WebMethod()> _
    Public Function GetNumberOfUsersOnline(ByVal providerName As String, ByVal applicationName As String) As Integer
        Return GetProvider(providerName, applicationName).GetNumberOfUsersOnline()
    End Function

    <WebMethod()> _
    Public Function GetPassword(ByVal providerName As String, ByVal applicationName As String, _
    ByVal username As String, ByVal answer As String) As String
        Return GetProvider(providerName, applicationName).GetPassword(username, answer)
    End Function

    <WebMethod()> _
    Public Function GetUserByUserKey(ByVal providerName As String, ByVal applicationName As String, _
    ByVal providerUserKey As Object, ByVal userIsOnline As Boolean) As MembershipUser
        Return ConvertUser(GetProvider(providerName, applicationName).GetUser(providerName, userIsOnline))
    End Function

    <WebMethod()> _
    Public Function GetUserByUsername(ByVal providerName As String, ByVal applicationName As String, ByVal username As String, _
    ByVal userIsOnline As Boolean) As MembershipUser
        Return ConvertUser(GetProvider(providerName, applicationName).GetUser(username, userIsOnline))
    End Function

    <WebMethod()> _
    Public Function GetUserNameByEmail(ByVal providerName As String, ByVal applicationName As String, _
    ByVal email As String) As String
        Return GetProvider(providerName, applicationName).GetUserNameByEmail(email)
    End Function

    <WebMethod()> _
    Public Function ResetPassword(ByVal providerName As String, ByVal applicationName As String, _
    ByVal username As String, ByVal answer As String) As String
        Return GetProvider(providerName, applicationName).ResetPassword(username, answer)
    End Function

    <WebMethod()> _
    Public Function UnlockUser(ByVal providerName As String, ByVal applicationName As String, _
    ByVal userName As String) As Boolean
        Return GetProvider(providerName, applicationName).UnlockUser(userName)
    End Function

    <WebMethod()> _
    Public Sub UpdateUser(ByVal providerName As String, ByVal applicationName As String, ByVal user As MembershipUser)
        Dim provider As Security.MembershipProvider = GetProvider(providerName, applicationName)
        provider.UpdateUser(ConvertUser(provider, user))
    End Sub

    <WebMethod()> _
    Public Function ValidateUser(ByVal providerName As String, ByVal applicationName As String, _
    ByVal username As String, ByVal password As String) As Boolean
        GetProvider(providerName, applicationName).ValidateUser(username, password)
    End Function

End Class
