Public Class WebServiceRoleProvider
    Inherits System.Web.Security.RoleProvider

    Private service As New RoleProvider.RoleProvider()
    Private _ApplicationName As String
    Private _RemoteProviderName As String

    Public Overrides Property ApplicationName() As String
        Get
            Return _ApplicationName
        End Get
        Set(ByVal value As String)
            _ApplicationName = value
        End Set
    End Property

    Public Overrides Sub Initialize(ByVal name As String, ByVal config As System.Collections.Specialized.NameValueCollection)
        If Not config("roleProviderUri") Is Nothing Then
            service.Url = config("roleProviderUri")
        End If

        _ApplicationName = config("applicationName")
        If String.IsNullOrEmpty(_ApplicationName) Then
            _ApplicationName = ProviderUtility.GetDefaultAppName()
        End If

        _RemoteProviderName = config("remoteProviderName")

        MyBase.Initialize(name, config)
    End Sub

    Public Overrides Sub AddUsersToRoles(ByVal usernames() As String, ByVal roleNames() As String)
        service.AddUsersToRoles(_RemoteProviderName, _ApplicationName, usernames, roleNames)
    End Sub

    Public Overrides Sub CreateRole(ByVal roleName As String)
        service.CreateRole(_RemoteProviderName, _ApplicationName, roleName)
    End Sub

    Public Overrides Function DeleteRole(ByVal roleName As String, ByVal throwOnPopulatedRole As Boolean) As Boolean
        Return service.DeleteRole(_RemoteProviderName, _ApplicationName, roleName, throwOnPopulatedRole)
    End Function

    Public Overrides Function FindUsersInRole(ByVal roleName As String, ByVal usernameToMatch As String) As String()
        Return service.FindUsersInRole(_RemoteProviderName, _ApplicationName, roleName, usernameToMatch)
    End Function

    Public Overrides Function GetAllRoles() As String()
        Return service.GetAllRoles(_RemoteProviderName, _ApplicationName)
    End Function

    Public Overrides Function GetRolesForUser(ByVal username As String) As String()
        Return service.GetRolesForUser(_RemoteProviderName, _ApplicationName, username)
    End Function

    Public Overrides Function GetUsersInRole(ByVal roleName As String) As String()
        Return service.GetUsersInRole(_RemoteProviderName, _ApplicationName, roleName)
    End Function

    Public Overrides Function IsUserInRole(ByVal username As String, ByVal roleName As String) As Boolean
        Return service.IsUserInRole(_RemoteProviderName, _ApplicationName, username, roleName)
    End Function

    Public Overrides Sub RemoveUsersFromRoles(ByVal usernames() As String, ByVal roleNames() As String)
        service.RemoveUsersFromRoles(_RemoteProviderName, _ApplicationName, usernames, roleNames)
    End Sub

    Public Overrides Function RoleExists(ByVal roleName As String) As Boolean
        Return service.RoleExists(_RemoteProviderName, _ApplicationName, roleName)
    End Function
End Class
