Public Class WebServiceMembershipProvider
    Inherits System.Web.Security.MembershipProvider

    Private _EnablePasswordReset As Boolean
    Private _EnablePasswordRetrieval As Boolean
    Private _MaxInvalidPasswordAttempts As Integer
    Private _MinRequiredNonalphanumericCharacters As Integer
    Private _MinRequiredPasswordLength As Integer
    Private _PasswordAttemptWindow As Integer
    Private _PasswordFormat As System.Web.Security.MembershipPasswordFormat
    Private _PasswordStrengthRegularExpression As String
    Private _RequiresQuestionAndAnswer As Boolean
    Private _RequiresUniqueEmail As Boolean

    Private _ApplicationName As String
    Private _RemoteProviderName As String

    Private service As New MembershipProvider.MembershipProvider()

    Private Shared Function ConvertUser(ByVal user As System.Web.Security.MembershipUser) As MembershipProvider.MembershipUser
        If user Is Nothing Then
            Return Nothing
        End If
        Dim membershipUser As MembershipProvider.MembershipUser = New MembershipProvider.MembershipUser()
        membershipUser.Comment = user.Comment
        membershipUser.CreationDate = user.CreationDate
        membershipUser.Email = user.Email
        membershipUser.IsApproved = user.IsApproved
        membershipUser.IsLockedOut = user.IsLockedOut
        membershipUser.IsOnline = user.IsOnline
        membershipUser.LastActivityDate = user.LastActivityDate
        membershipUser.LastLockoutDate = user.LastLockoutDate
        membershipUser.LastLoginDate = user.LastLoginDate
        membershipUser.LastPasswordChangedDate = user.LastPasswordChangedDate
        membershipUser.PasswordQuestion = user.PasswordQuestion
        membershipUser.ProviderName = user.ProviderName
        membershipUser.ProviderUserKey = user.ProviderUserKey
        membershipUser.UserName = user.UserName
        Return membershipUser
    End Function

    Private Function ConvertUser(ByVal user As MembershipProvider.MembershipUser) As System.Web.Security.MembershipUser
        If user Is Nothing Then
            Return Nothing
        End If
        Dim membershipUser As New System.Web.Security.MembershipUser(Me.Name, _
            user.UserName, _
            user.ProviderUserKey, _
            user.Email, _
            user.PasswordQuestion, _
            user.Comment, _
            user.IsApproved, _
            user.IsLockedOut, _
            user.CreationDate, _
            user.LastLoginDate, _
            user.LastActivityDate, _
            user.LastPasswordChangedDate, _
            user.LastLockoutDate)
        Return membershipUser
    End Function

    Private Function BuildUserCollection(ByVal list() As MembershipProvider.MembershipUser) As System.Web.Security.MembershipUserCollection
        If list Is Nothing Then
            Return Nothing
        End If
        Dim collection As System.Web.Security.MembershipUserCollection = New System.Web.Security.MembershipUserCollection()
        Dim user As MembershipProvider.MembershipUser
        For Each user In list
            collection.Add(ConvertUser(user))
        Next
        Return collection
    End Function


    Public Overrides Sub Initialize(ByVal name As String, ByVal config As System.Collections.Specialized.NameValueCollection)
        If Not config("roleProviderUri") Is Nothing Then
            service.Url = config("roleProviderUri")
        End If
        _ApplicationName = config("applicationName")
        If String.IsNullOrEmpty(_ApplicationName) Then
            _ApplicationName = ProviderUtility.GetDefaultAppName()
        End If

        _EnablePasswordRetrieval = ProviderUtility.GetBooleanValue(config, "enablePasswordRetrieval", False)
        _EnablePasswordReset = ProviderUtility.GetBooleanValue(config, "enablePasswordReset", True)
        _RequiresQuestionAndAnswer = ProviderUtility.GetBooleanValue(config, "requiresQuestionAndAnswer", True)
        _RequiresUniqueEmail = ProviderUtility.GetBooleanValue(config, "requiresUniqueEmail", True)
        _MaxInvalidPasswordAttempts = ProviderUtility.GetIntValue(config, "maxInvalidPasswordAttempts", 5, False, 0)
        _PasswordAttemptWindow = ProviderUtility.GetIntValue(config, "passwordAttemptWindow", 10, False, 0)
        _MinRequiredPasswordLength = ProviderUtility.GetIntValue(config, "minRequiredPasswordLength", 7, False, 128)
        _MinRequiredNonalphanumericCharacters = ProviderUtility.GetIntValue(config, "minRequiredNonalphanumericCharacters", 1, True, 128)
        _PasswordStrengthRegularExpression = config("passwordStrengthRegularExpression")

        If Not config("passwordFormat") Is Nothing Then
            _PasswordFormat = CType([Enum].Parse(GetType(System.Web.Security.MembershipPasswordFormat), config("passwordFormat")), System.Web.Security.MembershipPasswordFormat)
        Else
            _PasswordFormat = System.Web.Security.MembershipPasswordFormat.Hashed
        End If

        _RemoteProviderName = config("remoteProviderName")

        MyBase.Initialize(name, config)
    End Sub

    '----------------------------------------------------------------
    ' Converted from C# to VB .NET using CSharpToVBConverter(1.2).
    ' Developed by: Kamal Patel (http://www.KamalPatel.net) 
    '----------------------------------------------------------------

    Public Overrides Property ApplicationName() As String
        Get
            Return _ApplicationName
        End Get
        Set(ByVal value As String)
            _ApplicationName = value
        End Set
    End Property

    Public Overrides Function ChangePassword(ByVal username As String, ByVal oldPassword As String, ByVal newPassword As String) As Boolean
        Return service.ChangePassword(_RemoteProviderName, _ApplicationName, username, oldPassword, newPassword)
    End Function

    Public Overrides Function ChangePasswordQuestionAndAnswer(ByVal username As String, ByVal password As String, ByVal newPasswordQuestion As String, ByVal newPasswordAnswer As String) As Boolean
        Return service.ChangePasswordQuestionAndAnswer(_RemoteProviderName, _ApplicationName, username, password, _
        newPasswordQuestion, newPasswordAnswer)
    End Function

    Public Overrides Function CreateUser(ByVal username As String, ByVal password As String, ByVal email As String, ByVal passwordQuestion As String, ByVal passwordAnswer As String, ByVal isApproved As Boolean, ByVal providerUserKey As Object, ByRef status As System.Web.Security.MembershipCreateStatus) As System.Web.Security.MembershipUser
        Dim newStatus As MembershipProvider.MembershipCreateStatus
        Dim user As System.Web.Security.MembershipUser = ConvertUser(service.CreateUser(_RemoteProviderName, _ApplicationName, username, password, email, _
        passwordQuestion, passwordAnswer, isApproved, providerUserKey, newStatus))
        status = CType([Enum].Parse(GetType(System.Web.Security.MembershipCreateStatus), newStatus.ToString()), System.Web.Security.MembershipCreateStatus)
        Return user
    End Function

    Public Overrides Function DeleteUser(ByVal username As String, ByVal deleteAllRelatedData As Boolean) As Boolean
        Return service.DeleteUser(_RemoteProviderName, _ApplicationName, username, deleteAllRelatedData)
    End Function

    Public Overrides ReadOnly Property EnablePasswordReset() As Boolean
        Get
            Return _EnablePasswordReset
        End Get
    End Property

    Public Overrides ReadOnly Property EnablePasswordRetrieval() As Boolean
        Get
            Return _EnablePasswordRetrieval
        End Get
    End Property

    Public Overrides Function FindUsersByEmail(ByVal emailToMatch As String, ByVal pageIndex As Integer, ByVal pageSize As Integer, ByRef totalRecords As Integer) As System.Web.Security.MembershipUserCollection
        Return BuildUserCollection(service.FindUsersByEmail(_RemoteProviderName, _ApplicationName, emailToMatch, pageIndex, _
        pageSize, totalRecords))
    End Function

    Public Overrides Function FindUsersByName(ByVal usernameToMatch As String, ByVal pageIndex As Integer, ByVal pageSize As Integer, ByRef totalRecords As Integer) As System.Web.Security.MembershipUserCollection
        Return BuildUserCollection(service.FindUsersByName(_RemoteProviderName, _ApplicationName, usernameToMatch, _
        pageIndex, pageSize, totalRecords))
    End Function

    Public Overrides Function GetAllUsers(ByVal pageIndex As Integer, ByVal pageSize As Integer, ByRef totalRecords As Integer) As System.Web.Security.MembershipUserCollection
        Return BuildUserCollection(service.GetAllUsers(_RemoteProviderName, _ApplicationName, pageIndex, pageSize, _
         totalRecords))
    End Function

    Public Overrides Function GetNumberOfUsersOnline() As Integer
        Return service.GetNumberOfUsersOnline(_RemoteProviderName, _ApplicationName)
    End Function

    Public Overrides Function GetPassword(ByVal username As String, ByVal answer As String) As String
        Return service.GetPassword(_RemoteProviderName, _ApplicationName, username, answer)
    End Function

    Public Overloads Overrides Function GetUser(ByVal providerUserKey As Object, ByVal userIsOnline As Boolean) As System.Web.Security.MembershipUser
        Return ConvertUser(service.GetUserByUserKey(_RemoteProviderName, _ApplicationName, providerUserKey, userIsOnline))
    End Function

    Public Overloads Overrides Function GetUser(ByVal username As String, ByVal userIsOnline As Boolean) As System.Web.Security.MembershipUser
        Return ConvertUser(service.GetUserByUsername(_RemoteProviderName, _ApplicationName, username, userIsOnline))
    End Function

    Public Overrides Function GetUserNameByEmail(ByVal email As String) As String
        Return service.GetUserNameByEmail(_RemoteProviderName, _ApplicationName, email)
    End Function

    Public Overrides ReadOnly Property MaxInvalidPasswordAttempts() As Integer
        Get
            Return _MaxInvalidPasswordAttempts
        End Get
    End Property

    Public Overrides ReadOnly Property MinRequiredNonAlphanumericCharacters() As Integer
        Get
            Return _MinRequiredNonalphanumericCharacters
        End Get
    End Property

    Public Overrides ReadOnly Property MinRequiredPasswordLength() As Integer
        Get
            Return _MinRequiredPasswordLength
        End Get
    End Property

    Public Overrides ReadOnly Property PasswordAttemptWindow() As Integer
        Get
            Return _PasswordAttemptWindow
        End Get
    End Property

    Public Overrides ReadOnly Property PasswordFormat() As System.Web.Security.MembershipPasswordFormat
        Get
            Return _PasswordFormat
        End Get
    End Property

    Public Overrides ReadOnly Property PasswordStrengthRegularExpression() As String
        Get
            Return _PasswordStrengthRegularExpression
        End Get
    End Property

    Public Overrides ReadOnly Property RequiresQuestionAndAnswer() As Boolean
        Get
            Return _RequiresQuestionAndAnswer
        End Get
    End Property

    Public Overrides ReadOnly Property RequiresUniqueEmail() As Boolean
        Get
            Return _RequiresUniqueEmail
        End Get
    End Property

    Public Overrides Function ResetPassword(ByVal username As String, ByVal answer As String) As String
        Return service.ResetPassword(_RemoteProviderName, _ApplicationName, username, answer)
    End Function

    Public Overrides Function UnlockUser(ByVal userName As String) As Boolean
        Return service.UnlockUser(_RemoteProviderName, _ApplicationName, userName)
    End Function

    Public Overrides Sub UpdateUser(ByVal user As System.Web.Security.MembershipUser)
        service.UpdateUser(_RemoteProviderName, _ApplicationName, ConvertUser(user))
    End Sub

    Public Overrides Function ValidateUser(ByVal username As String, ByVal password As String) As Boolean
        Return service.ValidateUser(_RemoteProviderName, _ApplicationName, username, password)
    End Function
End Class
