Imports System.Collections.Specialized

Public Class ProviderUtility

    Friend Shared Function GetDefaultAppName() As String
        Dim defPath As String
        Try
            Dim vPath As String = System.Web.Hosting.HostingEnvironment.ApplicationVirtualPath
            If String.IsNullOrEmpty(vPath) Then
                vPath = System.Diagnostics.Process.GetCurrentProcess().MainModule.ModuleName
                Dim num1 As Integer = vPath.IndexOf("."c)
                If num1 <> -1 Then
                    vPath = vPath.Remove(num1)
                End If
            End If
            If String.IsNullOrEmpty(vPath) Then
                Return "/"
            End If
            defPath = vPath
        Catch
            defPath = "/"
        End Try
        Return defPath
    End Function

    Friend Shared Function GetBooleanValue(ByVal config As NameValueCollection, ByVal valueName As String, ByVal defaultValue As Boolean) As Boolean
        Dim result As Boolean
        Dim valueToParse As String = config(valueName)
        If valueToParse Is Nothing Then
            Return defaultValue
        End If
        If Boolean.TryParse(valueToParse, result) Then
            Return result
        End If
        Throw New Exception("Value must be boolean")
    End Function

    Friend Shared Function GetIntValue(ByVal config As NameValueCollection, ByVal valueName As String, ByVal defaultValue As Integer, ByVal zeroAllowed As Boolean, ByVal maxValueAllowed As Integer) As Integer
        Dim result As Integer
        Dim valueToParse As String = config(valueName)
        If valueToParse Is Nothing Then
            Return defaultValue
        End If
        If Not Integer.TryParse(valueToParse, result) Then
            If zeroAllowed Then
                Throw New Exception("Value must be non negative integer")
            End If
            Throw New Exception("Value must be positive integer")
        End If
        If zeroAllowed And (result < 0) Then
            Throw New Exception("Value must be non negative integer")
        End If
        If Not zeroAllowed And (result <= 0) Then
            Throw New Exception("Value must be positive integer")
        End If
        If (maxValueAllowed > 0) And (result > maxValueAllowed) Then
            Throw New Exception("Value too big")
        End If
        Return result
    End Function

End Class
