using System;
using System.Web;
using System.Collections;
using System.Web.UI;
using System.Web.Services;
using System.Web.Services.Protocols;


/// <summary>
/// Summary description for RoleProvider
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class RoleProvider : System.Web.Services.WebService
{
  protected System.Web.Security.RoleProvider GetProvider(string providerName, string applicationName)
  {
    System.Web.Security.RoleProvider provider;
    if ((providerName != null) && (System.Web.Security.Roles.Providers[providerName] != null))
    {
      provider = System.Web.Security.Roles.Providers[providerName];
    }
    else
    {
      provider = System.Web.Security.Roles.Provider;
    }

    if (applicationName != null)
    {
      provider.ApplicationName = applicationName;
    }

    return provider;
  }

  public RoleProvider()
  {
  }

  [WebMethod(Description="")]
  public void AddUsersToRoles(string providerName, string applicationName, string[] usernames, string[] roleNames)
  {
    GetProvider(providerName, applicationName).AddUsersToRoles(usernames, roleNames);
  }

  [WebMethod(Description = "")]
  public void CreateRole(string providerName, string applicationName, string roleName)
  {
    GetProvider(providerName, applicationName).CreateRole(roleName);
  }

  [WebMethod(Description = "")]
  public bool DeleteRole(string providerName, string applicationName, string roleName, bool throwOnPopulatedRole)
  {
    return GetProvider(providerName, applicationName).DeleteRole(roleName, throwOnPopulatedRole);
  }

  [WebMethod(Description = "")]
  public string[] FindUsersInRole(string providerName, string applicationName, string roleName, string usernameToMatch)
  {
    return GetProvider(providerName, applicationName).FindUsersInRole(roleName, usernameToMatch);
  }

  [WebMethod(Description = "")]
  public string[] GetAllRoles(string providerName, string applicationName)
  {
    return GetProvider(providerName, applicationName).GetAllRoles();
  }

  [WebMethod(Description = "")]
  public string[] GetRolesForUser(string providerName, string applicationName, string username)
  {
    return GetProvider(providerName, applicationName).GetRolesForUser(username);
  }

  [WebMethod(Description = "")]
  public string[] GetUsersInRole(string providerName, string applicationName, string roleName)
  {
    return GetProvider(providerName, applicationName).GetUsersInRole(roleName);
  }

  [WebMethod(Description = "")]
  public bool IsUserInRole(string providerName, string applicationName, string username, string roleName)
  {
    return GetProvider(providerName, applicationName).IsUserInRole(username, roleName);
  }

  [WebMethod(Description = "")]
  public void RemoveUsersFromRoles(string providerName, string applicationName, string[] usernames, string[] roleNames)
  {
    GetProvider(providerName, applicationName).RemoveUsersFromRoles(usernames, roleNames);
  }

  [WebMethod(Description = "")]
  public bool RoleExists(string providerName, string applicationName, string roleName)
  {
    return GetProvider(providerName, applicationName).RoleExists(roleName);
  }
}

