using System;
using System.Collections.Generic;
using System.Text;
using System.Web.Security;

namespace ManyMonkeys.SecurityProviders
{
  /// <summary>
  /// a membership provider that uses a web service to access a remote credential store
  /// </summary>
  sealed public class WebServiceMembershipProvider : System.Web.Security.MembershipProvider
  {
    private MembershipProvider.MembershipProvider service;

    private bool _EnablePasswordReset;
    private bool _EnablePasswordRetrieval;
    private int _MaxInvalidPasswordAttempts;
    private int _MinRequiredNonalphanumericCharacters;
    private int _MinRequiredPasswordLength;
    private int _PasswordAttemptWindow;
    private MembershipPasswordFormat _PasswordFormat;
    private string _PasswordStrengthRegularExpression;
    private bool _RequiresQuestionAndAnswer;
    private bool _RequiresUniqueEmail;

    private string _ApplicationName;
    private string _RemoteProviderName;

    /// <summary>
    /// a constructor
    /// </summary>
    public WebServiceMembershipProvider()
    {
      service = new ManyMonkeys.SecurityProviders.MembershipProvider.MembershipProvider();
    }

    /// <summary>
    /// convert a user
    /// </summary>
    /// <param name="user">a user object</param>
    /// <returns>a converted user object</returns>
    static private MembershipProvider.MembershipUser ConvertUser(System.Web.Security.MembershipUser user)
    {
      if (user == null) return null;
      MembershipProvider.MembershipUser membershipUser = new MembershipProvider.MembershipUser();
      membershipUser.Comment = user.Comment;
      membershipUser.CreationDate = user.CreationDate;
      membershipUser.Email = user.Email;
      membershipUser.IsApproved = user.IsApproved;
      membershipUser.IsLockedOut = user.IsLockedOut;
      membershipUser.IsOnline = user.IsOnline;
      membershipUser.LastActivityDate = user.LastActivityDate;
      membershipUser.LastLockoutDate = user.LastLockoutDate;
      membershipUser.LastLoginDate = user.LastLoginDate;
      membershipUser.LastPasswordChangedDate = user.LastPasswordChangedDate;
      membershipUser.PasswordQuestion = user.PasswordQuestion;
      membershipUser.ProviderName = user.ProviderName;
      membershipUser.ProviderUserKey = user.ProviderUserKey;
      membershipUser.UserName = user.UserName;
      return membershipUser;
    }

    /// <summary>
    /// convert a user
    /// </summary>
    /// <param name="user">a user object</param>
    /// <returns>a converted user object</returns>
    private System.Web.Security.MembershipUser ConvertUser(MembershipProvider.MembershipUser user)
    {
      if (user == null) return null;
      System.Web.Security.MembershipUser membershipUser =
        new System.Web.Security.MembershipUser(this.Name,
          user.UserName,
          user.ProviderUserKey,
          user.Email,
          user.PasswordQuestion,
          user.Comment,
          user.IsApproved,
          user.IsLockedOut,
          user.CreationDate,
          user.LastLoginDate,
          user.LastActivityDate,
          user.LastPasswordChangedDate,
          user.LastLockoutDate);
      return membershipUser;
    }

    /// <summary>
    /// create a list of users
    /// </summary>
    /// <param name="list">a list of users</param>
    /// <returns>a converted list of users</returns>
    private System.Web.Security.MembershipUserCollection BuildUserCollection(MembershipProvider.MembershipUser[] list)
    {
      if (list == null) return null;
      System.Web.Security.MembershipUserCollection collection = new System.Web.Security.MembershipUserCollection();
      foreach (MembershipProvider.MembershipUser user in list)
      {
        collection.Add(ConvertUser(user));
      }
      return collection;
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override string ApplicationName
    {
      get
      {
        return _ApplicationName;
      }
      set
      {
        _ApplicationName = value;
      }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="name">a provider name</param>
    /// <param name="config">a collection of items</param>
    public override void Initialize(string name, System.Collections.Specialized.NameValueCollection config)
    {
      if (config["roleProviderUri"] != null)
      {
        service.Url = config["roleProviderUri"];
      }
      _ApplicationName = config["applicationName"];
      if (string.IsNullOrEmpty(_ApplicationName))
      {
        _ApplicationName = ProviderUtility.GetDefaultAppName();
      }

      _EnablePasswordRetrieval = ProviderUtility.GetBooleanValue(config, "enablePasswordRetrieval", false);
      _EnablePasswordReset = ProviderUtility.GetBooleanValue(config, "enablePasswordReset", true);
      _RequiresQuestionAndAnswer = ProviderUtility.GetBooleanValue(config, "requiresQuestionAndAnswer", true);
      _RequiresUniqueEmail = ProviderUtility.GetBooleanValue(config, "requiresUniqueEmail", true);
      _MaxInvalidPasswordAttempts = ProviderUtility.GetIntValue(config, "maxInvalidPasswordAttempts", 5, false, 0);
      _PasswordAttemptWindow = ProviderUtility.GetIntValue(config, "passwordAttemptWindow", 10, false, 0);
      _MinRequiredPasswordLength = ProviderUtility.GetIntValue(config, "minRequiredPasswordLength", 7, false, 0x80);
      _MinRequiredNonalphanumericCharacters = ProviderUtility.GetIntValue(config, "minRequiredNonalphanumericCharacters", 1, true, 0x80);
      _PasswordStrengthRegularExpression = config["passwordStrengthRegularExpression"];

      if (config["passwordFormat"] != null)
      {
        _PasswordFormat = (MembershipPasswordFormat)Enum.Parse(typeof(MembershipPasswordFormat), config["passwordFormat"]);
      }
      else
      {
        _PasswordFormat = MembershipPasswordFormat.Hashed;
      }

      _RemoteProviderName = config["remoteProviderName"];

      base.Initialize(name, config);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override bool EnablePasswordReset
    {
      get { return _EnablePasswordReset; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override bool EnablePasswordRetrieval
    {
      get { return _EnablePasswordRetrieval; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override int MaxInvalidPasswordAttempts
    {
      get { return _MaxInvalidPasswordAttempts; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override int MinRequiredNonAlphanumericCharacters
    {
      get { return _MinRequiredNonalphanumericCharacters; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override int MinRequiredPasswordLength
    {
      get { return _MinRequiredPasswordLength; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override int PasswordAttemptWindow
    {
      get { return _PasswordAttemptWindow; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override MembershipPasswordFormat PasswordFormat
    {
      get { return _PasswordFormat; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override string PasswordStrengthRegularExpression
    {
      get { return _PasswordStrengthRegularExpression; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override bool RequiresQuestionAndAnswer
    {
      get { return _RequiresQuestionAndAnswer; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    public override bool RequiresUniqueEmail
    {
      get { return _RequiresUniqueEmail; }
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">a username</param>
    /// <param name="oldPassword">original password</param>
    /// <param name="newPassword">new password</param>
    /// <returns>true or false</returns>
    public override bool ChangePassword(string username, string oldPassword, string newPassword)
    {
      return service.ChangePassword(_RemoteProviderName, _ApplicationName, username, oldPassword, newPassword);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">a username</param>
    /// <param name="password">the password</param>
    /// <param name="newPasswordQuestion">new question</param>
    /// <param name="newPasswordAnswer">new answer</param>
    /// <returns>true or false</returns>
    public override bool ChangePasswordQuestionAndAnswer(string username, string password, 
      string newPasswordQuestion, string newPasswordAnswer)
    {
      return service.ChangePasswordQuestionAndAnswer(_RemoteProviderName, _ApplicationName, username, password,
        newPasswordQuestion, newPasswordAnswer);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="password">required implementation</param>
    /// <param name="email">required implementation</param>
    /// <param name="passwordQuestion">required implementation</param>
    /// <param name="passwordAnswer">required implementation</param>
    /// <param name="isApproved">required implementation</param>
    /// <param name="providerUserKey">required implementation</param>
    /// <param name="status">required implementation</param>
    /// <returns>a user object</returns>
    public override MembershipUser CreateUser(string username, string password, string email, 
      string passwordQuestion, string passwordAnswer, bool isApproved, object providerUserKey, 
      out MembershipCreateStatus status)
    {
      MembershipProvider.MembershipCreateStatus newStatus;
      MembershipUser user = ConvertUser(service.CreateUser(_RemoteProviderName, _ApplicationName, username, password, email,
        passwordQuestion, passwordAnswer, isApproved, providerUserKey, out newStatus));
      status = (MembershipCreateStatus)Enum.Parse(typeof(MembershipCreateStatus), newStatus.ToString());
      return user;
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="deleteAllRelatedData">required implementation</param>
    /// <returns>required implementation</returns>
    public override bool DeleteUser(string username, bool deleteAllRelatedData)
    {
      return service.DeleteUser(_RemoteProviderName, _ApplicationName, username, deleteAllRelatedData);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="emailToMatch">required implementation</param>
    /// <param name="pageIndex">required implementation</param>
    /// <param name="pageSize">required implementation</param>
    /// <param name="totalRecords">required implementation</param>
    /// <returns>required implementation</returns>
    public override MembershipUserCollection FindUsersByEmail(string emailToMatch, int pageIndex, int pageSize, out int totalRecords)
    {
      return BuildUserCollection(service.FindUsersByEmail(_RemoteProviderName, _ApplicationName, emailToMatch, pageIndex,
        pageSize, out totalRecords));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="usernameToMatch">required implementation</param>
    /// <param name="pageIndex">required implementation</param>
    /// <param name="pageSize">required implementation</param>
    /// <param name="totalRecords">required implementation</param>
    /// <returns>required implementation</returns>
    public override MembershipUserCollection FindUsersByName(string usernameToMatch, int pageIndex, 
      int pageSize, out int totalRecords)
    {
      return BuildUserCollection(service.FindUsersByName(_RemoteProviderName, _ApplicationName, usernameToMatch, 
        pageIndex, pageSize, out totalRecords));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="pageIndex">required implementation</param>
    /// <param name="pageSize">required implementation</param>
    /// <param name="totalRecords">required implementation</param>
    /// <returns>required implementation</returns>
    public override MembershipUserCollection GetAllUsers(int pageIndex, int pageSize, 
      out int totalRecords)
    {
      return BuildUserCollection(service.GetAllUsers(_RemoteProviderName, _ApplicationName, pageIndex, pageSize,
        out totalRecords));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <returns>required implementation</returns>
    public override int GetNumberOfUsersOnline()
    {
      return service.GetNumberOfUsersOnline(_RemoteProviderName, _ApplicationName);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="answer">required implementation</param>
    /// <returns>required implementation</returns>
    public override string GetPassword(string username, string answer)
    {
      return service.GetPassword(_RemoteProviderName, _ApplicationName, username, answer);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="userIsOnline">required implementation</param>
    /// <returns>required implementation</returns>
    public override MembershipUser GetUser(string username, bool userIsOnline)
    {
      return ConvertUser(service.GetUserByUserName(_RemoteProviderName, _ApplicationName, username, userIsOnline));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="providerUserKey">required implementation</param>
    /// <param name="userIsOnline">required implementation</param>
    /// <returns>required implementation</returns>
    public override MembershipUser GetUser(object providerUserKey, bool userIsOnline)
    {
      return ConvertUser(service.GetUserByKey(_RemoteProviderName, _ApplicationName, providerUserKey, userIsOnline));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="email">required implementation</param>
    /// <returns>required implementation</returns>
    public override string GetUserNameByEmail(string email)
    {
      return service.GetUserNameByEmail(_RemoteProviderName, _ApplicationName, email);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="answer">required implementation</param>
    /// <returns>required implementation</returns>
    public override string ResetPassword(string username, string answer)
    {
      return service.ResetPassword(_RemoteProviderName, _ApplicationName, username, answer);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="userName">required implementation</param>
    /// <returns>required implementation</returns>
    public override bool UnlockUser(string userName)
    {
      return service.UnlockUser(_RemoteProviderName, _ApplicationName, userName);
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="user">required implementation</param>
    public override void UpdateUser(MembershipUser user)
    {
      service.UpdateUser(_RemoteProviderName, _ApplicationName, ConvertUser(user));
    }

    /// <summary>
    /// required implementation
    /// </summary>
    /// <param name="username">required implementation</param>
    /// <param name="password">required implementation</param>
    /// <returns>required implementation</returns>
    public override bool ValidateUser(string username, string password)
    {
      return service.ValidateUser(_RemoteProviderName, _ApplicationName, username, password);
    }
  }
}
