using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// This page displays the names of all the authenticated users
/// </summary>
public partial class AuthenticatedUsersPage : BasePage
{
    /// <summary>
    /// Chargement de la page
    /// </summary>
    /// <param name="e"></param>
    protected override void OnLoad(EventArgs e)
    {
        base.OnLoad(e);
        if (!IsPostBack) DisplayAuthenticatedUsers();
    }

    /// <summary>
    /// Affiche la liste des utilisateurs connect dans le libell appropri
    /// </summary>
    private void DisplayAuthenticatedUsers()
    {
        List<string> authenticatedUsersList = AuthenticatedUsersList;
        if (authenticatedUsersList.Count > 0)
        {
            foreach (string user in authenticatedUsersList)
            {
                lblAuthenticatedUsers.Text += string.Format("<li>{0}</li><br />", user);
            }
        }
        else lblAuthenticatedUsers.Text = "No one is authenticated";
    }
}
