using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Stores the authenticated users in a string List
/// </summary>
public class BasePage : Page
{
    /// <summary>
    /// Triggers everytime a page loads
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        //If the page loads for the first time and if the current user is authenticated, we add him to the authenticated users' list
        if (!IsPostBack &&  HttpContext.Current.Request.IsAuthenticated) RegisterUser();
    }

    /// <summary>
    /// Adds the current user's name to the authenticated users' list
    /// </summary>
    protected void RegisterUser()
    {
        //We retrieve the list of the authenticated users
        List<string> authenticatedUsers = AuthenticatedUsersList;

        if (!authenticatedUsers.Contains(UserName))
        {
            //If the current user is not already in the authenticated users' list, we add him to the list
            authenticatedUsers.Add(UserName);

            //Then we save the authenticated users' list
            AuthenticatedUsersList = authenticatedUsers;
        }
    }

    /// <summary>
    /// Gets or sets a list of all the authenticated users
    /// </summary>
    protected List<string> AuthenticatedUsersList
    {
        get
        {
            //If the Cache is empty, we add an empty List in it
            if (Cache["AuthenticatedUsers"] == null)
                Cache["AuthenticatedUsers"] = new List<string>();
            return (List<string>)Cache["AuthenticatedUsers"];
        }
        set { Cache["AuthenticatedUsers"] = value; }
    }

    /// <summary>
    /// Gets the current user's name
    /// </summary>
    protected string UserName
    {
        get
        {
            //If you don't want to use the Identity.Name object, you should store the UserName in a Session variable in the Login page.
            //Then use something like Session["UserName"].ToString() to retrieve it.
            return HttpContext.Current.Request.IsAuthenticated 
                ? HttpContext.Current.User.Identity.Name 
                : string.Empty;
        }
    }
}
