<%@ WebService Language="C#" Class="AuthenticatedUsersWebService" %>

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.Caching;
using System.Web.Services;
using System.Web.Services.Protocols;
using Microsoft.Web.Script.Services;


[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[ScriptService()]
public class AuthenticatedUsersWebService : WebService 
{
    /// <summary>
    /// Gets the System.Web.Caching.Cache object for the current application domain
    /// </summary>
    private Cache cache = HttpContext.Current.Cache;

    /// <summary>
    /// Removes the current user from the authenticated users' list
    /// </summary>
    [WebMethod(EnableSession = true)]
    public void UnregisterUser()
    {
      string userName = Session["UserName"] != null ? Session["UserName"].ToString() : string.Empty;
      List<string> authenticatedUsers = cache["AuthenticatedUsers"] != null 
        ? (List<string> )cache["AuthenticatedUsers"]
        : new List<string>();
      if (authenticatedUsers.Contains(userName)) authenticatedUsers.Remove(userName);
      cache["AuthenticatedUsers"] = authenticatedUsers;
    }    
}