SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[adrp_Cache](
	[CacheId] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationId] [nvarchar](256) NOT NULL,
	[CacheType] [nchar](1) NOT NULL,
	[CacheKey] [nvarchar](256) NOT NULL,
	[CacheValue] [ntext] NULL,
	[ExpireDT] [datetime] NOT NULL,
 CONSTRAINT [PK_adrp_Cache] PRIMARY KEY CLUSTERED 
(
	[CacheId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE NONCLUSTERED INDEX [IX_adrp_Cache] ON [dbo].[adrp_Cache] 
(
	[ApplicationId] ASC,
	[CacheType] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]

CREATE PROCEDURE [dbo].[adrp_GetCacheItem]
	@parmApplicationID nvarchar(256),
	@parmCacheKey nvarchar(256),
	@parmCacheType nchar(1),
	@parmCacheValue ntext Output
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	Declare @CacheId int
	Set @CacheId = 0
	Select @CacheId = CacheId From adrp_Cache Where ApplicationId = @parmApplicationId And CacheType = @parmCacheType And CacheKey = @parmCacheKey
	-- Use CacheId (PK) for remaining lookups for performance

	If (@CacheId = 0)
		Begin
			Set @parmCacheValue = '*NotCached'
			Return (1)  -- Item not cached
		End
	Declare @ExpireDT DateTime
	Select @ExpireDT = ExpireDT From adrp_Cache Where CacheId = @CacheId
	If (GETDATE() >= @ExpireDT)
		Begin
			Delete From adrp_Cache Where CacheId = @CacheId
			Set @parmCacheValue = '*NotCached'
			Return (1)  -- Item cache is expired, i.e. Item not cached
		End

	Select @parmCacheValue = CacheValue From adrp_Cache Where CacheId = @CacheId
	Return (0) -- Item cache returned
END


CREATE PROCEDURE [dbo].[adrp_SetCacheItem]
	@parmApplicationID nvarchar(256),
	@parmCacheKey nvarchar(256),
	@parmCacheType nchar(1),
	@parmCacheTimeout int,
	@parmCacheValue ntext
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	Delete From adrp_Cache Where ApplicationId = @parmApplicationId And CacheType = @parmCacheType And CacheKey = @parmCacheKey
	Insert Into adrp_Cache (ApplicationId, CacheType, CacheKey, CacheValue, ExpireDT)
		Values (@parmApplicationId, @parmCacheType, @parmCacheKey, @parmCacheValue, DateAdd(minute, @parmCacheTimeout, GETDATE()))
END
