namespace Emoticons
{
	using System;
	using System.Collections;
	using System.ComponentModel;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.SessionState;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	/////////////////////////////////////////////////////////////////////////

	public class Index : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox				UserTextControl;
		protected System.Web.UI.WebControls.Button				CmdSend;
		protected System.Web.UI.HtmlControls.HtmlGenericControl	UserResultPanel;
		protected System.Web.UI.WebControls.Label				UserResultControl;
		protected System.Web.UI.WebControls.Repeater			HelpRepeater;

		// --

		private void Page_Load(object sender, System.EventArgs e)
		{
			HelpRepeater.DataSource = CreateDataSource();
			HelpRepeater.DataBind();

			// Auto detect default text.
			if ( !IsPostBack )
			{
				if ( UserTextControl.Text.Length>0 )
					CmdSend_Click( null, null );
			}
		}

		private void CmdSend_Click(object sender, System.EventArgs e)
		{
			// Put the text that the user entered into the label with 
			// emoticons expanded.
			string text = FormatMultiline( UserTextControl.Text );
			text = Emoticon.Format( text );

			UserResultControl.Text = text;

			UserResultPanel.Visible = true;
		}

		#region Web Form-Designer generated Code
		// ------------------------------------------------------------------

		override protected void OnInit(EventArgs e)
		{
			InitializeComponent();
			base.OnInit(e);
		}
		
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
			this.CmdSend.Click += new System.EventHandler(this.CmdSend_Click);
		}

		// ------------------------------------------------------------------
		#endregion

		// Replaces \r\n by HTML equivalent (<br />).
		private string FormatMultiline( string text )
		{
			if ( text==null )
				return "";

			string result = text;
			if ( result.Length>0 )
			{
				result = result.Replace( "\r\n", "\n" );
				result = result.Replace( "\r", "\n" );
				result = result.Replace( "\n", "<br />" );
				return result;
			}
			else
				return text;
		}

		/// <summary>
		/// Get the data source for the repeater that displays
		/// all available emoticons.
		/// </summary>
		private ICollection CreateDataSource()
		{
			ArrayList result = new ArrayList();

			Emoticon[] all = Emoticon.All;

			foreach ( Emoticon e in all )
			{
				result.Add( new ResultItem( e ) );
			}

			return result;
		}

		/////////////////////////////////////////////////////////////////////

		/// <summary>
		/// One item in the repeater that displays all available emoticons.
		/// </summary>
		protected class ResultItem : Emoticon
		{
			public ResultItem( Emoticon e ) :
				base(e)
			{
			}

			public string EmoticonImageUrl
			{
				get
				{
					return base.VirtualPath;
				}
			}

			public string EmoticonShortcut
			{
				get
				{
					return base.Shortcut;
				}
			}

			public string EmoticonTitle
			{
				get
				{
					return base.Title;
				}
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////
}