using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Net.Mail;
using System.Xml.Xsl;
using System.Text;
using System.IO;
using System.Data.SqlClient;

/*
 *    An example of how to create a contact form and send an email 
 *    using an XML and XSLT and how to preform the XSL transform
 *    using the XSLcompiled transform
 * 
 *    Author : Gary Woodfine
 * 
 * 
 * 
 * 
 * 
 */

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }
    protected void btnSend_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            XmlDocument xmlDoc = GetEmailDocument();
            SaveEmail(xmlDoc);
            SendEmail(xmlDoc);
         }


    }
    /// <summary>
    /// Build an Email document with all the details the user has input in the form
    /// </summary>
    /// <returns>XML Document</returns>
    private XmlDocument GetEmailDocument()
    {
        // We create an xmlDocument with a root node of "Email"
        XmlDocument xmlDoc = new XmlDocument();
        XmlNode xmlnode;
        xmlnode = xmlDoc.CreateElement("Root");
        xmlDoc.AppendChild(xmlnode);
        GetFormData(pnlEmail, xmlDoc);
        return xmlDoc;
    }
    /// <summary>
    /// Use recursion to iterate through the Control container Collection 
    /// and retrieve any information we may require
    /// </summary>
    /// <param name="Parent">Container COntrol</param>
    /// <param name="xmlDoc">An instance of a XMLDocument</param>
    protected void GetFormData(Control Parent, XmlDocument xmlDoc)
    {
        XmlNode xmlnode;
        foreach (Control wc in Parent.Controls)
        {
            if (wc.Controls.Count > 0) GetFormData(wc, xmlDoc);
            switch (wc.GetType().FullName.ToString())
            {
                case "System.Web.UI.WebControls.TextBox":
                    TextBox txt = (TextBox)wc;
                    xmlnode = xmlDoc.CreateElement(txt.ID.Substring(3).ToString());
                    xmlnode.InnerText = Server.HtmlEncode(txt.Text);
                    xmlDoc.DocumentElement.AppendChild(xmlnode);
                    break;
                case "System.Web.UI.WebControls.DropDownList":
                    DropDownList ddl = (DropDownList)wc;
                    xmlnode = xmlDoc.CreateElement(ddl.ID.Substring(3).ToString());
                    xmlnode.InnerText = ddl.SelectedValue.ToString();
                    xmlDoc.DocumentElement.AppendChild(xmlnode);
                    break;
            }
        }
    }
    /// <summary>
    /// Save an XML file to the database
    /// </summary>
    /// <param name="xmlDoc"></param>
    private void SaveEmail(XmlDocument xmlDoc)
    {
        // I use a simple connection string here as this is a simple project but you can do what ever you want
        using (SqlConnection oConn = new SqlConnection("Data Source=(local);Initial Catalog=sendemailxslt;Integrated Security=True;Pooling=False"))
        using(SqlCommand oComm = new SqlCommand())
        {
            // We insert the Data into the Database
           oConn.Open();
           oComm.Connection = oConn;
           oComm.CommandType = CommandType.StoredProcedure;
           oComm.CommandText = "spAddEmailContact";
           oComm.Parameters.Add("@xmlDoc",SqlDbType.Text).Value = xmlDoc.OuterXml.ToString();
          string sRes= oComm.ExecuteScalar().ToString();

          // We now Append the ID returned from the Query to The XMl Document
          XmlNode xmlnode;
          xmlnode = xmlDoc.CreateElement("ContactID");
          xmlnode.InnerText = sRes;
          xmlDoc.DocumentElement.AppendChild(xmlnode);
        }
   }

    /// <summary>
    /// Send and Email with XMl File 
    /// </summary>
    /// <param name="xmlDoc"></param>
    /// 
    private void SendEmail(XmlDocument xmlDoc)
    {
        System.Text.StringBuilder sb = new System.Text.StringBuilder();
        XslCompiledTransform xslt = new XslCompiledTransform();
        xslt.Load(Server.MapPath("App_Data/email.xsl"));
        using (XmlTextWriter xtw = new XmlTextWriter(new StringWriter(sb)))
         {
            xslt.Transform(xmlDoc, xtw);
            xtw.Flush();
         }
           SmtpClient oMail = new SmtpClient();
           MailMessage msg = new MailMessage();
            try
            {
                MailAddress Madd = new MailAddress(txtEmail.Text, txtFirstName.Text);
                oMail.Host = "localhost";
                oMail.Port = 25;
                msg.From = Madd;
                msg.To.Add("someone@somewhere.com");
                msg.Subject = ddlSubject.SelectedValue.ToString();
                msg.IsBodyHtml = true;
                msg.Body = sb.ToString();
                oMail.Send(msg);
                Server.Transfer("sent.aspx");
            }
            catch (Exception ex)
            {
                //This step is not good practice but seen as thought this is just a Demo
                //app I thought I would place this here so we can see if any errors occur
                lblFail.Visible = true;
                lblFail.Text = "An Error occurred:" + ex.Message;
            }
        

    }


}
