<%@ Page Language="VB" ValidateRequest="false" %>
<%@ Assembly Name="ADODB" %>
<%@ Import   Namespace="ADODB" %>
<%@ Import   Namespace="System.Data" %>
<%@ Import   Namespace="System.Text.RegularExpressions" %>
<script runat="server">
	' ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- -----
	' Scaricato da http://www.mrwebmaster.it
	' Autore: Luca Ruggiero - http://www.lukeonweb.net - http://www.webdevindex.net
	' ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- -----

	Private cn As New ADODB.Connection
	Private rs As New ADODB.Recordset

	Private Sub Page_Load(sender As Object, e As EventArgs)
		cn.Open("driver={Microsoft Access Driver (*.mdb)};dbq=" _
		& Server.MapPath("database.mdb"))
		rs.Open("SELECT * FROM guestbook ORDER BY id DESC", cn, 1)
		If rs.EOF Then
			Messaggi.Text = "Nessun messaggio presente"
		Else
			Dim i As Integer = 1
			Dim pag As Integer = Request.QueryString("pag")
			If isNumeric(pag) = False Or pag < 1 Then pag = 1
			rs.PageSize = 10
			rs.AbsolutePage = pag
			Messaggi.Text = ""
			While rs.EOF = False And pag < 10
				With Messaggi
					.Text += "<div class='TITOLO'><b>"
					.Text += "Messaggio di "
					.Text += "<a href='mailto:" & rs("email").Value & "'>"
					.Text += Server.HTMLEncode(rs("nome").Value)
					.Text += "</a></b> "
					.Text += "(<i>" & rs("data").Value & "</i>)"
					.Text += "</div>"
					.Text += "<div class='MSG'>"
					.Text += rs("messaggio").Value
					.Text += "</div><br>"
				End With
				rs.MoveNext()
			End While
			Menu.Text = ""
			For i = 1 To rs.PageCount
				Menu.Text += "[<a href='guestbook.aspx?pag=" & i & "'>" & i & "</a>]"
			Next
		End If
		rs.Close()
		cn.Close()
	End Sub

	Private Sub Firma(sender As Object, e As EventArgs)
		Dim re As New Regex("(?<user>[^@]+)@(?<host>.+)")
		Dim nome As String = Replace(txtNome.Text, "'", "''")
		Dim email As String = txtEmail.Text
		Dim messaggio As String
		messaggio = Replace( _
					Replace( _
					Replace( _
					txtMessaggio.Text, "<", "&lt;"), vbCrLf, "<br>"), "'", "''")
		If Len(Trim(nome)) = 0 Then
			Messaggi.Text = "Inserisci il tuo nome"
			Exit Sub
		End If
		If re.IsMatch(email) = False Then
			Messaggi.Text = "Inserisci il tuo indirizzo email"
			Exit Sub
		End If
		If Len(Trim(messaggio)) = 0 Then
			Messaggi.Text = "Inserisci il messaggio"
			Exit Sub
		End If
		Dim data As String = FormatDateTime(Now(), 1)
		Dim SQL As String = ""
			SQL += "INSERT INTO guestbook "
			SQL += "(nome, email, messaggio, data) "
			SQL += "VALUES "
			SQL += "('" & nome & "', "
			SQL += "'" & email & "', "
			SQL += "'" & messaggio & "', "
			SQL += "'" & data & "')"
		cn.Open("driver={Microsoft Access Driver (*.mdb)};dbq=" _
		& Server.MapPath("database.mdb"))
		cn.Execute(SQL)
		cn.Close()
		Response.Redirect("guestbook.aspx")
	End Sub
</script>
<html>
	<head>
		<title>Un Guestbook in ASP.NET, Access e ADO</title>
		<style type="text/css">
			td, div
			{
				font: Normal 12px Verdana;
			}
			div.TITOLO
			{
				background-color: #EEEEEE;
				padding: 5px;
				border-bottom: Solid 1px #CCCCCC;
			}
			div.MSG
			{
				padding: 5px;
				border-bottom: Solid 1px #CCCCCC;
			}
			a
			{
				color: #0000FF;
				text-decoration: None;
			}
			a:hover
			{
				color: #FF0000;
				text-decoration: Underline;
			}
		</style>
	</head>
<body>

<h1 align="center">GUESTBOOK</h1>

<form id="Modulo" runat="server">
	<table width="500" align="center">
		<tr>
			<td width="150">Nome</td>
			<td width="350">
				<asp:TextBox
					id="txtNome"
					runat="server"
					MaxLength="50"
					Width="100%" />
			</td>
		</tr>
		<tr>
			<td>Email</td>
			<td>
				<asp:TextBox
					id="txtEmail"
					runat="server"
					MaxLength="50"
					Width="100%" />
			</td>
		</tr>
		<tr>
			<td colspan="2">Messaggio</td>
		</tr>
		<tr>
			<td colspan="2">
				<asp:TextBox
					id="txtMessaggio"
					runat="server"
					TextMode="Multiline"
					Width="100%"
					Height="150px" />
			</td>
		</tr>
		<tr>
			<td colspan="2" align="right">
				<asp:Button
					runat="server"
					Text="Firma"
					OnClick="Firma" />
			</td>
		</tr>
	</table>
	<br>
	<table width="500" align="center">
		<tr>
			<td><asp:Label id="Messaggi" runat="server" /></td>
		</tr>
	</table><br>
	<div align="center"><asp:Label id="Menu" runat="server" /></div>
</form>

<!-- PER FAVORE NON CANCELLARE QUESTO LINK -->
<p>Powered by <a href="http://www.mrwebmaster.it">MR Webmaster</a></p>

</body>
</html>
