<?xml version="1.0" encoding="ISO-8859-1" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name='upperbound'>2</xsl:param>
<xsl:param name='lowerbound'>1</xsl:param>

	<xsl:template match="/">
		<table border="0" width="100%">
			<tr>
				<td bgcolor="#6699CC">
					<table border="0" width="100%">
						<tr>
							<td bgcolor="ffffff">
								<table border="0" width="100%">
									<td>
										<xsl:for-each select="//guest[position() &lt;= $upperbound and position() &gt;= $lowerbound]">
											<xsl:apply-templates select="name"/>											
										</xsl:for-each>
									</td>							
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="name">
		<TABLE width="100%" border="0">
			<TR valign="top">
				<TD style="WIDTH: 141px" width="141">
					<font face="verdana" size="2" color="#6699CC">
						<b>Name</b>
					</font>
				</TD>
				<TD>
					<xsl:choose>
						<xsl:when test="../@private='yes'">
							<font face="verdana" size="2">
								<b><xsl:value-of select='.' /></b>
							</font>
						</xsl:when>
						<xsl:otherwise>
							<font face="verdana" size="2">
								<b><a HREF="mailto:{../email}"><xsl:value-of select='.' /></a></b>
							</font>
						</xsl:otherwise>
					</xsl:choose>				
				</TD>
				<td align='right'><xsl:apply-templates select="../date"/></td>
			</TR>
			<xsl:apply-templates select="../homepage"/>
			<TR valign="top">
				<TD style="WIDTH: 141px" width="141">
					<font face="verdana" size="2" color="#6699CC">
						<b>Location</b>
					</font>
				</TD>
				<TD bgColor="#ffffff" colspan='2'>
					<xsl:apply-templates select="../location"/>
				</TD>
			</TR>
			<TR valign="top">
				<TD style="WIDTH: 141px" width="141">
					<font face="verdana" size="2" color="#6699CC">
						<b>Comment</b>
					</font>
				</TD>
				<TD bgColor="#ffffff" colspan='2'>
					<xsl:apply-templates select="../comment"/>
				</TD>
			</TR>
		</TABLE>
		<hr/>
	</xsl:template>

	<xsl:template match="email">
	</xsl:template>

	<xsl:template match="location">
		<font face="verdana" size="2">
			<xsl:value-of select='.' /><br/>
		</font>
	</xsl:template>

	<xsl:template match="homepage">
		<xsl:if test="string-length()!=0">
			<TR valign="top">
				<TD style="WIDTH: 141px" width="141">
					<font face="verdana" size="2" color="#6699CC">
						<b>Homepage</b>
					</font>
				</TD>
				<TD bgColor="#ffffff" colspan='2'>
					<font face="verdana" size="2">
						<a HREF="{@url}" target="_blank"><xsl:value-of select='.' /></a>
					</font>
				</TD>
			</TR>
		</xsl:if>
	</xsl:template>

	<xsl:template match="comment">
		<font face="verdana" size="2">
			<xsl:value-of select='.' />
		</font>
	</xsl:template>

	<xsl:template match="date">
			<font face="verdana" size="1"><xsl:value-of select='.' /></font>
	</xsl:template>

</xsl:stylesheet>
