using System;
using System.IO;
using System.Text;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Xml.XPath;

namespace Guestbook
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox TextBoxName;
		protected System.Web.UI.WebControls.TextBox TextBoxEMail;
		protected System.Web.UI.WebControls.Label Label2;
		protected System.Web.UI.WebControls.TextBox TextBoxHomepageTitle;
		protected System.Web.UI.WebControls.Label Label3;
		protected System.Web.UI.WebControls.TextBox TextBoxHomepageURL;
		protected System.Web.UI.WebControls.Label Label4;
		protected System.Web.UI.WebControls.TextBox TextBoxLocation;
		protected System.Web.UI.WebControls.Label Label5;
		protected System.Web.UI.WebControls.TextBox TextBoxComments;
		protected System.Web.UI.WebControls.Label Label6;
		protected System.Web.UI.WebControls.CheckBox CheckBoxPrivate;
		protected System.Web.UI.WebControls.Button ButtonContinue;
		protected System.Web.UI.HtmlControls.HtmlForm Form1;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator4;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator1;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator2;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator3;
		protected System.Web.UI.WebControls.RegularExpressionValidator RegularExpressionValidator1;
		protected System.Web.UI.WebControls.Label Label1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ButtonContinue.Click += new System.EventHandler(this.ButtonContinue_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void ButtonContinue_Click(object sender, System.EventArgs e)
		{
			//Load guestbook database
			XmlDocument xmldoc = new XmlDocument();
			xmldoc.Load( Server.MapPath("guestbook.xml") );

			//Get private status
			string strPrivate;
			if ( CheckBoxPrivate.Checked )
				strPrivate = "yes";
			else
				strPrivate = "no";

			//Create a new element
			XmlElement elem = xmldoc.CreateElement("guest");
			elem.SetAttribute("private", strPrivate);

			//Add the new guest as the first node
			xmldoc.DocumentElement.PrependChild(elem);

			addTextElement( xmldoc, elem, "name", TextBoxName.Text );
			addTextElement( xmldoc, elem, "email", TextBoxEMail.Text );
			addTextElement( xmldoc, elem, "homepage", TextBoxHomepageTitle.Text );

			XmlAttribute newAttr = xmldoc.CreateAttribute("url");
			newAttr.Value = TextBoxHomepageURL.Text;

			elem.LastChild.Attributes.Append( newAttr );
			
			addTextElement( xmldoc, elem, "location", TextBoxLocation.Text );
			addTextElement( xmldoc, elem, "comment", TextBoxComments.Text );

			//Write date
			string strDate = DateTime.Now.ToLongDateString() + 
				" - " + 
				DateTime.Now.ToLongTimeString(); 

			addTextElement( xmldoc, elem, "date", strDate );

			xmldoc.Save( Server.MapPath("guestbook.xml") );

			Response.Redirect("view.aspx");
		}

		private void addTextElement( XmlDocument doc, XmlElement nodeParent, string strTag, string strValue )
		{
			XmlElement nodeElem = doc.CreateElement( strTag );
			XmlText nodeText = doc.CreateTextNode( strValue );
			nodeParent.AppendChild( nodeElem );
			nodeElem.AppendChild( nodeText );
		} 

	}
}
