﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Text.RegularExpressions;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        btnSubmit.Click += new EventHandler(btnSubmit_Click);
    }

    void btnSubmit_Click(object sender, EventArgs e)
    {
        PasswordSetting passwordSetting = Helper.GetPasswordSetting();
        StringBuilder sbPasswordRegx = new StringBuilder(string.Empty);

        //min and max
        sbPasswordRegx.Append(@"(?=^.{" + passwordSetting.MinLength + "," + passwordSetting.MaxLength + "}$)");

        //numbers length
        sbPasswordRegx.Append(@"(?=(?:.*?\d){" + passwordSetting.NumsLength + "})");

        //a-z characters
        sbPasswordRegx.Append(@"(?=.*[a-z])");

        //A-Z length
        sbPasswordRegx.Append(@"(?=(?:.*?[A-Z]){" + passwordSetting.UpperLength + "})");

        //special characters length
        sbPasswordRegx.Append(@"(?=(?:.*?[" + passwordSetting.SpecialChars + "]){" + passwordSetting.SpecialLength + "})");

        //(?!.*\s) - no spaces
        //[0-9a-zA-Z!@#$%*()_+^&] -- valid characters
        sbPasswordRegx.Append(@"(?!.*\s)[0-9a-zA-Z" + passwordSetting.SpecialChars + "]*$");

        if (Regex.IsMatch(txtPassword.Text, sbPasswordRegx.ToString()))
        {
            ResultLabel.Text = "Password confront password policy!";
        }
        else
        {
            ResultLabel.Text = "Password does not confront password policy!";
        }
    }
}
