﻿
using System.Web.UI.WebControls;
using System.Web.UI;
using System;
using System.Reflection;
using System.ComponentModel;
using System.Drawing;
using System.Globalization;

public class CustomValidationSummary : WebControl
{
    // Fields
    private const string breakTag = "b";
    private bool renderUplevel;
    private bool wasForeColorSet;

    // Methods
    public CustomValidationSummary()
        : base(HtmlTextWriterTag.Div)
    {
        this.renderUplevel = false;
    }

    protected override void AddAttributesToRender(HtmlTextWriter writer)
    {
        if (this.renderUplevel)
        {
            base.EnsureID();
            string clientID = this.ClientID;
            HtmlTextWriter writer2 = true ? writer : null;
            if (this.HeaderText.Length > 0)
            {
                AddExpandoAttribute(this, writer2, clientID, "headertext", this.HeaderText, true);
            }
            if (this.ShowMessageBox)
            {
                AddExpandoAttribute(this, writer2, clientID, "showmessagebox", "True", false);
            }
            if (!this.ShowSummary)
            {
                AddExpandoAttribute(this, writer2, clientID, "showsummary", "False", false);
            }
            if (this.DisplayMode != ValidationSummaryDisplayMode.BulletList)
            {
                AddExpandoAttribute(this, writer2, clientID, "displaymode", PropertyConverter.EnumToString(typeof(ValidationSummaryDisplayMode), this.DisplayMode), false);
            }
            if (this.ValidationGroup.Length > 0)
            {
                AddExpandoAttribute(this, writer2, clientID, "validationGroup", this.ValidationGroup, true);
            }
        }
        base.AddAttributesToRender(writer);
    }

    internal string[] GetErrorMessages(out bool inError)
    {
        string[] strArray = null;
        inError = false;
        int num = 0;
        ValidatorCollection validators
            = this.ValidationGroupMode == ValidationGroupMode.AllValidationGroups ? this.Page.Validators : this.Page.GetValidators(this.ValidationGroup);
        for (int i = 0; i < validators.Count; i++)
        {
            IValidator validator = validators[i];
            if (!validator.IsValid)
            {
                inError = true;
                if (validator.ErrorMessage.Length != 0)
                {
                    num++;
                }
            }
        }
        if (num != 0)
        {
            strArray = new string[num];
            int index = 0;
            for (int j = 0; j < validators.Count; j++)
            {
                IValidator validator2 = validators[j];
                if ((!validator2.IsValid && (validator2.ErrorMessage != null)) && (validator2.ErrorMessage.Length != 0))
                {
                    strArray[index] = string.Copy(validator2.ErrorMessage);
                    index++;
                }
            }
        }
        return strArray;
    }

    protected override void OnInit(EventArgs e)
    {
        base.OnInit(e);
        if (!this.wasForeColorSet)
        {
            this.ForeColor = Color.Red;
        }
    }

    internal static bool IsPartialRenderingSupported(Control webControl)
    {
        bool result = true;

        Type scriptManagerType = webControl.Page.ClientScript.GetType();
        if (scriptManagerType != null)
        {
            object obj2 = webControl.Page.Items[scriptManagerType];
            if (obj2 != null)
            {
                PropertyInfo property = scriptManagerType.GetProperty("SupportsPartialRendering");
                if (property != null)
                {
                    object obj3 = property.GetValue(obj2, null);
                    result = (bool)obj3;
                }
            }
        }
        return result;
    }

    protected override void OnPreRender(EventArgs e)
    {
        base.OnPreRender(e);
        if (this.Enabled)
        {
            Page page = this.Page;
            if ((page != null) && (page.Request != null))
            {
                this.renderUplevel = (this.EnableClientScript && (page.Request.Browser.W3CDomVersion.Major >= 1)) && (page.Request.Browser.EcmaScriptVersion.CompareTo(new Version(1, 2)) >= 0);
            }
            if (this.renderUplevel)
            {
                string arrayValue = "document.getElementById(\"" + this.ClientID + "\")";
                if (!IsPartialRenderingSupported(this))
                {
                    this.Page.ClientScript.RegisterArrayDeclaration("Page_ValidationSummaries", arrayValue);
                }
                else
                {
                    this.Page.ClientScript.RegisterArrayDeclaration("Page_ValidationSummaries", arrayValue);

                    this.Page.ClientScript.RegisterStartupScript(typeof(ValidationSummary), this.ClientID + "_DisposeScript", string.Format(CultureInfo.InvariantCulture, "\r\ndocument.getElementById('{0}').dispose = function() {{\r\n    Array.remove({1}, document.getElementById('{0}'));\r\n}}\r\n", new object[] { this.ClientID, "Page_ValidationSummaries" }), true);

                }
            }
        }
    }

    protected override void Render(HtmlTextWriter writer)
    {
        string[] errorMessages;
        bool flag;
        if (base.DesignMode)
        {
            errorMessages = new string[] { "ValSummary_error_message_1" };
            flag = true;
            this.renderUplevel = false;
        }
        else
        {
            bool flag2;
            if (!this.Enabled)
            {
                return;
            }
            errorMessages = this.GetErrorMessages(out flag2);
            flag = this.ShowSummary && flag2;
            if (!flag && this.renderUplevel)
            {
                base.Style["display"] = "none";
            }
        }
        if (this.Page != null)
        {
            this.Page.VerifyRenderingInServerForm(this);
        }
        bool flag3 = this.renderUplevel || flag;
        if (flag3)
        {
            this.RenderBeginTag(writer);
        }
        if (flag)
        {
            string str;
            string str2;
            string str3;
            string str4;
            string str5;
            switch (this.DisplayMode)
            {
                case ValidationSummaryDisplayMode.List:
                    str = "b";
                    str2 = string.Empty;
                    str3 = string.Empty;
                    str4 = "b";
                    str5 = string.Empty;
                    break;

                case ValidationSummaryDisplayMode.SingleParagraph:
                    str = " ";
                    str2 = string.Empty;
                    str3 = string.Empty;
                    str4 = " ";
                    str5 = "b";
                    break;

                default:
                    str = string.Empty;
                    str2 = "<ul>";
                    str3 = "<li>";
                    str4 = "</li>";
                    str5 = "</ul>";
                    break;
            }
            if (this.HeaderText.Length > 0)
            {
                writer.Write(this.HeaderText);
                this.WriteBreakIfPresent(writer, str);
            }
            if (errorMessages != null)
            {
                writer.Write(str2);
                for (int i = 0; i < errorMessages.Length; i++)
                {
                    writer.Write(str3);
                    writer.Write(errorMessages[i]);
                    this.WriteBreakIfPresent(writer, str4);
                }
                this.WriteBreakIfPresent(writer, str5);
            }
        }
        if (flag3)
        {
            this.RenderEndTag(writer);
        }
    }

    internal bool ShouldSerializeForeColor()
    {
        Color color = Color.Red;
        return (color != this.ForeColor);
    }

    private void WriteBreakIfPresent(HtmlTextWriter writer, string text)
    {
        if (text == "b")
        {
            writer.Write("<br>");
            //if (base.EnableLegacyRendering)
            //{
            //    writer.Write("<br>");
            //}
            //else
            //{
            //    writer.WriteBreak();
            //}
        }
        else
        {
            writer.Write(text);
        }
    }

    // Properties
    [DefaultValue(1), Description("ValidationSummary_DisplayMode"), Category("Appearance")]
    public ValidationSummaryDisplayMode DisplayMode
    {
        get
        {
            object obj2 = this.ViewState["DisplayMode"];
            if (obj2 != null)
            {
                return (ValidationSummaryDisplayMode)obj2;
            }
            return ValidationSummaryDisplayMode.BulletList;
        }
        set
        {
            if ((value < ValidationSummaryDisplayMode.List) || (value > ValidationSummaryDisplayMode.SingleParagraph))
            {
                throw new ArgumentOutOfRangeException("value");
            }
            this.ViewState["DisplayMode"] = value;
        }
    }

    [DefaultValue(1), Description("ValidationSummary_ValidationGroupMode"), Category("Appearance")]
    public ValidationGroupMode ValidationGroupMode
    {
        get
        {
            object obj2 = this.ViewState["ValidationGroupMode"];
            if (obj2 != null)
            {
                return (ValidationGroupMode)obj2;
            }
            return ValidationGroupMode.AllValidationGroups;
        }
        set
        {
            this.ViewState["ValidationGroupMode"] = value;
        }
    }

    [Description("ValidationSummary_EnableClientScript"), Themeable(false), DefaultValue(true), Category("Behavior")]
    public bool EnableClientScript
    {
        get
        {
            object obj2 = this.ViewState["EnableClientScript"];
            if (obj2 != null)
            {
                return (bool)obj2;
            }
            return true;
        }
        set
        {
            this.ViewState["EnableClientScript"] = value;
        }
    }

    [DefaultValue(typeof(Color), "Red")]
    public override Color ForeColor
    {
        get
        {
            return base.ForeColor;
        }
        set
        {
            this.wasForeColorSet = true;
            base.ForeColor = value;
        }
    }

    [Localizable(true), DefaultValue(""), Description("ValidationSummary_HeaderText"), Category("Appearance")]
    public string HeaderText
    {
        get
        {
            object obj2 = this.ViewState["HeaderText"];
            if (obj2 != null)
            {
                return (string)obj2;
            }
            return string.Empty;
        }
        set
        {
            this.ViewState["HeaderText"] = value;
        }
    }

    [DefaultValue(false), Category("Behavior"), Description("ValidationSummary_ShowMessageBox")]
    public bool ShowMessageBox
    {
        get
        {
            object obj2 = this.ViewState["ShowMessageBox"];
            return ((obj2 != null) && ((bool)obj2));
        }
        set
        {
            this.ViewState["ShowMessageBox"] = value;
        }
    }

    [DefaultValue(true), Description("ValidationSummary_ShowSummary"), Category("Behavior")]
    public bool ShowSummary
    {
        get
        {
            object obj2 = this.ViewState["ShowSummary"];
            if (obj2 != null)
            {
                return (bool)obj2;
            }
            return true;
        }
        set
        {
            this.ViewState["ShowSummary"] = value;
        }
    }

    //public override bool SupportsDisabledAttribute
    //{
    //    get
    //    {
    //        return (this.RenderingCompatibility < new Version(4, 0));
    //    }
    //}

    [Themeable(false), Category("Behavior"), Description("ValidationSummary_ValidationGroup"), DefaultValue("")]
    public virtual string ValidationGroup
    {
        get
        {
            string str = (string)this.ViewState["ValidationGroup"];
            if (str != null)
            {
                return str;
            }
            return string.Empty;
        }
        set
        {
            this.ViewState["ValidationGroup"] = value;
        }
    }

    internal void AddExpandoAttribute(HtmlTextWriter writer, string controlId, string attributeName, string attributeValue)
    {
        AddExpandoAttribute(writer, controlId, attributeName, attributeValue, true);
    }

    internal void AddExpandoAttribute(Control control, HtmlTextWriter writer, string controlId, string attributeName, string attributeValue, bool encode)
    {
        if (writer != null)
        {
            writer.AddAttribute(attributeName, attributeValue, encode);
        }
        else
        {
            Page page = control.Page;
            if (!IsPartialRenderingSupported(control))
            {
                page.ClientScript.RegisterExpandoAttribute(controlId, attributeName, attributeValue, encode);
            }
            else
            {
                page.ClientScript.RegisterExpandoAttribute(controlId, attributeName, attributeValue, encode);
            }
        }
    }

    internal void AddExpandoAttribute(HtmlTextWriter writer, string controlId, string attributeName, string attributeValue, bool encode)
    {
        AddExpandoAttribute(this, writer, controlId, attributeName, attributeValue, encode);
    }

}

/// <summary>
/// The way the validation summary shall behave toward validation groups.
/// </summary>
public enum ValidationGroupMode
{
    /// <summary>
    /// Only one validation group will be registered to the validation summary.(This will make this validation summary act just like the asp.net validation summary.)
    /// </summary>
    SingleValidationGroup = 0,
    /// <summary>
    /// All validation groups will be registered in the validation summary.
    /// </summary>
    AllValidationGroups = 1
}