using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

// Created by Sina Falahati on 29.10.2006 07:39
// With thanks to:
// Abaif for his JSHelper CheckTextAreaMaxLength sample
// A. Kluge for his Textarea-Counter

/// <summary>
/// Description:
/// If you specify TextMode="SingleLine" on a TextBox, it generates an html <input> box with a 
/// MaxLength attribute.  If you specify TextMode="MultiLine", it generates an html <textarea> 
/// box ... and doesn't set the MaxLength attribute, since it's undefined for <textarea> elements. 
/// This will add a check onKeyUp for the textarea that will prevent too many
/// characters from being entered. Set the MaxLength as normal as a property of the TextBox and then call
/// this method to generate JavaScript to do the client-side checks.
/// 
/// How to use: 
/// For performing length validation on all multiline Text-Boxes on a page: Put "CheckAllMaxLengthsWithinParentControl(this);" inside the page's Page_Load function
/// For performing length validation on a specific Text-Box: Put "CheckMaxLength(theTextBox);" inside the page's Page_Load function
/// For FormViews inside ATLAS Update-Panels use FormView's OnItemCreated event with CheckAllMaxLengthsWithinParentControl((FormView)sender);
/// </summary>
public static class TextAreaValidator
{
    public static void CheckAllMaxLengthsWithinParentControl(Control oParent)
    {
        Control oChild = null;
        TextBox oChildTextBox = null;

        if ((oParent == null) || (!oParent.HasControls()))
        {
            return;
        }

        for (int iItem = 0; iItem < oParent.Controls.Count; iItem++)
        {
            oChild = oParent.Controls[iItem];
            if (!oChild.Visible)
            {
                continue;
            }

            if (oChild.Controls.Count > 0)
                CheckAllMaxLengthsWithinParentControl(oChild); // iterate through child-controls

            if (oChild is TextBox)
            {
                oChildTextBox = (TextBox)oChild;
                // Change TextBox Properties Here
                if (oChildTextBox.TextMode == TextBoxMode.MultiLine && // only Multiline Text-Boxes need this
                    oChildTextBox.MaxLength != 0) // 0 == no limit
                    CheckMaxLength(oChildTextBox);
            }
        }
    }

    public static void CheckMaxLength(TextBox textArea)
    {
        textArea.Attributes.Add("onKeyUp",
            "CheckMaxLength(event," +
            "'" + textArea.ClientID + "'," +
            textArea.MaxLength + ");");

        textArea.Attributes.Add("onChange",
            "CheckMaxLength(event," +
            "'" + textArea.ClientID + "'," +
            textArea.MaxLength + ");");

        RegisterCheckMaxLength(textArea.Page);
    }

    private static void RegisterCheckMaxLength(Page page)
    {
        string script = string.Empty;

        //Build the function block
        script = @"
        function CheckMaxLength(e, textarea_id, max) {
                        var theTextArea = document.getElementById(textarea_id);
		                if (!e.which) keyCode = event.keyCode; // ie5+ op5+
		                else keyCode = e.which; // nn6+

		                if (theTextArea.value.length>max)
		                {
			                theTextArea.value = theTextArea.value.substring(0,max);
		                }
	                }";

        //Enclose function <script> tags and register at top of page
        page.RegisterClientScriptBlock("CheckMaxLength", EncloseScriptBlock(script));
    }

    private static string EncloseScriptBlock(string script)
    {
        script = "<script type='text/javascript'>\r\n" +
            "<!--\r\n" +
            script + "\r\n" +
            "// -->\r\n" +
            "</script>";

        return script;
    }
}
