﻿<%@ WebHandler Language="C#" Class="repeater_person" %>

using System;
using System.Data;
using System.Web;
using System.Web.Script.Serialization;
using System.Collections.Generic;

public class repeater_person : IHttpHandler
{

	public void ProcessRequest ( HttpContext context )
	{
		context.Response.ContentType = "text/javascript";
		context.Response.Cache.SetNoStore ( );

		int pageindex = 1;
		int pagesize = 3;

		if ( null != context.Request["pageindex"] )
			int.TryParse ( context.Request["pageindex"], out pageindex );

		if ( null != context.Request["pagesize"] )
			int.TryParse ( context.Request["pagesize"], out pagesize );

		int beginIndex = pagesize * ( pageindex - 1 ) + 1;
		int endIndex = pagesize * pageindex;

		string order = context.Request["__order"];

		int itemcount = SampleHelper.QueryValue ( "select count(*) from person" );
		DataTable personTable = SampleHelper.Filter ( null, order, beginIndex, endIndex, null, "Person", out itemcount );

		List<object> tableJSON = SampleHelper.CreateJSONArray ( personTable );

		context.Response.Write ( new JavaScriptSerializer ( ).Serialize (
			SampleHelper.CreateJSONObject ( new KeyValuePair<string, object>[]
			{
			new KeyValuePair<string, object> ( "__success", true ),
			new KeyValuePair<string, object> ( "rows", tableJSON ),
			new KeyValuePair<string, object> ( "itemcount", itemcount )
			} ) )
			);

	}

	public bool IsReusable
	{
		get { return false; }
	}

}