﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ProductList1.aspx.cs" Inherits="repeater_ProductList1" EnableSessionState="False" %>

<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.ui.jqueryui"
	TagPrefix="je" %>
<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.ui.jqueryui.plusin"
	TagPrefix="je" %>
<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.web.jqueryui"
	TagPrefix="je" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title>Product View</title>
	<link rel="stylesheet" type="text/css" href="../css/smoothness/jquery-ui-1.8.15.custom.css" />
	<script type="text/javascript" src="../js/jquery-1.6.2.min.js"></script>
	<script type="text/javascript" src="../js/jquery-ui-1.8.15.custom.min.js"></script>
	<link rel="stylesheet" type="text/css" href="../css/main.css" />
	<style type="text/css">
		#pageindex
		{
			color: #009900;
			width: 20px;
		}
	</style>
	<script type="text/javascript">
		function clearCondition() {
			$('#productname_filter').val('');
			$('#model_filter').val('');
			$('#price1_filter').val('');
			$('#price2_filter').val('');
			$('#amount_filter').val('');
			$('#manufactureDate1_filter').val('');
			$('#manufactureDate2_filter').val('');
		}
	</script>
</head>
<body>
	<form id="formProductList1" runat="server">
	<div class="title purple-title">
		Product View
		<iframe src="../about.htm" frameborder="0" height="195" width="100%" allowtransparency="true" scrolling="no"></iframe>
	</div>
	<div class="content">
		<h2>
			Explanation
		</h2>
		<blockquote>
			This example uses the Access database, if you want to use .NET 4.0, remove the comment of #define V4 in the file App_Code/repeater_product.cs.
		</blockquote>
		<h2>
			Example
		</h2>
		<blockquote>
			<table id="list" cellpadding="7" cellspacing="0" class="ui-widget ui-corner-all ui-widget-content">
				<je:Repeater ID="productList" runat="server" Selector="#list" IsVariable="true"
					PageSize="3" FilterField="['productname','model','price1','price2','amount','manufactureDate1','manufactureDate2']"
					FilterFieldDefault="['','',-1,-1,-1,'1970-1-1','1970-1-1']" FillAsync-Url="product.asmx"
					FillAsync-MethodName="GetProductList">
					<HeaderTemplate>
						<thead je-class="{header}">
							<tr>
								<td>
									Product
								</td>
								<td>
									Model
								</td>
								<td>
									Price
								</td>
								<td>
									Amount
								</td>
								<td>
									Manufacture Date
								</td>
							</tr>
						</thead>
					</HeaderTemplate>
					<FilterTemplate>
						<tr je-class="{highlight}">
							<td>
								<input type="text" size="10" je-id="productname" je-value="productname" />
							</td>
							<td>
								<input type="text" size="5" je-id="model" je-value="model" />
							</td>
							<td>
								<input type="text" size="4" je-id="price1" je-value="price1" />-<input type="text" size="4" je-id="price2" je-value="price2" />
							</td>
							<td>
								<input type="text" size="3" je-id="amount" je-value="amount" />
							</td>
							<td>
								<input type="text" size="10" je-datepicker="dateFormat='yy-mm-dd';changeMonth=true;changeYear=true" je-id="manufactureDate1" je-value="manufactureDate1" />-<input je-datepicker="dateFormat='yy-mm-dd';changeMonth=true;changeYear=true" type="text" size="10" je-id="manufactureDate2" je-value="manufactureDate2" />
							</td>
						</tr>
						<tr je-class="{highlight}">
							<td colspan="5" align="right">
								<span je-button=";" onclick="javascript:clearCondition();">Reset</span><span je-button=";" je-onclick="filter">Search</span>
							</td>
						</tr>
					</FilterTemplate>
					<ItemTemplate>
						<tr>
							<td>
								<strong>#{productname}</strong>
							</td>
							<td>
								#{model}
							</td>
							<td>
								#{price}
							</td>
							<td>
								#{amount,# <= 10 ? (# + ' <font color="red">Less than 11!</font>') : #}
							</td>
							<td>
								#{manufacturedate,jQuery.panzer.formatDate(#,'yyyy-M-d')}
							</td>
						</tr>
					</ItemTemplate>
					<FooterTemplate>
						<tfoot>
							<tr>
								<td colspan="5">
									<a href="#" je-onclick="prev" style="color: Blue">Prev</a>&nbsp;&nbsp;<a href="#"
										je-onclick="next" style="color: Blue">Next</a>,&nbsp; @{pageindex}/@{pagecount}
									pages, @{itemcount} total, <a href="#" je-onclick="goto,new Number(jQuery('#pageindex').val())"
										style="color: Blue">Jump</a> to
									<input type="text" id="pageindex" value="@{pageindex}" />
								</td>
							</tr>
						</tfoot>
					</FooterTemplate>
				</je:Repeater>
			</table>
			<hr />
			Product: <input id="myproductname" type="text" size="10" /><je:Button ID="cmdSearch" runat="server" Label="Search 2" Click="
			function(){
				productList.__repeater('setfilter', 'productname', $('#myproductname').val());
				productList.__repeater('filter');
			}
			"></je:Button>
		</blockquote>
	</div>
	</form>
</body>
</html>
<script type="text/javascript">
	$(function () {
		productList.__repeater('fill');
	});
</script>
