﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ManageStudent1.aspx.cs" Inherits="repeater_ManageStudent1" EnableSessionState="False" %>

<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.ui.jqueryui.plusin"
	TagPrefix="je" %>
<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.web.jqueryui"
	TagPrefix="je" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title>Student Information Management</title>
	<link rel="stylesheet" type="text/css" href="../css/smoothness/jquery-ui-1.8.15.custom.css" />
	<script type="text/javascript" src="../js/jquery-1.6.2.min.js"></script>
	<script type="text/javascript" src="../js/jquery-ui-1.8.15.custom.min.js"></script>
	<link rel="stylesheet" type="text/css" href="../css/main.css" />
	<style type="text/css">
		.grade-no
		{
			font-size: larger;
			color: Red;
			font-weight: bold;
		}
		.grade-yes
		{
			font-size: larger;
			color: Green;
			font-weight: bold;
		}
		#pageindex
		{
			color: #009900;
			width: 20px;
		}
	</style>
	<script type="text/javascript">
		function convertYYYYMMDDToDate(value) {
			// 2000-1-1
			var parts = value.split('-');
			return new Date(new Number(parts[0]), new Number(parts[1]) - 1, new Number(parts[2]));
		}
		function birthdayToAge(birthday) {
			return new Date().getFullYear() - $.panzer.convertToDate(birthday).getFullYear();
		}
		function displaySex(sex) {
			return sex ? '<span style="color: blue;">Male</span>' : '<span style="color: red;">Female</span>';
		}
		function displayMajor(major) {
			switch (major) {
				case 'jsj':
					return 'Computer';

				case 'gsgl':
					return 'Business';

				case 'hy':
					return 'Chinese';

				default:
					return 'Other';
			}
		}
		function gradeToCSS(grade) {
			if (grade < 60)
				return 'no';
			else if (grade > 90)
				return 'yes';
			else
				return 'common';
		}
	</script>
</head>
<body>
	<form id="formManageStudent1" runat="server">
	<div class="title purple-title">
		Student Information Management
		<iframe src="../about.htm" frameborder="0" height="195" width="100%" allowtransparency="true" scrolling="no"></iframe>
	</div>
	<div class="content">
		<h2>
			Explanation
		</h2>
		<blockquote>
			If you need to use Access, comment the #define XML in the repeater_webservice.cs
			file.
		</blockquote>
		<h2>
			Example
		</h2>
		<blockquote>
			<table id="list" cellpadding="7" cellspacing="0" class="ui-widget ui-corner-all ui-widget-content">
				<je:Repeater ID="studentRepeater" runat="server" Selector="#list" PageSize="4"
					IsVariable="true" FieldMask="{ sex: { type: 'boolean' }, birthday: { type: 'date', provider: convertYYYYMMDDToDate } }"
					FillAsync-Url="webservice.asmx" FillAsync-MethodName="FillStudentList" Updated="
				function(pe, e){
					pe.jquery.__repeater('showtip', 'Only modified ' + e.row.realname + '\'s information at local, does not change the server\'s data.');
				}
				">
					<HeaderTemplate>
						<thead je-class="{header}">
							<tr>
								<td>
									ID
								</td>
								<td>
									Name
								</td>
								<td>
									Age
								</td>
								<td>
									Sex
								</td>
								<td>
									Subject
								</td>
								<td>
									Score
								</td>
								<td>
									Operation
								</td>
							</tr>
						</thead>
					</HeaderTemplate>
					<TipTemplate>
						<tr>
							<td colspan="7">
								@{tip}
							</td>
						</tr>
					</TipTemplate>
					<ItemTemplate>
						<tr>
							<td>
								#{id}
							</td>
							<td>
								#{realname}
							</td>
							<td>
								#{birthday,birthdayToAge(#)}
							</td>
							<td>
								#{sex,displaySex(#)}
							</td>
							<td>
								#{major,displayMajor(#)}
							</td>
							<td class="grade-#{grade,gradeToCSS(#)}">
								#{grade}
							</td>
							<td>
								<span je-button="label='Edit';" je-onclick="beginedit"></span>
							</td>
						</tr>
					</ItemTemplate>
					<EditItemTemplate>
						<tr>
							<td>
								#{id}
							</td>
							<td>
								<input je-id="realname" type="text" value="#{realname}" />
							</td>
							<td>
								<input je-id="birthday" je-datepicker="dateFormat='yy-mm-dd'" type="text" value="#{birthday,jQuery.panzer.formatDate(#,'yyyy-MM-dd')}" />
							</td>
							<td>
								<%--
							<select je-id="sex">
								<option value="true" je-selected="#{sex}">Male</option>
								<option value="false" je-selected="#{sex,!#}">Female</option>
							</select>
								--%>
								<input je-id="sex" type="checkbox" je-checked="#{sex}" />
							</td>
							<td>
								<%--
							<select je-id="major">
								<option value="jsj" je-selected="'#{major}' == 'jsj'">Computer</option>
								<option value="gsgl" je-selected="'#{major}' == 'gsgl'">Business</option>
								<option value="hy" je-selected="'#{major}' == 'hy'">Chinese</option>
							</select>
								--%>
								<input je-id="major" je-autocomplete="source=['jsj','gsgl','hy']" value="#{major}" />
							</td>
							<td>
								<input je-id="grade" type="text" value="#{grade}" />
							</td>
							<td>
								<span je-button="label='Cancel';" je-onclick="endedit"></span><span je-button="label='Save';"
									je-onclick="update"></span>
							</td>
						</tr>
					</EditItemTemplate>
					<FooterTemplate>
						<tfoot>
							<tr>
								<td colspan="7">
									<span je-button="label='Prev'" je-onclick="prev"></span>&nbsp;&nbsp;<span je-button="label='Next'"
										je-onclick="next"></span>,&nbsp; @{pageindex}/@{pagecount} pages, @{itemcount}
									total, <span je-button="label='Jump'" je-onclick="goto,new Number(jQuery('#pageindex').val())">
									</span>&nbsp;to
									<input type="text" id="pageindex" value="@{pageindex}" />
								</td>
							</tr>
						</tfoot>
					</FooterTemplate>
				</je:Repeater>
			</table>
		</blockquote>
	</div>
	</form>
</body>
</html>
<script type="text/javascript">
	$(function () {
		studentRepeater.__repeater('fill');
	});
</script>
