﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ManageOrder1.aspx.cs" Inherits="repeater_ManageOrder1" EnableSessionState="False" %>

<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.ui.jqueryui.plusin"
	TagPrefix="je" %>
<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.web.jqueryui"
	TagPrefix="je" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title>Order Management</title>
	<link rel="stylesheet" type="text/css" href="../css/smoothness/jquery-ui-1.8.15.custom.css" />
	<script type="text/javascript" src="../js/jquery-1.6.2.min.js"></script>
	<script type="text/javascript" src="../js/jquery-ui-1.8.15.custom.min.js"></script>
	<link rel="stylesheet" type="text/css" href="../css/main.css" />
	<style type="text/css">
		#list
		{
			width: 80%;
		}
		#pageindex
		{
			color: #009900;
			width: 20px;
		}
		.tip
		{
			text-align: center;
			color: Red;
		}
		.id
		{
			color: Green;
		}
		.address
		{
			color: Blue;
		}
		.buyer
		{
			cursor: pointer;
		}
		.detail
		{
			display: none;
		}
		.edit-item
		{
			background-color: Green;
		}
		.inserted-item
		{
			background-color: #cccccc;
		}
	</style>
	<script type="text/javascript">
		function displayAddress(address) {

			if (address.length > 10)
				return '<span title="' + address + '">' + address.substring(0, 7) + '...</span>';
			else
				return address;

		}

		var tipCount = 0;

		var mask = {
			amount: {
				type: 'number',
				need: true,
				max: 10,
				min: 1,
				tip: 'Amount required between 1-10'
			},
			price: {
				type: 'number',
				need: true,
				max: 10000,
				min: 1000,
				tip: { type: 'Please input a number for price', need: 'Please input price', max: 'Price cannot exceed 10,000', min: 'Price cannot be less than 1000' }
			},
			buyer: {
				type: 'string',
				need: true,
				max: 10,
				min: 3,
				tip: 'Length of buyer required between 3-10'
			},
			address: {
				type: 'string',
				min: 1,
				max: 100,
				tip: 'Length of buyer required between 1-100'
			},
			orderdate: {
				type: 'date',
				tip: 'Need a valid date'
			},
			iscompleted: {
				type: 'boolean',
				defaultvalue: false
			}
		};
	</script>
</head>
<body>
	<form id="formManageOrder1" runat="server">
	<div class="title purple-title">
		Order Management
		<iframe src="../about.htm" frameborder="0" height="195" width="100%" allowtransparency="true" scrolling="no"></iframe>
	</div>
	<div class="content">
		<h2>
			Explanation
		</h2>
		<blockquote>
			This example uses the Access database.
		</blockquote>
		<h2>
			Example
		</h2>
		<blockquote>
			<table id="list" cellpadding="7" cellspacing="0" class="ui-widget ui-corner-all ui-widget-content">
				<je:Repeater ID="orderList" runat="server" Selector="#list" IsVariable="true" PageSize="2" FieldMask="mask"
					FillAsync-Url="webservice.asmx" FillAsync-MethodName="GetOrders" UpdateAsync-Url="webservice.asmx"
					UpdateAsync-MethodName="ModifyOrder" InsertAsync-Url="webservice.asmx" InsertAsync-MethodName="CreateOrder"
					Filled="
					function(pe, e){
						orderList.__repeater('showtip', e.custom.message);
					}
					" PreUpdate="
					function(pe, e){
						e.row.sum = e.row.price * e.row.amount;
						orderList.__repeater('showtip', 'Submit data...');
					}
					" Updated="
					function(pe, e){

						if(e.issuccess)
							orderList.__repeater('showtip', 'Has saved order whick id is  ' + e.row.id.toString() + ' and sum is ' + e.row.sum.toString());
						else
							orderList.__repeater('showtip', 'Fail to save order which id is ' + e.row.id.toString());

					}
					" PreInsert="
					function(pe, e){
						e.row.sum = e.row.price * e.row.amount;
						orderList.__repeater('showtip', 'Submit data...');
					}
					" Inserted="
					function(pe, e){

						if(e.issuccess)
							orderList.__repeater('showtip', 'Has created order whick id is ' + e.row.id.toString() + ' and sum is ' + e.row.sum.toString());
						else
							orderList.__repeater('showtip', 'Fail to create order which id is ' + e.row.id.toString());

					}
					">
					<HeaderTemplate>
						<thead je-class="{header}">
							<tr>
								<td>
									ID
								</td>
								<td>
									Buyer
								</td>
								<td>
									Address
								</td>
								<td>
									Product
								</td>
								<td>
									Order Date
								</td>
								<td>
									Operation
								</td>
							</tr>
							<tr>
								<td>
									Amount
								</td>
								<td>
									Price
								</td>
								<td>
									Sum
								</td>
								<td colspan="3">
									Completed?
								</td>
							</tr>
						</thead>
					</HeaderTemplate>
					<TipTemplate>
						<tr>
							<td colspan="6" class="tip">
								@{tip,(++tipCount).toString() + ' :' + @}
							</td>
						</tr>
					</TipTemplate>
					<ItemTemplate>
						<tr je-class="{state}-item">
							<td class="id">
								#{id}
							</td>
							<td class="buyer" onclick="javascript:$('##{id}_detail').toggleClass('detail');">
								<strong>#{buyer}</strong>
							</td>
							<td class="address">
								#{address,displayAddress(#)}
							</td>
							<td>
								#{product}
							</td>
							<td>
								#{orderdate,jQuery.panzer.formatDate(#,'yyyy-MM-dd')}
							</td>
							<td>
								<span je-button="label='Edit'" je-onclick="beginedit"></span>
							</td>
						</tr>
						<tr id="#{id}_detail" je-class="{state}-item detail">
							<td>
								#{amount}
							</td>
							<td>
								#{price}
							</td>
							<td>
								#{sum}
							</td>
							<td colspan="3">
								#{iscompleted,# ? '<strong>Completed</strong>' : 'Uncompleted'}
							</td>
						</tr>
					</ItemTemplate>
					<EditItemTemplate>
						<tr class="edit-item">
							<td class="id">
								#{id}
							</td>
							<td>
								<input type="text" je-id="buyer" value="#{buyer}" size="5" />
							</td>
							<td>
								<input type="text" je-id="address" value="#{address}" size="15" />
							</td>
							<td>
								<input type="text" je-id="product" value="#{product}" size="9" />
							</td>
							<td>
								<input type="text" je-id="orderdate" je-datepicker="dateFormat='yy-mm-dd'" value="#{orderdate,jQuery.panzer.formatDate(#,'yyyy-MM-dd')}"
									size="10" />
							</td>
							<td>
								<span je-button="label='Cancel'" je-onclick="endedit"></span><span je-button="label='Save'"
									je-onclick="update"></span>
							</td>
						</tr>
						<tr class="edit-item">
							<td>
								<input type="text" je-id="amount" value="#{amount}" size="2" />
							</td>
							<td>
								<input type="text" je-id="price" value="#{price}" size="4" />
							</td>
							<td>
								?
							</td>
							<td colspan="3">
								<input type="checkbox" je-id="iscompleted" je-checked="#{iscompleted}" />
							</td>
						</tr>
					</EditItemTemplate>
					<NewItemTemplate>
						<tr je-class="{highlight}">
							<td class="id">
								?
							</td>
							<td>
								<input type="text" je-id="buyer" size="5" />
							</td>
							<td>
								<input type="text" je-id="address" size="15" />
							</td>
							<td>
								<input type="text" je-id="product" size="9" />
							</td>
							<td>
								<input type="text" je-id="orderdate" je-datepicker="dateFormat='yy-mm-dd'" size="10" />
							</td>
							<td>
								<span je-button="label='Create'" je-onclick="insert"></span>
							</td>
						</tr>
						<tr je-class="{highlight}">
							<td>
								<input type="text" je-id="amount" size="2" />
							</td>
							<td>
								<input type="text" je-id="price" size="5" />
							</td>
							<td>
								?
							</td>
							<td colspan="3">
								<input type="checkbox" je-id="iscompleted" />
							</td>
						</tr>
					</NewItemTemplate>
					<FooterTemplate>
						<tfoot je-class="{default}">
							<tr>
								<td colspan="6">
									<span je-button="label='Prev'" je-onclick="prev"></span>&nbsp;&nbsp;<span je-button="label='Next'"
										je-onclick="next"></span>,&nbsp; @{pageindex}/@{pagecount} pages, @{itemcount}
									total, <span je-button="label='Jump'" je-onclick="goto,new Number(jQuery('#pageindex').val())">
									</span>&nbsp;to
									<input type="text" id="pageindex" value="@{pageindex}" />
								</td>
							</tr>
						</tfoot>
					</FooterTemplate>
				</je:Repeater>
			</table>
		</blockquote>
	</div>
	</form>
</body>
</html>
<script type="text/javascript">
	$(function () {
		orderList.__repeater('fill');
	});
</script>
