﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="BookList1.aspx.cs" Inherits="repeater_BookList1" EnableSessionState="False" %>

<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.ui.jqueryui.plusin"
	TagPrefix="je" %>
<%@ Register Assembly="zoyobar.shared.panzer.JQueryElement" Namespace="zoyobar.shared.panzer.web.jqueryui"
	TagPrefix="je" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title>Book List</title>
	<link rel="stylesheet" type="text/css" href="../css/smoothness/jquery-ui-1.8.15.custom.css" />
	<script type="text/javascript" src="../js/jquery-1.6.2.min.js"></script>
	<script type="text/javascript" src="../js/jquery-ui-1.8.15.custom.min.js"></script>
	<link rel="stylesheet" type="text/css" href="../css/main.css" />
	<style type="text/css">
		#list
		{
			background-color: #ffffff;
			width: 100%;
		}
		.cover
		{
			height: 100px;
			border: 1px solid #999999;
			color: #999999;
		}
		.bookname
		{
			font-size: large;
			font-weight: bold;
		}
		.price
		{
			color: #ff0000;
		}
		.author, .publisher
		{
			color: #0000cc;
		}
		.publishdate
		{
			color: #666666;
		}
		.rank
		{
			background-color: #cc0000;
			height: 15px;
			display: inline-block;
		}
		.rank1
		{
			width: 10px;
		}
		.rank2
		{
			width: 30px;
		}
		.rank3
		{
			width: 50px;
		}
		.rank4
		{
			width: 70px;
		}
		.rank5
		{
			width: 90px;
		}
		#pageindex
		{
			color: #009900;
			width: 20px;
		}
	</style>
	<script type="text/javascript">
		function convertDiscount(discount) {
			return discount < 0.7 ? '<strong>Clearance</strong>' : 'Sale';
		}
	</script>
</head>
<body>
	<form id="formBookList1" runat="server">
	<div class="title green-title">
		Book List
		<iframe src="../about.htm" frameborder="0" height="195" width="100%" allowtransparency="true" scrolling="no"></iframe>
	</div>
	<div class="content">
		<h2>
			Explanation
		</h2>
		<blockquote>
			If you need to use Access, comment the #define XML in the repeater_webservice.cs
			file.
		</blockquote>
		<h2>
			Example
		</h2>
		<blockquote>
			<table id="list" cellpadding="5" cellspacing="5">
				<je:Repeater ID="bookRepeater" runat="server" Selector="#list" PageSize="4" IsVariable="true"
					FillAsync-Url="webservice.asmx" FillAsync-MethodName="FillBookList">
					<ItemTemplate>
						<tbody>
							<tr>
								<td rowspan="4" class="cover">
									Photo #{id}
								</td>
								<td colspan="2" class="bookname">
									#{bookname}
								</td>
							</tr>
							<tr>
								<td>
									<strong>Author:</strong> <span class="author">#{author}</span>
								</td>
								<td>
									<strong>Publisher:</strong> <span class="publisher">#{publisher}</span>
								</td>
							</tr>
							<tr>
								<td>
									<strong>Price:</strong> <span class="price">#{price}</span>
								</td>
								<td>
									<strong>Discount:</strong> #{discount,Math.floor(# * 100) / 10} #{discount,convertDiscount(#)}
								</td>
							</tr>
							<tr>
								<td>
									<strong>Publication Date:</strong> <span class="publishdate">#{publishdate,jQuery.panzer.formatDate(#,'yyyy-MM-dd')}</span>
								</td>
								<td>
									<strong>Rank:</strong> #{rank} <span class="rank rank#{rank}"></span>
								</td>
							</tr>
						</tbody>
					</ItemTemplate>
					<FooterTemplate>
						<tfoot>
							<tr>
								<td colspan="2">
									<a href="#" je-onclick="prev">Prev</a>&nbsp;&nbsp;<a href="#" je-onclick="next">Next</a>,&nbsp;
									@{pageindex}/@{pagecount} pages, @{itemcount} total, <a href="#" je-onclick="goto,new Number(jQuery('#pageindex').val())">
										jump</a> to
									<input type="text" id="pageindex" value="@{pageindex}" />
								</td>
							</tr>
						</tfoot>
					</FooterTemplate>
				</je:Repeater>
			</table>
		</blockquote>
	</div>
	</form>
</body>
</html>
<script type="text/javascript">
	$(function () {
		bookRepeater.__repeater('fill');
	});
</script>
