<%@ Page Title="Products" Language="VB" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Web_Products.aspx.vb" Inherits="Northwind.Web_Products" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link rel="stylesheet" type="text/css" href="Styles/jquery.tooltip.css" />
    <script src="Scripts/gridview-readonly-script.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            InitializeToolTip();
        });
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server" />

    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
	        <asp:GridView ID="GridView1" runat="server" DataKeyNames="ProductID" DataSourceID="ObjectDataSource1" SkinID="GridViewProfessional">
		        <Columns>
			        <asp:BoundField DataField="ProductID" HeaderText="Product ID" ReadOnly="true" SortExpression="ProductID" />
			        <asp:BoundField DataField="ProductName" HeaderText="Product Name" ReadOnly="true" SortExpression="ProductName" />
                    <asp:TemplateField HeaderText="Supplier ID" SortExpression="SupplierID" HeaderStyle-Wrap="false">
                        <ItemStyle Width="30px" HorizontalAlign="Center" />
                        <ItemTemplate>
                            <div class="tag">
                                <a href="#" class="gridViewToolTip"><%# Eval("SupplierID")%></a>
                                <div id="tooltip" style="display: none;">
                                    <table>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Supplier ID:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.SupplierID")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Company Name:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.CompanyName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Contact Name:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.ContactName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Contact Title:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.ContactTitle")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Address:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.Address")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>City:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.City")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Region:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.Region")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Postal Code:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.PostalCode")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Country:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.Country")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Phone:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.Phone")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Fax:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.Fax")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Home Page:</b>&nbsp;</td>
                                            <td><%# Eval("Suppliers.Value.HomePage")%></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField> 
                    <asp:TemplateField HeaderText="Category ID" SortExpression="CategoryID" HeaderStyle-Wrap="false">
                        <ItemStyle Width="30px" HorizontalAlign="Center" />
                        <ItemTemplate>
                            <div class="tag">
                                <a href="#" class="gridViewToolTip"><%# Eval("CategoryID")%></a>
                                <div id="tooltip" style="display: none;">
                                    <table>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Category ID:</b>&nbsp;</td>
                                            <td><%# Eval("Categories.Value.CategoryID")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Category Name:</b>&nbsp;</td>
                                            <td><%# Eval("Categories.Value.CategoryName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="white-space: nowrap;"><b>Description:</b>&nbsp;</td>
                                            <td><%# Eval("Categories.Value.Description")%></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField> 
			        <asp:BoundField DataField="QuantityPerUnit" HeaderText="Quantity Per Unit" ReadOnly="true" SortExpression="QuantityPerUnit" />
			        <asp:BoundField DataField="UnitPrice" HeaderText="Unit Price" ReadOnly="true" SortExpression="UnitPrice" DataFormatString="{0:c}" HtmlEncode="false" ItemStyle-HorizontalAlign="Right" />
			        <asp:BoundField DataField="UnitsInStock" HeaderText="Units In Stock" ReadOnly="true" SortExpression="UnitsInStock" DataFormatString="{0:N0}" HtmlEncode="false" ItemStyle-HorizontalAlign="Right" />
			        <asp:BoundField DataField="UnitsOnOrder" HeaderText="Units On Order" ReadOnly="true" SortExpression="UnitsOnOrder" DataFormatString="{0:N0}" HtmlEncode="false" ItemStyle-HorizontalAlign="Right" />
			        <asp:BoundField DataField="ReorderLevel" HeaderText="Reorder Level" ReadOnly="true" SortExpression="ReorderLevel" DataFormatString="{0:N0}" HtmlEncode="false" ItemStyle-HorizontalAlign="Right" />
			        <asp:CheckBoxField DataField="Discontinued" HeaderText="Discontinued" ReadOnly="true" SortExpression="Discontinued" />
		        </Columns>
	        </asp:GridView>
        </ContentTemplate>
    </asp:UpdatePanel>

    <asp:UpdateProgress ID="UpdateProgress1" AssociatedUpdatePanelID="UpdatePanel1" runat="server" DisplayAfter="0">
        <ProgressTemplate>
	        <br />
	        <img src="Images/ActivityIndicator.gif" alt="" /> Processing your request.  Please wait....
        </ProgressTemplate>
    </asp:UpdateProgress>

    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server"
        TypeName="Northwind.BusinessObject.Products"
        SelectMethod="SelectAll" SortParameterName="sortExpression">
    </asp:ObjectDataSource>
</asp:Content>
