Imports System 
Imports Northwind.BusinessObject 
Imports System.Web.UI.WebControls 
' Imports System.Windows.Forms    ' Note: remove comment when using with windows forms 
 
''' <summary> 
''' These are data-centric code examples for the Suppliers _table. 
''' You can cut and paste the respective codes into your application 
''' by changing the sample values assigned from these examples. 
''' NOTE: This class contains private methods because they're 
''' not meant to be called by an outside client.  Each method contains 
''' code for the respective example being shown 
''' </summary> 
Public NotInheritable Class SuppliersExample 
 
    Private Sub New() 
    End Sub 
 
    Private Sub SelectAll() 
        ' select all records 
        Dim objSuppliersCol As SuppliersCollection = Suppliers.SelectAll() 
 
        ' Example 1:  you can optionally sort the collection in ascending order by your chosen field   
        objSuppliersCol.Sort(Suppliers.ByCompanyName) 
 
        ' Example 2:  to sort in descending order, add this line to the Sort code in Example 1 
        objSuppliersCol.Reverse() 
 
        ' Example 3:  directly bind to a GridView 
        Dim grid As GridView = New GridView() 
        grid.DataSource = objSuppliersCol 
        grid.DataBind() 
 
        ' Example 4:  loop through all the Suppliers 
        For Each objSuppliers As Suppliers In objSuppliersCol 
            Dim supplierID As Integer = objSuppliers.SupplierID 
            Dim companyName As String = objSuppliers.CompanyName 
            Dim contactName As String = objSuppliers.ContactName 
            Dim contactTitle As String = objSuppliers.ContactTitle 
            Dim address As String = objSuppliers.Address 
            Dim city As String = objSuppliers.City 
            Dim region As String = objSuppliers.Region 
            Dim postalCode As String = objSuppliers.PostalCode 
            Dim country As String = objSuppliers.Country 
            Dim phone As String = objSuppliers.Phone 
            Dim fax As String = objSuppliers.Fax 
            Dim homePage As String = objSuppliers.HomePage 
        Next 
    End Sub 
 
    Private Sub SelectByPrimaryKey() 
        ' select a record by primary key(s) 
        Dim objSuppliers As Suppliers = Suppliers.SelectByPrimaryKey(1) 
 
        If objSuppliers IsNot Nothing Then 
            ' if record is found, a record is returned 
            Dim supplierID As Integer = objSuppliers.SupplierID 
            Dim companyName As String = objSuppliers.CompanyName 
            Dim contactName As String = objSuppliers.ContactName 
            Dim contactTitle As String = objSuppliers.ContactTitle 
            Dim address As String = objSuppliers.Address 
            Dim city As String = objSuppliers.City 
            Dim region As String = objSuppliers.Region 
            Dim postalCode As String = objSuppliers.PostalCode 
            Dim country As String = objSuppliers.Country 
            Dim phone As String = objSuppliers.Phone 
            Dim fax As String = objSuppliers.Fax 
            Dim homePage As String = objSuppliers.HomePage 
        End If 
    End Sub 
 
    ''' <summary> 
    ''' Selects SupplierID and CompanyName columns for use with a with a Drop Down List, Combo Box, Checked Box List, List View, List Box, etc 
    ''' </summary> 
    Private Sub SelectSuppliersDropDownListData() 
        Dim objSuppliersCol As SuppliersCollection = Suppliers.SelectSuppliersDropDownListData() 
 
        ' Example 1:  directly bind to a drop down list 
        Dim ddl1 As DropDownList = New DropDownList() 
        ddl1.DataValueField = "SupplierID" 
        ddl1.DataTextField = "CompanyName" 
        ddl1.DataSource = objSuppliersCol 
        ddl1.DataBind() 
 
        ' Example 2:  add each item through a loop 
        Dim ddl2 As DropDownList = New DropDownList() 
 
        For Each objSuppliers As Suppliers In objSuppliersCol 
            ddl2.Items.Add(new ListItem(objSuppliers.CompanyName, objSuppliers.SupplierID.ToString())) 
        Next 
 
        ' Example 3:  bind to a combo box.  Note: remove comment when using with windows forms 
        ' Dim cbx1 As ComboBox = New ComboBox() 
 
        ' For Each objSuppliers As Suppliers In objSuppliersCol 
        '     cbx1.Items.Add(new ListItem(objSuppliers.CompanyName, objSuppliers.SupplierID.ToString())) 
        ' Next 
    End Sub 
 
    Private Sub Insert() 
        ' first instantiate a new Suppliers 
        Dim objSuppliers As New Suppliers() 
 
        ' assign values you want inserted 
        objSuppliers.CompanyName = "Exotic Liquids" 
        objSuppliers.ContactName = "Charlotte Cooper" 
        objSuppliers.ContactTitle = "Purchasing Manager" 
        objSuppliers.Address = "49 Gilbert St." 
        objSuppliers.City = "London" 
        objSuppliers.Region = "abc" 
        objSuppliers.PostalCode = "EC1 4SD" 
        objSuppliers.Country = "UK" 
        objSuppliers.Phone = "(171) 555-2222" 
        objSuppliers.Fax = "abc" 
        objSuppliers.HomePage = "abc" 
 
        ' finally, insert a new record 
        ' the insert method returns the newly created primary key 
        Dim newlyCreatedPrimaryKey As Integer = objSuppliers.Insert() 
    End Sub 
 
    Private Sub Update() 
        ' first instantiate a new Suppliers 
        Dim objSuppliers As New Suppliers() 
 
        ' assign the existing primary key(s) 
        ' of the record you want updated 
        objSuppliers.SupplierID = 1 
 
        ' assign values you want updated 
        objSuppliers.CompanyName = "Exotic Liquids" 
        objSuppliers.ContactName = "Charlotte Cooper" 
        objSuppliers.ContactTitle = "Purchasing Manager" 
        objSuppliers.Address = "49 Gilbert St." 
        objSuppliers.City = "London" 
        objSuppliers.Region = "abc" 
        objSuppliers.PostalCode = "EC1 4SD" 
        objSuppliers.Country = "UK" 
        objSuppliers.Phone = "(171) 555-2222" 
        objSuppliers.Fax = "abc" 
        objSuppliers.HomePage = "abc" 
 
        ' finally, update an existing record 
        objSuppliers.Update() 
    End Sub 
 
    Private Sub Delete() 
        ' delete a record by primary key 
        Suppliers.Delete(30) 
    End Sub 
End Class 
