Imports System 
Imports Northwind.BusinessObject 
Imports System.Web.UI.WebControls 
' Imports System.Windows.Forms    ' Note: remove comment when using with windows forms 
 
''' <summary> 
''' These are data-centric code examples for the Categories _table. 
''' You can cut and paste the respective codes into your application 
''' by changing the sample values assigned from these examples. 
''' NOTE: This class contains private methods because they're 
''' not meant to be called by an outside client.  Each method contains 
''' code for the respective example being shown 
''' </summary> 
Public NotInheritable Class CategoriesExample 
 
    Private Sub New() 
    End Sub 
 
    Private Sub SelectAll() 
        ' select all records 
        Dim objCategoriesCol As CategoriesCollection = Categories.SelectAll() 
 
        ' Example 1:  you can optionally sort the collection in ascending order by your chosen field   
        objCategoriesCol.Sort(Categories.ByCategoryName) 
 
        ' Example 2:  to sort in descending order, add this line to the Sort code in Example 1 
        objCategoriesCol.Reverse() 
 
        ' Example 3:  directly bind to a GridView 
        Dim grid As GridView = New GridView() 
        grid.DataSource = objCategoriesCol 
        grid.DataBind() 
 
        ' Example 4:  loop through all the Categories 
        For Each objCategories As Categories In objCategoriesCol 
            Dim categoryID As Integer = objCategories.CategoryID 
            Dim categoryName As String = objCategories.CategoryName 
            Dim description As String = objCategories.Description 
        Next 
    End Sub 
 
    Private Sub SelectByPrimaryKey() 
        ' select a record by primary key(s) 
        Dim objCategories As Categories = Categories.SelectByPrimaryKey(1) 
 
        If objCategories IsNot Nothing Then 
            ' if record is found, a record is returned 
            Dim categoryID As Integer = objCategories.CategoryID 
            Dim categoryName As String = objCategories.CategoryName 
            Dim description As String = objCategories.Description 
        End If 
    End Sub 
 
    ''' <summary> 
    ''' Selects CategoryID and CategoryName columns for use with a with a Drop Down List, Combo Box, Checked Box List, List View, List Box, etc 
    ''' </summary> 
    Private Sub SelectCategoriesDropDownListData() 
        Dim objCategoriesCol As CategoriesCollection = Categories.SelectCategoriesDropDownListData() 
 
        ' Example 1:  directly bind to a drop down list 
        Dim ddl1 As DropDownList = New DropDownList() 
        ddl1.DataValueField = "CategoryID" 
        ddl1.DataTextField = "CategoryName" 
        ddl1.DataSource = objCategoriesCol 
        ddl1.DataBind() 
 
        ' Example 2:  add each item through a loop 
        Dim ddl2 As DropDownList = New DropDownList() 
 
        For Each objCategories As Categories In objCategoriesCol 
            ddl2.Items.Add(new ListItem(objCategories.CategoryName, objCategories.CategoryID.ToString())) 
        Next 
 
        ' Example 3:  bind to a combo box.  Note: remove comment when using with windows forms 
        ' Dim cbx1 As ComboBox = New ComboBox() 
 
        ' For Each objCategories As Categories In objCategoriesCol 
        '     cbx1.Items.Add(new ListItem(objCategories.CategoryName, objCategories.CategoryID.ToString())) 
        ' Next 
    End Sub 
 
    Private Sub Insert() 
        ' first instantiate a new Categories 
        Dim objCategories As New Categories() 
 
        ' assign values you want inserted 
        objCategories.CategoryName = "aaaa abcde" 
        objCategories.Description = "here you go" 
 
        ' finally, insert a new record 
        ' the insert method returns the newly created primary key 
        Dim newlyCreatedPrimaryKey As Integer = objCategories.Insert() 
    End Sub 
 
    Private Sub Update() 
        ' first instantiate a new Categories 
        Dim objCategories As New Categories() 
 
        ' assign the existing primary key(s) 
        ' of the record you want updated 
        objCategories.CategoryID = 1 
 
        ' assign values you want updated 
        objCategories.CategoryName = "aaaa abcde" 
        objCategories.Description = "here you go" 
 
        ' finally, update an existing record 
        objCategories.Update() 
    End Sub 
 
    Private Sub Delete() 
        ' delete a record by primary key 
        Categories.Delete(153) 
    End Sub 
End Class 
