Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Northwind.BusinessObject
 
Namespace Northwind.DataLayer.Base
     ''' <summary>
     ''' Base class for SuppliersDataLayer.  Do not make changes to this class,
     ''' instead, put additional code in the SuppliersDataLayer class 
     ''' </summary>
     Public Class SuppliersDataLayerBase
 
         ' constructor 
         Public Sub New()
         End Sub 

         ''' <summary>
         ''' Selects a record by primary key(s)
         ''' </summary>
         Public Shared Function SelectByPrimaryKey(ByVal supplierID As Integer) As Suppliers
              Dim storedProcName As String = "[dbo].[Suppliers_SelectByPrimaryKey]" 
              Dim connection As SqlConnection = Dbase.GetConnection() 
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 

              ' parameters
              command.Parameters.AddWithValue("@supplierID", supplierID)

              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objSuppliers As Suppliers = Nothing 

              If ds.Tables(0).Rows.Count > 0 Then 
                  objSuppliers = New Suppliers() 
                  objSuppliers.SupplierID = DirectCast(ds.Tables(0).Rows(0)("SupplierID"), Integer) 
                  objSuppliers.CompanyName = DirectCast(ds.Tables(0).Rows(0)("CompanyName"), String) 

                  If Not ds.Tables(0).Rows(0)("ContactName").Equals(System.DBNull.Value) Then 
                      objSuppliers.ContactName = DirectCast(ds.Tables(0).Rows(0)("ContactName"), String) 
                  Else
                      objSuppliers.ContactName = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("ContactTitle").Equals(System.DBNull.Value) Then 
                      objSuppliers.ContactTitle = DirectCast(ds.Tables(0).Rows(0)("ContactTitle"), String) 
                  Else
                      objSuppliers.ContactTitle = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("Address").Equals(System.DBNull.Value) Then 
                      objSuppliers.Address = DirectCast(ds.Tables(0).Rows(0)("Address"), String) 
                  Else
                      objSuppliers.Address = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("City").Equals(System.DBNull.Value) Then 
                      objSuppliers.City = DirectCast(ds.Tables(0).Rows(0)("City"), String) 
                  Else
                      objSuppliers.City = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("Region").Equals(System.DBNull.Value) Then 
                      objSuppliers.Region = DirectCast(ds.Tables(0).Rows(0)("Region"), String) 
                  Else
                      objSuppliers.Region = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("PostalCode").Equals(System.DBNull.Value) Then 
                      objSuppliers.PostalCode = DirectCast(ds.Tables(0).Rows(0)("PostalCode"), String) 
                  Else
                      objSuppliers.PostalCode = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("Country").Equals(System.DBNull.Value) Then 
                      objSuppliers.Country = DirectCast(ds.Tables(0).Rows(0)("Country"), String) 
                  Else
                      objSuppliers.Country = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("Phone").Equals(System.DBNull.Value) Then 
                      objSuppliers.Phone = DirectCast(ds.Tables(0).Rows(0)("Phone"), String) 
                  Else
                      objSuppliers.Phone = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("Fax").Equals(System.DBNull.Value) Then 
                      objSuppliers.Fax = DirectCast(ds.Tables(0).Rows(0)("Fax"), String) 
                  Else
                      objSuppliers.Fax = Nothing
                  End If 

                  If Not ds.Tables(0).Rows(0)("HomePage").Equals(System.DBNull.Value) Then 
                      objSuppliers.HomePage = DirectCast(ds.Tables(0).Rows(0)("HomePage"), String) 
                  Else
                      objSuppliers.HomePage = Nothing
                  End If 

              End If
            command.Dispose() 
            connection.Close() 
            connection.Dispose() 
            ds.Dispose() 

            Return objSuppliers
         End Function 
 
         ''' <summary>
         ''' Selects all Suppliers 
         ''' </summary> 
         Public Shared Function SelectAll() As SuppliersCollection 
             Return SelectShared("[dbo].[Suppliers_SelectAll]", String.Empty, Nothing) 
         End Function 
 
         ''' <summary>
         ''' Selects SupplierID and CompanyName columns for use with a DropDownList web control 
         ''' </summary> 
         Public Shared Function SelectSuppliersDropDownListData() As SuppliersCollection 
              Dim storedProcName As String = "[dbo].[Suppliers_SelectDropDownListData]"
              Dim connection As SqlConnection = Dbase.GetConnection()
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection)
 
              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objSuppliersCol As New SuppliersCollection() 
              Dim objSuppliers As Suppliers 
 
              If ds.Tables(0).Rows.Count > 0 Then 
                 For Each dr As DataRow In ds.Tables(0).Rows 
                     objSuppliers = New Suppliers() 
                     objSuppliers.SupplierID = DirectCast(dr("SupplierID"), Integer) 
                     objSuppliers.CompanyName = DirectCast(dr("CompanyName"), String) 
 
                     objSuppliersCol.Add(objSuppliers)
                 Next 
              End If 
 
              command.Dispose() 
              connection.Close() 
              connection.Dispose() 
              ds.Dispose() 
 
              Return objSuppliersCol 
         End Function 
 
         Public Shared Function SelectShared(storedProcName As String, param As String, paramValue As Object) As SuppliersCollection 
              Dim connection As SqlConnection = Dbase.GetConnection() 
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 
 
              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objSuppliersCol As New SuppliersCollection() 
              Dim objSuppliers As Suppliers 
 
              If ds.Tables(0).Rows.Count > 0 Then 
                 For Each dr As DataRow In ds.Tables(0).Rows 
                     objSuppliers = New Suppliers() 
                     objSuppliers.SupplierID = DirectCast(dr("SupplierID"), Integer) 
                     objSuppliers.CompanyName = dr("CompanyName").ToString() 
 
                      If Not dr("ContactName").Equals(System.DBNull.Value) Then
                         objSuppliers.ContactName = dr("ContactName").ToString() 
                      Else 
                         objSuppliers.ContactName = Nothing 
                      End If 
 
                      If Not dr("ContactTitle").Equals(System.DBNull.Value) Then
                         objSuppliers.ContactTitle = dr("ContactTitle").ToString() 
                      Else 
                         objSuppliers.ContactTitle = Nothing 
                      End If 
 
                      If Not dr("Address").Equals(System.DBNull.Value) Then
                         objSuppliers.Address = dr("Address").ToString() 
                      Else 
                         objSuppliers.Address = Nothing 
                      End If 
 
                      If Not dr("City").Equals(System.DBNull.Value) Then
                         objSuppliers.City = dr("City").ToString() 
                      Else 
                         objSuppliers.City = Nothing 
                      End If 
 
                      If Not dr("Region").Equals(System.DBNull.Value) Then
                         objSuppliers.Region = dr("Region").ToString() 
                      Else 
                         objSuppliers.Region = Nothing 
                      End If 
 
                      If Not dr("PostalCode").Equals(System.DBNull.Value) Then
                         objSuppliers.PostalCode = dr("PostalCode").ToString() 
                      Else 
                         objSuppliers.PostalCode = Nothing 
                      End If 
 
                      If Not dr("Country").Equals(System.DBNull.Value) Then
                         objSuppliers.Country = dr("Country").ToString() 
                      Else 
                         objSuppliers.Country = Nothing 
                      End If 
 
                      If Not dr("Phone").Equals(System.DBNull.Value) Then
                         objSuppliers.Phone = dr("Phone").ToString() 
                      Else 
                         objSuppliers.Phone = Nothing 
                      End If 
 
                      If Not dr("Fax").Equals(System.DBNull.Value) Then
                         objSuppliers.Fax = dr("Fax").ToString() 
                      Else 
                         objSuppliers.Fax = Nothing 
                      End If 
 
                      If Not dr("HomePage").Equals(System.DBNull.Value) Then
                         objSuppliers.HomePage = dr("HomePage").ToString() 
                      Else 
                         objSuppliers.HomePage = Nothing 
                      End If 
 
                     objSuppliersCol.Add(objSuppliers) 
                 Next 
              End If 
 
              command.Dispose() 
              connection.Close() 
              connection.Dispose() 
              ds.Dispose() 
 
              Return objSuppliersCol 
         End Function 
 
         ''' <summary>
         ''' Inserts a record 
         ''' </summary> 
         Public Shared Function Insert(objSuppliers As Suppliers) As Integer 
             Dim storedProcName As String = "[dbo].[Suppliers_Insert]" 
             Return InsertUpdate(objSuppliers, False, storedProcName) 
         End Function 
 
         ''' <summary>
         ''' Updates a record 
         ''' </summary>
         Public Shared Sub Update(objSuppliers As Suppliers) 
             Dim storedProcName As String = "[dbo].[Suppliers_Update]" 
             InsertUpdate(objSuppliers, True, storedProcName) 
         End Sub 
 
         Private Shared Function InsertUpdate(ByVal objSuppliers As Suppliers, isUpdate As Boolean, storedProcName As String) As Integer 
             Dim connection As SqlConnection = Dbase.GetConnection() 
             Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 
 
             Dim contactName As Object = objSuppliers.ContactName 
             Dim contactTitle As Object = objSuppliers.ContactTitle 
             Dim address As Object = objSuppliers.Address 
             Dim city As Object = objSuppliers.City 
             Dim region As Object = objSuppliers.Region 
             Dim postalCode As Object = objSuppliers.PostalCode 
             Dim country As Object = objSuppliers.Country 
             Dim phone As Object = objSuppliers.Phone 
             Dim fax As Object = objSuppliers.Fax 
             Dim homePage As Object = objSuppliers.HomePage 
 
             If String.IsNullOrEmpty(objSuppliers.ContactName) Then 
                 contactName = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.ContactTitle) Then 
                 contactTitle = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.Address) Then 
                 address = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.City) Then 
                 city = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.Region) Then 
                 region = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.PostalCode) Then 
                 postalCode = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.Country) Then 
                 country = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.Phone) Then 
                 phone = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.Fax) Then 
                 fax = System.DBNull.Value 
             End If 
 
             If String.IsNullOrEmpty(objSuppliers.HomePage) Then 
                 homePage = System.DBNull.Value 
             End If 
 
             ' for update only 
             If isUpdate Then 
                 command.Parameters.AddWithValue("@supplierID", objSuppliers.SupplierID) 
             End If 
 
             command.Parameters.AddWithValue("@companyName", objSuppliers.CompanyName) 
             command.Parameters.AddWithValue("@contactName", contactName) 
             command.Parameters.AddWithValue("@contactTitle", contactTitle) 
             command.Parameters.AddWithValue("@address", address) 
             command.Parameters.AddWithValue("@city", city) 
             command.Parameters.AddWithValue("@region", region) 
             command.Parameters.AddWithValue("@postalCode", postalCode) 
             command.Parameters.AddWithValue("@country", country) 
             command.Parameters.AddWithValue("@phone", phone) 
             command.Parameters.AddWithValue("@fax", fax) 
             command.Parameters.AddWithValue("@homePage", homePage) 
 
             ' execute and return value 
             Dim newlyCreatedSupplierID As Integer = objSuppliers.SupplierID 
 
             If isUpdate Then 
                 command.ExecuteNonQuery() 
             Else 
                 newlyCreatedSupplierID = DirectCast(command.ExecuteScalar(), Integer) 
             End If 
 
             command.Dispose() 
             connection.Close() 
             connection.Dispose() 
 
             Return newlyCreatedSupplierID 
         End Function 
 
         ''' <summary>
         ''' Deletes a record based on primary key(s) 
         ''' </summary>
         Public Shared Sub Delete(ByVal supplierID As Integer) 
             Dim connection As SqlConnection = Dbase.GetConnection() 
             Dim command As SqlCommand = Dbase.GetCommand("[dbo].[Suppliers_Delete]", connection) 
 
             command.Parameters.AddWithValue("@supplierID", supplierID) 
 
             ' execute stored proc 
             command.ExecuteNonQuery() 
             command.Dispose() 
             connection.Close() 
             connection.Dispose() 
         End Sub 
     End Class
End Namespace
