Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Northwind.BusinessObject
 
Namespace Northwind.DataLayer.Base
     ''' <summary>
     ''' Base class for CategoriesDataLayer.  Do not make changes to this class,
     ''' instead, put additional code in the CategoriesDataLayer class 
     ''' </summary>
     Public Class CategoriesDataLayerBase
 
         ' constructor 
         Public Sub New()
         End Sub 

         ''' <summary>
         ''' Selects a record by primary key(s)
         ''' </summary>
         Public Shared Function SelectByPrimaryKey(ByVal categoryID As Integer) As Categories
              Dim storedProcName As String = "[dbo].[Categories_SelectByPrimaryKey]" 
              Dim connection As SqlConnection = Dbase.GetConnection() 
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 

              ' parameters
              command.Parameters.AddWithValue("@categoryID", categoryID)

              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objCategories As Categories = Nothing 

              If ds.Tables(0).Rows.Count > 0 Then 
                  objCategories = New Categories() 
                  objCategories.CategoryID = DirectCast(ds.Tables(0).Rows(0)("CategoryID"), Integer) 
                  objCategories.CategoryName = DirectCast(ds.Tables(0).Rows(0)("CategoryName"), String) 

                  If Not ds.Tables(0).Rows(0)("Description").Equals(System.DBNull.Value) Then 
                      objCategories.Description = DirectCast(ds.Tables(0).Rows(0)("Description"), String) 
                  Else
                      objCategories.Description = Nothing
                  End If 

              End If
            command.Dispose() 
            connection.Close() 
            connection.Dispose() 
            ds.Dispose() 

            Return objCategories
         End Function 
 
         ''' <summary>
         ''' Selects all Categories 
         ''' </summary> 
         Public Shared Function SelectAll() As CategoriesCollection 
             Return SelectShared("[dbo].[Categories_SelectAll]", String.Empty, Nothing) 
         End Function 
 
         ''' <summary>
         ''' Selects CategoryID and CategoryName columns for use with a DropDownList web control 
         ''' </summary> 
         Public Shared Function SelectCategoriesDropDownListData() As CategoriesCollection 
              Dim storedProcName As String = "[dbo].[Categories_SelectDropDownListData]"
              Dim connection As SqlConnection = Dbase.GetConnection()
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection)
 
              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objCategoriesCol As New CategoriesCollection() 
              Dim objCategories As Categories 
 
              If ds.Tables(0).Rows.Count > 0 Then 
                 For Each dr As DataRow In ds.Tables(0).Rows 
                     objCategories = New Categories() 
                     objCategories.CategoryID = DirectCast(dr("CategoryID"), Integer) 
                     objCategories.CategoryName = DirectCast(dr("CategoryName"), String) 
 
                     objCategoriesCol.Add(objCategories)
                 Next 
              End If 
 
              command.Dispose() 
              connection.Close() 
              connection.Dispose() 
              ds.Dispose() 
 
              Return objCategoriesCol 
         End Function 
 
         Public Shared Function SelectShared(storedProcName As String, param As String, paramValue As Object) As CategoriesCollection 
              Dim connection As SqlConnection = Dbase.GetConnection() 
              Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 
 
              Dim ds As DataSet = Dbase.GetDbaseDataSet(command) 
              Dim objCategoriesCol As New CategoriesCollection() 
              Dim objCategories As Categories 
 
              If ds.Tables(0).Rows.Count > 0 Then 
                 For Each dr As DataRow In ds.Tables(0).Rows 
                     objCategories = New Categories() 
                     objCategories.CategoryID = DirectCast(dr("CategoryID"), Integer) 
                     objCategories.CategoryName = dr("CategoryName").ToString() 
 
                      If Not dr("Description").Equals(System.DBNull.Value) Then
                         objCategories.Description = dr("Description").ToString() 
                      Else 
                         objCategories.Description = Nothing 
                      End If 
 
                     objCategoriesCol.Add(objCategories) 
                 Next 
              End If 
 
              command.Dispose() 
              connection.Close() 
              connection.Dispose() 
              ds.Dispose() 
 
              Return objCategoriesCol 
         End Function 
 
         ''' <summary>
         ''' Inserts a record 
         ''' </summary> 
         Public Shared Function Insert(objCategories As Categories) As Integer 
             Dim storedProcName As String = "[dbo].[Categories_Insert]" 
             Return InsertUpdate(objCategories, False, storedProcName) 
         End Function 
 
         ''' <summary>
         ''' Updates a record 
         ''' </summary>
         Public Shared Sub Update(objCategories As Categories) 
             Dim storedProcName As String = "[dbo].[Categories_Update]" 
             InsertUpdate(objCategories, True, storedProcName) 
         End Sub 
 
         Private Shared Function InsertUpdate(ByVal objCategories As Categories, isUpdate As Boolean, storedProcName As String) As Integer 
             Dim connection As SqlConnection = Dbase.GetConnection() 
             Dim command As SqlCommand = Dbase.GetCommand(storedProcName, connection) 
 
             Dim description As Object = objCategories.Description 
 
             If String.IsNullOrEmpty(objCategories.Description) Then 
                 description = System.DBNull.Value 
             End If 
 
             ' for update only 
             If isUpdate Then 
                 command.Parameters.AddWithValue("@categoryID", objCategories.CategoryID) 
             End If 
 
             command.Parameters.AddWithValue("@categoryName", objCategories.CategoryName) 
             command.Parameters.AddWithValue("@description", description) 
 
             ' execute and return value 
             Dim newlyCreatedCategoryID As Integer = objCategories.CategoryID 
 
             If isUpdate Then 
                 command.ExecuteNonQuery() 
             Else 
                 newlyCreatedCategoryID = DirectCast(command.ExecuteScalar(), Integer) 
             End If 
 
             command.Dispose() 
             connection.Close() 
             connection.Dispose() 
 
             Return newlyCreatedCategoryID 
         End Function 
 
         ''' <summary>
         ''' Deletes a record based on primary key(s) 
         ''' </summary>
         Public Shared Sub Delete(ByVal categoryID As Integer) 
             Dim connection As SqlConnection = Dbase.GetConnection() 
             Dim command As SqlCommand = Dbase.GetCommand("[dbo].[Categories_Delete]", connection) 
 
             command.Parameters.AddWithValue("@categoryID", categoryID) 
 
             ' execute stored proc 
             command.ExecuteNonQuery() 
             command.Dispose() 
             connection.Close() 
             connection.Dispose() 
         End Sub 
     End Class
End Namespace
