Imports System 
Imports System.Data 
Imports Northwind.DataLayer 
Imports Northwind.BusinessObject 
Imports System.Web.Script.Serialization 
 
Namespace Northwind.BusinessObject.Base 
 
     ''' <summary>
     ''' Base class for Suppliers.  Do not make changes to this class,
     ''' instead, put additional code in the Suppliers class 
     ''' </summary>
     Public Class SuppliersBase
         ' private members 
         Private _supplierID As Integer 
         Private _companyName As String 
         Private _contactName As String 
         Private _contactTitle As String 
         Private _address As String 
         Private _city As String 
         Private _region As String 
         Private _postalCode As String 
         Private _country As String 
         Private _phone As String 
         Private _fax As String 
         Private _homePage As String 
 
         ''' <summary>
         ''' Gets or Sets SupplierID 
         ''' </summary> 
         Public Property SupplierID() As Integer 
             Get 
                 Return _supplierID 
             End Get 
             Set(ByVal value As Integer) 
                 _supplierID = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets CompanyName 
         ''' </summary> 
         Public Property CompanyName() As String 
             Get 
                 Return _companyName 
             End Get 
             Set(ByVal value As String) 
                 _companyName = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets ContactName 
         ''' </summary> 
         Public Property ContactName() As String 
             Get 
                 Return _contactName 
             End Get 
             Set(ByVal value As String) 
                 _contactName = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets ContactTitle 
         ''' </summary> 
         Public Property ContactTitle() As String 
             Get 
                 Return _contactTitle 
             End Get 
             Set(ByVal value As String) 
                 _contactTitle = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Address 
         ''' </summary> 
         Public Property Address() As String 
             Get 
                 Return _address 
             End Get 
             Set(ByVal value As String) 
                 _address = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets City 
         ''' </summary> 
         Public Property City() As String 
             Get 
                 Return _city 
             End Get 
             Set(ByVal value As String) 
                 _city = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Region 
         ''' </summary> 
         Public Property Region() As String 
             Get 
                 Return _region 
             End Get 
             Set(ByVal value As String) 
                 _region = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets PostalCode 
         ''' </summary> 
         Public Property PostalCode() As String 
             Get 
                 Return _postalCode 
             End Get 
             Set(ByVal value As String) 
                 _postalCode = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Country 
         ''' </summary> 
         Public Property Country() As String 
             Get 
                 Return _country 
             End Get 
             Set(ByVal value As String) 
                 _country = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Phone 
         ''' </summary> 
         Public Property Phone() As String 
             Get 
                 Return _phone 
             End Get 
             Set(ByVal value As String) 
                 _phone = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Fax 
         ''' </summary> 
         Public Property Fax() As String 
             Get 
                 Return _fax 
             End Get 
             Set(ByVal value As String) 
                 _fax = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets HomePage 
         ''' </summary> 
         Public Property HomePage() As String 
             Get 
                 Return _homePage 
             End Get 
             Set(ByVal value As String) 
                 _homePage = value 
             End Set 
         End Property 

         ''' <summary> 
         ''' Gets the related Products(s) by SupplierID 
         ''' </summary> 
         <ScriptIgnore()> _ 
         Public ReadOnly Property ProductsCollection() As Lazy(Of ProductsCollection) 
             Get 
                 Dim value As Integer 
                 Dim hasValue As Boolean = Int32.TryParse(SupplierID.ToString(), value) 
 
                 If hasValue Then 
                     Return New Lazy(Of ProductsCollection)(Function() Northwind.BusinessObject.Products.SelectProductsCollectionBySuppliers(value)) 
                 Else 
                     Return Nothing 
                 End If 
             End Get 
         End Property 
 
 
         ''' <summary>
         ''' Constructor 
         ''' </summary> 
         Public Sub New()
         End Sub 
 
         ''' <summary>
         ''' Selects a record by primary key(s) 
         ''' </summary>
         Public Shared Function SelectByPrimaryKey(ByVal supplierID As Integer) As Suppliers 
             Return SuppliersDataLayer.SelectByPrimaryKey(supplierID) 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Suppliers 
         ''' </summary> 
         Public Shared Function SelectAll() As SuppliersCollection 
             return SuppliersDataLayer.SelectAll() 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Products sorted by the sort expression 
         ''' </summary> 
         Public Shared Function SelectAll(sortExpression As String) As SuppliersCollection 
             Dim objSuppliersCol As SuppliersCollection = SuppliersDataLayer.SelectAll() 
             Return SortByExpression(objSuppliersCol, sortExpression) 
         End Function 
 
         ''' <summary>
         ''' Selects SupplierID and CompanyName columns for use with a DropDownList web control, ComboBox, CheckedBoxList, ListView, ListBox, etc 
         ''' </summary> 
         Public Shared Function SelectSuppliersDropDownListData() As SuppliersCollection 
             Return SuppliersDataLayer.SelectSuppliersDropDownListData() 
         End Function 
 
         ''' <summary>
         ''' Sorts the SuppliersCollection by sort expression 
         ''' </summary> 
         Public Shared Function SortByExpression(objSuppliersCol As SuppliersCollection, sortExpression As String) As SuppliersCollection 
             Dim isSortDescending As Boolean = sortExpression.Contains(" DESC")

             If isSortDescending Then
                 sortExpression = sortExpression.Replace(" DESC", "")
             End If

             Select Case sortExpression
                 Case "SupplierID"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.BySupplierID)
                     Exit Select
                 Case "CompanyName"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCompanyName)
                     Exit Select
                 Case "ContactName"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByContactName)
                     Exit Select
                 Case "ContactTitle"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByContactTitle)
                     Exit Select
                 Case "Address"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByAddress)
                     Exit Select
                 Case "City"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCity)
                     Exit Select
                 Case "Region"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByRegion)
                     Exit Select
                 Case "PostalCode"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByPostalCode)
                     Exit Select
                 Case "Country"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCountry)
                     Exit Select
                 Case "Phone"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByPhone)
                     Exit Select
                 Case "Fax"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByFax)
                     Exit Select
                 Case "HomePage"
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByHomePage)
                     Exit Select
                 Case Else
                     Exit Select
             End Select

             If isSortDescending Then 
                 objSuppliersCol.Reverse()
             End If 

             Return objSuppliersCol
         End Function 
 
         ''' <summary>
         ''' Inserts a record 
         ''' </summary> 
         Public Function Insert() As Integer 
             Dim objSuppliers As Suppliers = DirectCast(Me, Suppliers) 
             Return SuppliersDataLayer.Insert(objSuppliers) 
         End Function 
 
         ''' <summary>
         ''' Updates a record 
         ''' </summary> 
         Public Sub Update() 
             Dim objSuppliers As Suppliers = DirectCast(Me, Suppliers) 
             SuppliersDataLayer.Update(objSuppliers) 
         End Sub 
 
         ''' <summary>
         ''' Deletes a record based on primary key(s) 
         ''' </summary>
         Public Shared Sub Delete(ByVal supplierID As Integer) 
             SuppliersDataLayer.Delete(supplierID) 
         End Sub 
 
         ''' <summary> 
         ''' Compares SupplierID used for sorting 
         ''' </summary> 
         Public Shared BySupplierID As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Return x.SupplierID.CompareTo(y.SupplierID) 
         End Function 
 
         ''' <summary> 
         ''' Compares CompanyName used for sorting 
         ''' </summary> 
         Public Shared ByCompanyName As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.CompanyName, String.Empty) 
             Dim value2 As String = If(y.CompanyName, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares ContactName used for sorting 
         ''' </summary> 
         Public Shared ByContactName As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.ContactName, String.Empty) 
             Dim value2 As String = If(y.ContactName, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares ContactTitle used for sorting 
         ''' </summary> 
         Public Shared ByContactTitle As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.ContactTitle, String.Empty) 
             Dim value2 As String = If(y.ContactTitle, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Address used for sorting 
         ''' </summary> 
         Public Shared ByAddress As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.Address, String.Empty) 
             Dim value2 As String = If(y.Address, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares City used for sorting 
         ''' </summary> 
         Public Shared ByCity As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.City, String.Empty) 
             Dim value2 As String = If(y.City, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Region used for sorting 
         ''' </summary> 
         Public Shared ByRegion As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.Region, String.Empty) 
             Dim value2 As String = If(y.Region, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares PostalCode used for sorting 
         ''' </summary> 
         Public Shared ByPostalCode As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.PostalCode, String.Empty) 
             Dim value2 As String = If(y.PostalCode, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Country used for sorting 
         ''' </summary> 
         Public Shared ByCountry As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.Country, String.Empty) 
             Dim value2 As String = If(y.Country, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Phone used for sorting 
         ''' </summary> 
         Public Shared ByPhone As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.Phone, String.Empty) 
             Dim value2 As String = If(y.Phone, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Fax used for sorting 
         ''' </summary> 
         Public Shared ByFax As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.Fax, String.Empty) 
             Dim value2 As String = If(y.Fax, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares HomePage used for sorting 
         ''' </summary> 
         Public Shared ByHomePage As Comparison(Of Suppliers) = 
         Function(ByVal x As Suppliers, ByVal y As Suppliers) 
             Dim value1 As String = If(x.HomePage, String.Empty) 
             Dim value2 As String = If(y.HomePage, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
     End Class 
End Namespace 
