Imports System 
Imports System.Data 
Imports Northwind.DataLayer 
Imports Northwind.BusinessObject 
Imports System.Web.Script.Serialization 
 
Namespace Northwind.BusinessObject.Base 
 
     ''' <summary>
     ''' Base class for Products.  Do not make changes to this class,
     ''' instead, put additional code in the Products class 
     ''' </summary>
     Public Class ProductsBase
         ' private members 
         Private _productID As Integer 
         Private _productName As String 
         Private _supplierID As System.Nullable(Of Integer) 
         Private _categoryID As System.Nullable(Of Integer) 
         Private _quantityPerUnit As String 
         Private _unitPrice As System.Nullable(Of Decimal) 
         Private _unitsInStock As System.Nullable(Of Short) 
         Private _unitsOnOrder As System.Nullable(Of Short) 
         Private _reorderLevel As System.Nullable(Of Short) 
         Private _discontinued As Boolean 
 
         ''' <summary>
         ''' Gets or Sets ProductID 
         ''' </summary> 
         Public Property ProductID() As Integer 
             Get 
                 Return _productID 
             End Get 
             Set(ByVal value As Integer) 
                 _productID = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets ProductName 
         ''' </summary> 
         Public Property ProductName() As String 
             Get 
                 Return _productName 
             End Get 
             Set(ByVal value As String) 
                 _productName = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets SupplierID 
         ''' </summary> 
         Public Property SupplierID() As System.Nullable(Of Integer) 
             Get 
                 Return _supplierID 
             End Get 
             Set(ByVal value As System.Nullable(Of Integer)) 
                 _supplierID = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets CategoryID 
         ''' </summary> 
         Public Property CategoryID() As System.Nullable(Of Integer) 
             Get 
                 Return _categoryID 
             End Get 
             Set(ByVal value As System.Nullable(Of Integer)) 
                 _categoryID = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets QuantityPerUnit 
         ''' </summary> 
         Public Property QuantityPerUnit() As String 
             Get 
                 Return _quantityPerUnit 
             End Get 
             Set(ByVal value As String) 
                 _quantityPerUnit = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets UnitPrice 
         ''' </summary> 
         Public Property UnitPrice() As System.Nullable(Of Decimal) 
             Get 
                 Return _unitPrice 
             End Get 
             Set(ByVal value As System.Nullable(Of Decimal)) 
                 _unitPrice = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets UnitsInStock 
         ''' </summary> 
         Public Property UnitsInStock() As System.Nullable(Of Short) 
             Get 
                 Return _unitsInStock 
             End Get 
             Set(ByVal value As System.Nullable(Of Short)) 
                 _unitsInStock = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets UnitsOnOrder 
         ''' </summary> 
         Public Property UnitsOnOrder() As System.Nullable(Of Short) 
             Get 
                 Return _unitsOnOrder 
             End Get 
             Set(ByVal value As System.Nullable(Of Short)) 
                 _unitsOnOrder = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets ReorderLevel 
         ''' </summary> 
         Public Property ReorderLevel() As System.Nullable(Of Short) 
             Get 
                 Return _reorderLevel 
             End Get 
             Set(ByVal value As System.Nullable(Of Short)) 
                 _reorderLevel = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Discontinued 
         ''' </summary> 
         Public Property Discontinued() As Boolean 
             Get 
                 Return _discontinued 
             End Get 
             Set(ByVal value As Boolean) 
                 _discontinued = value 
             End Set 
         End Property 

         ''' <summary> 
         ''' Gets the Related Suppliers.  Related to column SupplierID 
         ''' </summary> 
         <ScriptIgnore> _ 
         Public ReadOnly Property Suppliers() As Lazy(Of Suppliers) 
             Get
                 Dim value As Integer 
                 Dim hasValue As Boolean = Int32.TryParse(SupplierID.ToString(), value) 
 
                 If hasValue Then 
                     Return New Lazy(Of Suppliers)(Function()Northwind.BusinessObject.Suppliers.SelectByPrimaryKey(value))
                 Else 
                     Return Nothing 
                 End If 
             End Get
         End Property
 
         ''' <summary> 
         ''' Gets the Related Categories.  Related to column CategoryID 
         ''' </summary> 
         <ScriptIgnore> _ 
         Public ReadOnly Property Categories() As Lazy(Of Categories) 
             Get
                 Dim value As Integer 
                 Dim hasValue As Boolean = Int32.TryParse(CategoryID.ToString(), value) 
 
                 If hasValue Then 
                     Return New Lazy(Of Categories)(Function()Northwind.BusinessObject.Categories.SelectByPrimaryKey(value))
                 Else 
                     Return Nothing 
                 End If 
             End Get
         End Property
 
 
         ''' <summary>
         ''' Constructor 
         ''' </summary> 
         Public Sub New()
         End Sub 
 
         ''' <summary>
         ''' Selects a record by primary key(s) 
         ''' </summary>
         Public Shared Function SelectByPrimaryKey(ByVal productID As Integer) As Products 
             Return ProductsDataLayer.SelectByPrimaryKey(productID) 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Products 
         ''' </summary> 
         Public Shared Function SelectAll() As ProductsCollection 
             return ProductsDataLayer.SelectAll() 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Products sorted by the sort expression 
         ''' </summary> 
         Public Shared Function SelectAll(sortExpression As String) As ProductsCollection 
             Dim objProductsCol As ProductsCollection = ProductsDataLayer.SelectAll() 
             Return SortByExpression(objProductsCol, sortExpression) 
         End Function 
 
         ''' <summary> 
         ''' Selects all Products by Suppliers, related to column SupplierID 
         ''' </summary>  
         Public Shared Function SelectProductsCollectionBySuppliers(supplierID As Integer) As ProductsCollection 
             Return ProductsDataLayer.SelectProductsCollectionBySuppliers(supplierID) 
         End Function 
          
         ''' <summary> 
         ''' Selects all Products by Suppliers, related to column SupplierID, sorted by the sort expression 
         ''' </summary> 
         Public Shared Function SelectProductsCollectionBySuppliers(supplierID As Integer, sortExpression As String) As ProductsCollection 
             Dim objProductsCol As ProductsCollection = ProductsDataLayer.SelectProductsCollectionBySuppliers(supplierID) 
             Return SortByExpression(objProductsCol, sortExpression) 
         End Function 
 
         ''' <summary> 
         ''' Selects all Products by Categories, related to column CategoryID 
         ''' </summary>  
         Public Shared Function SelectProductsCollectionByCategories(categoryID As Integer) As ProductsCollection 
             Return ProductsDataLayer.SelectProductsCollectionByCategories(categoryID) 
         End Function 
          
         ''' <summary> 
         ''' Selects all Products by Categories, related to column CategoryID, sorted by the sort expression 
         ''' </summary> 
         Public Shared Function SelectProductsCollectionByCategories(categoryID As Integer, sortExpression As String) As ProductsCollection 
             Dim objProductsCol As ProductsCollection = ProductsDataLayer.SelectProductsCollectionByCategories(categoryID) 
             Return SortByExpression(objProductsCol, sortExpression) 
         End Function 
 
         ''' <summary>
         ''' Selects ProductID and ProductName columns for use with a DropDownList web control, ComboBox, CheckedBoxList, ListView, ListBox, etc 
         ''' </summary> 
         Public Shared Function SelectProductsDropDownListData() As ProductsCollection 
             Return ProductsDataLayer.SelectProductsDropDownListData() 
         End Function 
 
         ''' <summary>
         ''' Sorts the ProductsCollection by sort expression 
         ''' </summary> 
         Public Shared Function SortByExpression(objProductsCol As ProductsCollection, sortExpression As String) As ProductsCollection 
             Dim isSortDescending As Boolean = sortExpression.Contains(" DESC")

             If isSortDescending Then
                 sortExpression = sortExpression.Replace(" DESC", "")
             End If

             Select Case sortExpression
                 Case "ProductID"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByProductID)
                     Exit Select
                 Case "ProductName"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByProductName)
                     Exit Select
                 Case "SupplierID"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.BySupplierID)
                     Exit Select
                 Case "CategoryID"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByCategoryID)
                     Exit Select
                 Case "QuantityPerUnit"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByQuantityPerUnit)
                     Exit Select
                 Case "UnitPrice"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByUnitPrice)
                     Exit Select
                 Case "UnitsInStock"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByUnitsInStock)
                     Exit Select
                 Case "UnitsOnOrder"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByUnitsOnOrder)
                     Exit Select
                 Case "ReorderLevel"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByReorderLevel)
                     Exit Select
                 Case "Discontinued"
                     objProductsCol.Sort(Northwind.BusinessObject.Products.ByDiscontinued)
                     Exit Select
                 Case Else
                     Exit Select
             End Select

             If isSortDescending Then 
                 objProductsCol.Reverse()
             End If 

             Return objProductsCol
         End Function 
 
         ''' <summary>
         ''' Inserts a record 
         ''' </summary> 
         Public Function Insert() As Integer 
             Dim objProducts As Products = DirectCast(Me, Products) 
             Return ProductsDataLayer.Insert(objProducts) 
         End Function 
 
         ''' <summary>
         ''' Updates a record 
         ''' </summary> 
         Public Sub Update() 
             Dim objProducts As Products = DirectCast(Me, Products) 
             ProductsDataLayer.Update(objProducts) 
         End Sub 
 
         ''' <summary>
         ''' Deletes a record based on primary key(s) 
         ''' </summary>
         Public Shared Sub Delete(ByVal productID As Integer) 
             ProductsDataLayer.Delete(productID) 
         End Sub 
 
         ''' <summary> 
         ''' Compares ProductID used for sorting 
         ''' </summary> 
         Public Shared ByProductID As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return x.ProductID.CompareTo(y.ProductID) 
         End Function 
 
         ''' <summary> 
         ''' Compares ProductName used for sorting 
         ''' </summary> 
         Public Shared ByProductName As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Dim value1 As String = If(x.ProductName, String.Empty) 
             Dim value2 As String = If(y.ProductName, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares SupplierID used for sorting 
         ''' </summary> 
         Public Shared BySupplierID As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.SupplierID, y.SupplierID) 
         End Function 
 
         ''' <summary> 
         ''' Compares CategoryID used for sorting 
         ''' </summary> 
         Public Shared ByCategoryID As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.CategoryID, y.CategoryID) 
         End Function 
 
         ''' <summary> 
         ''' Compares QuantityPerUnit used for sorting 
         ''' </summary> 
         Public Shared ByQuantityPerUnit As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Dim value1 As String = If(x.QuantityPerUnit, String.Empty) 
             Dim value2 As String = If(y.QuantityPerUnit, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares UnitPrice used for sorting 
         ''' </summary> 
         Public Shared ByUnitPrice As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.UnitPrice, y.UnitPrice) 
         End Function 
 
         ''' <summary> 
         ''' Compares UnitsInStock used for sorting 
         ''' </summary> 
         Public Shared ByUnitsInStock As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.UnitsInStock, y.UnitsInStock) 
         End Function 
 
         ''' <summary> 
         ''' Compares UnitsOnOrder used for sorting 
         ''' </summary> 
         Public Shared ByUnitsOnOrder As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.UnitsOnOrder, y.UnitsOnOrder) 
         End Function 
 
         ''' <summary> 
         ''' Compares ReorderLevel used for sorting 
         ''' </summary> 
         Public Shared ByReorderLevel As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return Nullable.Compare(x.ReorderLevel, y.ReorderLevel) 
         End Function 
 
         ''' <summary> 
         ''' Compares Discontinued used for sorting 
         ''' </summary> 
         Public Shared ByDiscontinued As Comparison(Of Products) = 
         Function(ByVal x As Products, ByVal y As Products) 
             Return x.Discontinued.CompareTo(y.Discontinued) 
         End Function 
 
     End Class 
End Namespace 
