Imports System 
Imports System.Data 
Imports Northwind.DataLayer 
Imports Northwind.BusinessObject 
Imports System.Web.Script.Serialization 
 
Namespace Northwind.BusinessObject.Base 
 
     ''' <summary>
     ''' Base class for Categories.  Do not make changes to this class,
     ''' instead, put additional code in the Categories class 
     ''' </summary>
     Public Class CategoriesBase
         ' private members 
         Private _categoryID As Integer 
         Private _categoryName As String 
         Private _description As String 
 
         ''' <summary>
         ''' Gets or Sets CategoryID 
         ''' </summary> 
         Public Property CategoryID() As Integer 
             Get 
                 Return _categoryID 
             End Get 
             Set(ByVal value As Integer) 
                 _categoryID = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets CategoryName 
         ''' </summary> 
         Public Property CategoryName() As String 
             Get 
                 Return _categoryName 
             End Get 
             Set(ByVal value As String) 
                 _categoryName = value 
             End Set 
         End Property 

         ''' <summary>
         ''' Gets or Sets Description 
         ''' </summary> 
         Public Property Description() As String 
             Get 
                 Return _description 
             End Get 
             Set(ByVal value As String) 
                 _description = value 
             End Set 
         End Property 

         ''' <summary> 
         ''' Gets the related Products(s) by CategoryID 
         ''' </summary> 
         <ScriptIgnore()> _ 
         Public ReadOnly Property ProductsCollection() As Lazy(Of ProductsCollection) 
             Get 
                 Dim value As Integer 
                 Dim hasValue As Boolean = Int32.TryParse(CategoryID.ToString(), value) 
 
                 If hasValue Then 
                     Return New Lazy(Of ProductsCollection)(Function() Northwind.BusinessObject.Products.SelectProductsCollectionByCategories(value)) 
                 Else 
                     Return Nothing 
                 End If 
             End Get 
         End Property 
 
 
         ''' <summary>
         ''' Constructor 
         ''' </summary> 
         Public Sub New()
         End Sub 
 
         ''' <summary>
         ''' Selects a record by primary key(s) 
         ''' </summary>
         Public Shared Function SelectByPrimaryKey(ByVal categoryID As Integer) As Categories 
             Return CategoriesDataLayer.SelectByPrimaryKey(categoryID) 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Categories 
         ''' </summary> 
         Public Shared Function SelectAll() As CategoriesCollection 
             return CategoriesDataLayer.SelectAll() 
         End Function 
 
         ''' <summary> 
         ''' Selects all records as a collection (List) of Products sorted by the sort expression 
         ''' </summary> 
         Public Shared Function SelectAll(sortExpression As String) As CategoriesCollection 
             Dim objCategoriesCol As CategoriesCollection = CategoriesDataLayer.SelectAll() 
             Return SortByExpression(objCategoriesCol, sortExpression) 
         End Function 
 
         ''' <summary>
         ''' Selects CategoryID and CategoryName columns for use with a DropDownList web control, ComboBox, CheckedBoxList, ListView, ListBox, etc 
         ''' </summary> 
         Public Shared Function SelectCategoriesDropDownListData() As CategoriesCollection 
             Return CategoriesDataLayer.SelectCategoriesDropDownListData() 
         End Function 
 
         ''' <summary>
         ''' Sorts the CategoriesCollection by sort expression 
         ''' </summary> 
         Public Shared Function SortByExpression(objCategoriesCol As CategoriesCollection, sortExpression As String) As CategoriesCollection 
             Dim isSortDescending As Boolean = sortExpression.Contains(" DESC")

             If isSortDescending Then
                 sortExpression = sortExpression.Replace(" DESC", "")
             End If

             Select Case sortExpression
                 Case "CategoryID"
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByCategoryID)
                     Exit Select
                 Case "CategoryName"
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByCategoryName)
                     Exit Select
                 Case "Description"
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByDescription)
                     Exit Select
                 Case Else
                     Exit Select
             End Select

             If isSortDescending Then 
                 objCategoriesCol.Reverse()
             End If 

             Return objCategoriesCol
         End Function 
 
         ''' <summary>
         ''' Inserts a record 
         ''' </summary> 
         Public Function Insert() As Integer 
             Dim objCategories As Categories = DirectCast(Me, Categories) 
             Return CategoriesDataLayer.Insert(objCategories) 
         End Function 
 
         ''' <summary>
         ''' Updates a record 
         ''' </summary> 
         Public Sub Update() 
             Dim objCategories As Categories = DirectCast(Me, Categories) 
             CategoriesDataLayer.Update(objCategories) 
         End Sub 
 
         ''' <summary>
         ''' Deletes a record based on primary key(s) 
         ''' </summary>
         Public Shared Sub Delete(ByVal categoryID As Integer) 
             CategoriesDataLayer.Delete(categoryID) 
         End Sub 
 
         ''' <summary> 
         ''' Compares CategoryID used for sorting 
         ''' </summary> 
         Public Shared ByCategoryID As Comparison(Of Categories) = 
         Function(ByVal x As Categories, ByVal y As Categories) 
             Return x.CategoryID.CompareTo(y.CategoryID) 
         End Function 
 
         ''' <summary> 
         ''' Compares CategoryName used for sorting 
         ''' </summary> 
         Public Shared ByCategoryName As Comparison(Of Categories) = 
         Function(ByVal x As Categories, ByVal y As Categories) 
             Dim value1 As String = If(x.CategoryName, String.Empty) 
             Dim value2 As String = If(y.CategoryName, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
         ''' <summary> 
         ''' Compares Description used for sorting 
         ''' </summary> 
         Public Shared ByDescription As Comparison(Of Categories) = 
         Function(ByVal x As Categories, ByVal y As Categories) 
             Dim value1 As String = If(x.Description, String.Empty) 
             Dim value2 As String = If(y.Description, String.Empty) 
             Return value1.CompareTo(value2) 
         End Function 
 
     End Class 
End Namespace 
