using System;
using System.Data;
using System.Data.SqlClient;

namespace Northwind.DataLayer
{
     public sealed class Dbase
     {
         private Dbase()
         {
         }

         public static SqlConnection GetConnection()
         {
             string connectionString = "Data Source=localhost;Initial Catalog=Northwind;User ID=USERNAME;Password=PASSWORD";
             SqlConnection connection = new SqlConnection(connectionString);
             connection.Open();
             return connection;
         }

         public static SqlCommand GetCommand(string storedProcedureName, SqlConnection connection)
         {
             SqlCommand command = new SqlCommand(storedProcedureName, connection);
             command.CommandType = CommandType.StoredProcedure;
             return command;
         }

         public static SqlCommand GetCommand(SqlConnection connection, string sql)
         {
             SqlCommand command = new SqlCommand(sql, connection);
             command.CommandType = CommandType.Text;
             return command;
         }

         public static DataSet GetDbaseDataSet(SqlCommand command)
         {
             SqlDataAdapter adapter = new SqlDataAdapter(command);
             DataSet dataset = ((DataSet)Activator.CreateInstance(typeof(DataSet)));
             adapter.Fill(dataset);
             adapter.Dispose();
             return dataset;
         }
     }
}
