using System; 
using Northwind.BusinessObject; 
using System.Web.UI.WebControls; 
// using System.Windows.Forms;    // Note: remove comment when using with windows forms 
 
/// <summary> 
/// These are data-centric code examples for the Suppliers table. 
/// You can cut and paste the respective codes into your application 
/// by changing the sample values assigned from these examples. 
/// NOTE: This class contains private methods because they're 
/// not meant to be called by an outside client.  Each method contains 
/// code for the respective example being shown 
/// </summary> 
public sealed class SuppliersExample 
{ 
    private SuppliersExample() 
    { 
    } 
 
    private void SelectAll() 
    { 
        // select all records 
        SuppliersCollection objSuppliersCol = Suppliers.SelectAll(); 
 
        // Example 1:  you can optionally sort the collection in ascending order by your chosen field  
        objSuppliersCol.Sort(Suppliers.ByCompanyName); 
 
        // Example 2:  to sort in descending order, add this line to the Sort code in Example 1  
        objSuppliersCol.Reverse(); 
 
        // Example 3:  directly bind to a GridView 
        GridView grid = new GridView(); 
        grid.DataSource = objSuppliersCol; 
        grid.DataBind(); 
 
        // Example 4:  loop through all the Suppliers(s) 
        foreach (Suppliers objSuppliers in objSuppliersCol) 
        { 
            int supplierID = objSuppliers.SupplierID; 
            string companyName = objSuppliers.CompanyName; 
            string contactName = objSuppliers.ContactName; 
            string contactTitle = objSuppliers.ContactTitle; 
            string address = objSuppliers.Address; 
            string city = objSuppliers.City; 
            string region = objSuppliers.Region; 
            string postalCode = objSuppliers.PostalCode; 
            string country = objSuppliers.Country; 
            string phone = objSuppliers.Phone; 
            string fax = objSuppliers.Fax; 
            string homePage = objSuppliers.HomePage; 
        } 
    } 
 
    private void SelectByPrimaryKey() 
    { 
        // select a record by primary key(s) 
        Suppliers objSuppliers = Suppliers.SelectByPrimaryKey(1); 
 
        if (objSuppliers != null) 
        { 
            // if record is found, a record is returned 
            int supplierID = objSuppliers.SupplierID; 
            string companyName = objSuppliers.CompanyName; 
            string contactName = objSuppliers.ContactName; 
            string contactTitle = objSuppliers.ContactTitle; 
            string address = objSuppliers.Address; 
            string city = objSuppliers.City; 
            string region = objSuppliers.Region; 
            string postalCode = objSuppliers.PostalCode; 
            string country = objSuppliers.Country; 
            string phone = objSuppliers.Phone; 
            string fax = objSuppliers.Fax; 
            string homePage = objSuppliers.HomePage; 
        } 
    } 
 
    /// <summary> 
    /// Selects SupplierID and CompanyName columns for use with a with a Drop Down List, Combo Box, Checked Box List, List View, List Box, etc 
    /// </summary> 
    private void SelectSuppliersDropDownListData() 
    { 
        SuppliersCollection objSuppliersCol = Suppliers.SelectSuppliersDropDownListData(); 
 
        // Example 1:  directly bind to a drop down list 
        DropDownList ddl1 = new DropDownList(); 
        ddl1.DataValueField = "SupplierID"; 
        ddl1.DataTextField = "CompanyName"; 
        ddl1.DataSource = objSuppliersCol; 
        ddl1.DataBind(); 
 
        // Example 2:  add each item through a loop 
        DropDownList ddl2 = new DropDownList(); 
 
        foreach (Suppliers objSuppliers in objSuppliersCol) 
        { 
            ddl2.Items.Add(new ListItem(objSuppliers.CompanyName, objSuppliers.SupplierID.ToString())); 
        } 
 
        // Example 3:  bind to a combo box.  Note: remove comment when using with windows forms 
        // ComboBox cbx1 = new ComboBox(); 
 
        // foreach (Suppliers objSuppliers in objSuppliersCol) 
        // { 
        //     cbx1.Items.Add(new ListItem(objSuppliers.CompanyName, objSuppliers.SupplierID.ToString())); 
        // } 
    } 
 
    private void Insert() 
    { 
        // first instantiate a new Suppliers 
        Suppliers objSuppliers = new Suppliers(); 
 
        // assign values you want inserted 
        objSuppliers.CompanyName = "Exotic Liquids"; 
        objSuppliers.ContactName = "Charlotte Cooper"; 
        objSuppliers.ContactTitle = "Purchasing Manager"; 
        objSuppliers.Address = "49 Gilbert St."; 
        objSuppliers.City = "London"; 
        objSuppliers.Region = "abc"; 
        objSuppliers.PostalCode = "EC1 4SD"; 
        objSuppliers.Country = "UK"; 
        objSuppliers.Phone = "(171) 555-2222"; 
        objSuppliers.Fax = "abc"; 
        objSuppliers.HomePage = "abc"; 
 
        // finally, insert a new record 
        // the insert method returns the newly created primary key 
        int newlyCreatedPrimaryKey = objSuppliers.Insert(); 
    } 
 
    private void Update() 
    { 
        // first instantiate a new Suppliers 
        Suppliers objSuppliers = new Suppliers(); 
 
        // assign the existing primary key(s) 
        // of the record you want updated 
        objSuppliers.SupplierID = 1; 
 
        // assign values you want updated 
        objSuppliers.CompanyName = "Exotic Liquids"; 
        objSuppliers.ContactName = "Charlotte Cooper"; 
        objSuppliers.ContactTitle = "Purchasing Manager"; 
        objSuppliers.Address = "49 Gilbert St."; 
        objSuppliers.City = "London"; 
        objSuppliers.Region = "abc"; 
        objSuppliers.PostalCode = "EC1 4SD"; 
        objSuppliers.Country = "UK"; 
        objSuppliers.Phone = "(171) 555-2222"; 
        objSuppliers.Fax = "abc"; 
        objSuppliers.HomePage = "abc"; 
 
        // finally, update an existing record 
        objSuppliers.Update(); 
    } 
 
    private void Delete() 
    { 
        // delete a record by primary key 
        Suppliers.Delete(30); 
    } 
} 
