using System; 
using Northwind.BusinessObject; 
using System.Web.UI.WebControls; 
// using System.Windows.Forms;    // Note: remove comment when using with windows forms 
 
/// <summary> 
/// These are data-centric code examples for the Products table. 
/// You can cut and paste the respective codes into your application 
/// by changing the sample values assigned from these examples. 
/// NOTE: This class contains private methods because they're 
/// not meant to be called by an outside client.  Each method contains 
/// code for the respective example being shown 
/// </summary> 
public sealed class ProductsExample 
{ 
    private ProductsExample() 
    { 
    } 
 
    private void SelectAll() 
    { 
        // select all records 
        ProductsCollection objProductsCol = Products.SelectAll(); 
 
        // Example 1:  you can optionally sort the collection in ascending order by your chosen field  
        objProductsCol.Sort(Products.ByProductName); 
 
        // Example 2:  to sort in descending order, add this line to the Sort code in Example 1  
        objProductsCol.Reverse(); 
 
        // Example 3:  directly bind to a GridView 
        GridView grid = new GridView(); 
        grid.DataSource = objProductsCol; 
        grid.DataBind(); 
 
        // Example 4:  loop through all the Products(s) 
        foreach (Products objProducts in objProductsCol) 
        { 
            int productID = objProducts.ProductID; 
            string productName = objProducts.ProductName; 
            int? supplierID = objProducts.SupplierID; 
            int? categoryID = objProducts.CategoryID; 
            string quantityPerUnit = objProducts.QuantityPerUnit; 
            decimal? unitPrice = objProducts.UnitPrice; 
            Int16? unitsInStock = objProducts.UnitsInStock; 
            Int16? unitsOnOrder = objProducts.UnitsOnOrder; 
            Int16? reorderLevel = objProducts.ReorderLevel; 
            bool discontinued = objProducts.Discontinued; 
 
            // optionally get the Suppliers related to SupplierID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.SupplierID != null) 
            { 
                Suppliers objSuppliersRelatedToSupplierID; 
 
                if (objProducts.Suppliers.IsValueCreated) 
                    objSuppliersRelatedToSupplierID = objProducts.Suppliers.Value; 
            } 
 
            // optionally get the Categories related to CategoryID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.CategoryID != null) 
            { 
                Categories objCategoriesRelatedToCategoryID; 
 
                if (objProducts.Categories.IsValueCreated) 
                    objCategoriesRelatedToCategoryID = objProducts.Categories.Value; 
            } 
        } 
    } 
 
    private void SelectByPrimaryKey() 
    { 
        // select a record by primary key(s) 
        Products objProducts = Products.SelectByPrimaryKey(1); 
 
        if (objProducts != null) 
        { 
            // if record is found, a record is returned 
            int productID = objProducts.ProductID; 
            string productName = objProducts.ProductName; 
            int? supplierID = objProducts.SupplierID; 
            int? categoryID = objProducts.CategoryID; 
            string quantityPerUnit = objProducts.QuantityPerUnit; 
            decimal? unitPrice = objProducts.UnitPrice; 
            Int16? unitsInStock = objProducts.UnitsInStock; 
            Int16? unitsOnOrder = objProducts.UnitsOnOrder; 
            Int16? reorderLevel = objProducts.ReorderLevel; 
            bool discontinued = objProducts.Discontinued; 
 
            // optionally get the Suppliers related to SupplierID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.SupplierID != null) 
            { 
                Suppliers objSuppliersRelatedToSupplierID; 
 
                if (objProducts.Suppliers.IsValueCreated) 
                    objSuppliersRelatedToSupplierID = objProducts.Suppliers.Value; 
            } 
 
            // optionally get the Categories related to CategoryID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.CategoryID != null) 
            { 
                Categories objCategoriesRelatedToCategoryID; 
 
                if (objProducts.Categories.IsValueCreated) 
                    objCategoriesRelatedToCategoryID = objProducts.Categories.Value; 
            } 
        } 
    } 
 
    /// <summary> 
    /// Select all records by Suppliers, related to column SupplierID 
    /// </summary>  
    private void SelectProductsCollectionBySuppliers() 
    { 
        ProductsCollection objProductsCol = Products.SelectProductsCollectionBySuppliers(1); 
 
        // Example 1:  you can optionally sort the collection in ascending order by your chosen field  
        objProductsCol.Sort(Products.ByProductName); 
 
        // Example 2:  to sort in descending order, add this line to the Sort code in Example 1  
        objProductsCol.Reverse(); 
 
        // Example 3:  directly bind to a GridView 
        GridView grid = new GridView(); 
        grid.DataSource = objProductsCol; 
        grid.DataBind(); 
 
        // Example 4:  loop through all the Products(s) 
        foreach (Products objProducts in objProductsCol) 
        { 
            int productID = objProducts.ProductID; 
            string productName = objProducts.ProductName; 
            int? supplierID = objProducts.SupplierID; 
            int? categoryID = objProducts.CategoryID; 
            string quantityPerUnit = objProducts.QuantityPerUnit; 
            decimal? unitPrice = objProducts.UnitPrice; 
            Int16? unitsInStock = objProducts.UnitsInStock; 
            Int16? unitsOnOrder = objProducts.UnitsOnOrder; 
            Int16? reorderLevel = objProducts.ReorderLevel; 
            bool discontinued = objProducts.Discontinued; 
 
            // optionally get the Suppliers related to SupplierID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.SupplierID != null) 
            { 
                Suppliers objSuppliersRelatedToSupplierID; 
 
                if (objProducts.Suppliers.IsValueCreated) 
                    objSuppliersRelatedToSupplierID = objProducts.Suppliers.Value; 
            } 
 
            // optionally get the Categories related to CategoryID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.CategoryID != null) 
            { 
                Categories objCategoriesRelatedToCategoryID; 
 
                if (objProducts.Categories.IsValueCreated) 
                    objCategoriesRelatedToCategoryID = objProducts.Categories.Value; 
            } 
        } 
    } 
 
    /// <summary> 
    /// Select all records by Categories, related to column CategoryID 
    /// </summary>  
    private void SelectProductsCollectionByCategories() 
    { 
        ProductsCollection objProductsCol = Products.SelectProductsCollectionByCategories(1); 
 
        // Example 1:  you can optionally sort the collection in ascending order by your chosen field  
        objProductsCol.Sort(Products.ByProductName); 
 
        // Example 2:  to sort in descending order, add this line to the Sort code in Example 1  
        objProductsCol.Reverse(); 
 
        // Example 3:  directly bind to a GridView 
        GridView grid = new GridView(); 
        grid.DataSource = objProductsCol; 
        grid.DataBind(); 
 
        // Example 4:  loop through all the Products(s) 
        foreach (Products objProducts in objProductsCol) 
        { 
            int productID = objProducts.ProductID; 
            string productName = objProducts.ProductName; 
            int? supplierID = objProducts.SupplierID; 
            int? categoryID = objProducts.CategoryID; 
            string quantityPerUnit = objProducts.QuantityPerUnit; 
            decimal? unitPrice = objProducts.UnitPrice; 
            Int16? unitsInStock = objProducts.UnitsInStock; 
            Int16? unitsOnOrder = objProducts.UnitsOnOrder; 
            Int16? reorderLevel = objProducts.ReorderLevel; 
            bool discontinued = objProducts.Discontinued; 
 
            // optionally get the Suppliers related to SupplierID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.SupplierID != null) 
            { 
                Suppliers objSuppliersRelatedToSupplierID; 
 
                if (objProducts.Suppliers.IsValueCreated) 
                    objSuppliersRelatedToSupplierID = objProducts.Suppliers.Value; 
            } 
 
            // optionally get the Categories related to CategoryID. 
            // Note this is lazily loaded which means there's no value until you ask for it 
            if (objProducts.CategoryID != null) 
            { 
                Categories objCategoriesRelatedToCategoryID; 
 
                if (objProducts.Categories.IsValueCreated) 
                    objCategoriesRelatedToCategoryID = objProducts.Categories.Value; 
            } 
        } 
    } 
 
    /// <summary> 
    /// Selects ProductID and ProductName columns for use with a with a Drop Down List, Combo Box, Checked Box List, List View, List Box, etc 
    /// </summary> 
    private void SelectProductsDropDownListData() 
    { 
        ProductsCollection objProductsCol = Products.SelectProductsDropDownListData(); 
 
        // Example 1:  directly bind to a drop down list 
        DropDownList ddl1 = new DropDownList(); 
        ddl1.DataValueField = "ProductID"; 
        ddl1.DataTextField = "ProductName"; 
        ddl1.DataSource = objProductsCol; 
        ddl1.DataBind(); 
 
        // Example 2:  add each item through a loop 
        DropDownList ddl2 = new DropDownList(); 
 
        foreach (Products objProducts in objProductsCol) 
        { 
            ddl2.Items.Add(new ListItem(objProducts.ProductName, objProducts.ProductID.ToString())); 
        } 
 
        // Example 3:  bind to a combo box.  Note: remove comment when using with windows forms 
        // ComboBox cbx1 = new ComboBox(); 
 
        // foreach (Products objProducts in objProductsCol) 
        // { 
        //     cbx1.Items.Add(new ListItem(objProducts.ProductName, objProducts.ProductID.ToString())); 
        // } 
    } 
 
    private void Insert() 
    { 
        // first instantiate a new Products 
        Products objProducts = new Products(); 
 
        // assign values you want inserted 
        objProducts.ProductName = "Chai"; 
        objProducts.SupplierID = 1; 
        objProducts.CategoryID = 1; 
        objProducts.QuantityPerUnit = "10 boxes x 20 bags"; 
        objProducts.UnitPrice = Convert.ToDecimal(18.0000); 
        objProducts.UnitsInStock = 39; 
        objProducts.UnitsOnOrder = 0; 
        objProducts.ReorderLevel = 10; 
        objProducts.Discontinued = false; 
 
        // finally, insert a new record 
        // the insert method returns the newly created primary key 
        int newlyCreatedPrimaryKey = objProducts.Insert(); 
    } 
 
    private void Update() 
    { 
        // first instantiate a new Products 
        Products objProducts = new Products(); 
 
        // assign the existing primary key(s) 
        // of the record you want updated 
        objProducts.ProductID = 1; 
 
        // assign values you want updated 
        objProducts.ProductName = "Chai"; 
        objProducts.SupplierID = 1; 
        objProducts.CategoryID = 1; 
        objProducts.QuantityPerUnit = "10 boxes x 20 bags"; 
        objProducts.UnitPrice = Convert.ToDecimal(18.0000); 
        objProducts.UnitsInStock = 39; 
        objProducts.UnitsOnOrder = 0; 
        objProducts.ReorderLevel = 10; 
        objProducts.Discontinued = false; 
 
        // finally, update an existing record 
        objProducts.Update(); 
    } 
 
    private void Delete() 
    { 
        // delete a record by primary key 
        Products.Delete(99); 
    } 
} 
