using System; 
using Northwind.BusinessObject; 
using System.Web.UI.WebControls; 
// using System.Windows.Forms;    // Note: remove comment when using with windows forms 
 
/// <summary> 
/// These are data-centric code examples for the Categories table. 
/// You can cut and paste the respective codes into your application 
/// by changing the sample values assigned from these examples. 
/// NOTE: This class contains private methods because they're 
/// not meant to be called by an outside client.  Each method contains 
/// code for the respective example being shown 
/// </summary> 
public sealed class CategoriesExample 
{ 
    private CategoriesExample() 
    { 
    } 
 
    private void SelectAll() 
    { 
        // select all records 
        CategoriesCollection objCategoriesCol = Categories.SelectAll(); 
 
        // Example 1:  you can optionally sort the collection in ascending order by your chosen field  
        objCategoriesCol.Sort(Categories.ByCategoryName); 
 
        // Example 2:  to sort in descending order, add this line to the Sort code in Example 1  
        objCategoriesCol.Reverse(); 
 
        // Example 3:  directly bind to a GridView 
        GridView grid = new GridView(); 
        grid.DataSource = objCategoriesCol; 
        grid.DataBind(); 
 
        // Example 4:  loop through all the Categories(s) 
        foreach (Categories objCategories in objCategoriesCol) 
        { 
            int categoryID = objCategories.CategoryID; 
            string categoryName = objCategories.CategoryName; 
            string description = objCategories.Description; 
        } 
    } 
 
    private void SelectByPrimaryKey() 
    { 
        // select a record by primary key(s) 
        Categories objCategories = Categories.SelectByPrimaryKey(1); 
 
        if (objCategories != null) 
        { 
            // if record is found, a record is returned 
            int categoryID = objCategories.CategoryID; 
            string categoryName = objCategories.CategoryName; 
            string description = objCategories.Description; 
        } 
    } 
 
    /// <summary> 
    /// Selects CategoryID and CategoryName columns for use with a with a Drop Down List, Combo Box, Checked Box List, List View, List Box, etc 
    /// </summary> 
    private void SelectCategoriesDropDownListData() 
    { 
        CategoriesCollection objCategoriesCol = Categories.SelectCategoriesDropDownListData(); 
 
        // Example 1:  directly bind to a drop down list 
        DropDownList ddl1 = new DropDownList(); 
        ddl1.DataValueField = "CategoryID"; 
        ddl1.DataTextField = "CategoryName"; 
        ddl1.DataSource = objCategoriesCol; 
        ddl1.DataBind(); 
 
        // Example 2:  add each item through a loop 
        DropDownList ddl2 = new DropDownList(); 
 
        foreach (Categories objCategories in objCategoriesCol) 
        { 
            ddl2.Items.Add(new ListItem(objCategories.CategoryName, objCategories.CategoryID.ToString())); 
        } 
 
        // Example 3:  bind to a combo box.  Note: remove comment when using with windows forms 
        // ComboBox cbx1 = new ComboBox(); 
 
        // foreach (Categories objCategories in objCategoriesCol) 
        // { 
        //     cbx1.Items.Add(new ListItem(objCategories.CategoryName, objCategories.CategoryID.ToString())); 
        // } 
    } 
 
    private void Insert() 
    { 
        // first instantiate a new Categories 
        Categories objCategories = new Categories(); 
 
        // assign values you want inserted 
        objCategories.CategoryName = "aaaa abcde"; 
        objCategories.Description = "here you go"; 
 
        // finally, insert a new record 
        // the insert method returns the newly created primary key 
        int newlyCreatedPrimaryKey = objCategories.Insert(); 
    } 
 
    private void Update() 
    { 
        // first instantiate a new Categories 
        Categories objCategories = new Categories(); 
 
        // assign the existing primary key(s) 
        // of the record you want updated 
        objCategories.CategoryID = 1; 
 
        // assign values you want updated 
        objCategories.CategoryName = "aaaa abcde"; 
        objCategories.Description = "here you go"; 
 
        // finally, update an existing record 
        objCategories.Update(); 
    } 
 
    private void Delete() 
    { 
        // delete a record by primary key 
        Categories.Delete(153); 
    } 
} 
