using System;
using System.Data;
using System.Data.SqlClient;
using Northwind.BusinessObject;
 
namespace Northwind.DataLayer.Base
{
     /// <summary>
     /// Base class for SuppliersDataLayer.  Do not make changes to this class,
     /// instead, put additional code in the SuppliersDataLayer class 
     /// </summary>
     public class SuppliersDataLayerBase
     {
         // constructor 
         public SuppliersDataLayerBase()
         {
         }

         /// <summary>
         /// Selects a record by primary key(s)
         /// </summary>
         public static Suppliers SelectByPrimaryKey(int supplierID)
         {
              string storedProcName = "[dbo].[Suppliers_SelectByPrimaryKey]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);

              // parameters
              command.Parameters.AddWithValue("@supplierID", supplierID);

              DataSet ds = Dbase.GetDbaseDataSet(command);
              Suppliers objSuppliers = null;

              if (ds.Tables[0].Rows.Count > 0)
              {
                  objSuppliers = new Suppliers();
                  objSuppliers.SupplierID = (int)ds.Tables[0].Rows[0]["SupplierID"];
                  objSuppliers.CompanyName = (string)ds.Tables[0].Rows[0]["CompanyName"];

                  if (ds.Tables[0].Rows[0]["ContactName"] != System.DBNull.Value)
                      objSuppliers.ContactName = (string)ds.Tables[0].Rows[0]["ContactName"];
                  else
                      objSuppliers.ContactName = null;

                  if (ds.Tables[0].Rows[0]["ContactTitle"] != System.DBNull.Value)
                      objSuppliers.ContactTitle = (string)ds.Tables[0].Rows[0]["ContactTitle"];
                  else
                      objSuppliers.ContactTitle = null;

                  if (ds.Tables[0].Rows[0]["Address"] != System.DBNull.Value)
                      objSuppliers.Address = (string)ds.Tables[0].Rows[0]["Address"];
                  else
                      objSuppliers.Address = null;

                  if (ds.Tables[0].Rows[0]["City"] != System.DBNull.Value)
                      objSuppliers.City = (string)ds.Tables[0].Rows[0]["City"];
                  else
                      objSuppliers.City = null;

                  if (ds.Tables[0].Rows[0]["Region"] != System.DBNull.Value)
                      objSuppliers.Region = (string)ds.Tables[0].Rows[0]["Region"];
                  else
                      objSuppliers.Region = null;

                  if (ds.Tables[0].Rows[0]["PostalCode"] != System.DBNull.Value)
                      objSuppliers.PostalCode = (string)ds.Tables[0].Rows[0]["PostalCode"];
                  else
                      objSuppliers.PostalCode = null;

                  if (ds.Tables[0].Rows[0]["Country"] != System.DBNull.Value)
                      objSuppliers.Country = (string)ds.Tables[0].Rows[0]["Country"];
                  else
                      objSuppliers.Country = null;

                  if (ds.Tables[0].Rows[0]["Phone"] != System.DBNull.Value)
                      objSuppliers.Phone = (string)ds.Tables[0].Rows[0]["Phone"];
                  else
                      objSuppliers.Phone = null;

                  if (ds.Tables[0].Rows[0]["Fax"] != System.DBNull.Value)
                      objSuppliers.Fax = (string)ds.Tables[0].Rows[0]["Fax"];
                  else
                      objSuppliers.Fax = null;

                  if (ds.Tables[0].Rows[0]["HomePage"] != System.DBNull.Value)
                      objSuppliers.HomePage = (string)ds.Tables[0].Rows[0]["HomePage"];
                  else
                      objSuppliers.HomePage = null;

              }
              command.Dispose();
              connection.Close();
              connection.Dispose();
              ds.Dispose();

              return objSuppliers;
         }
 
         /// <summary>
         /// Selects all Suppliers 
         /// </summary> 
         public static SuppliersCollection SelectAll() 
         { 
             return SelectShared("[dbo].[Suppliers_SelectAll]", String.Empty, null); 
         } 
 
         /// <summary>
         /// Selects SupplierID and CompanyName columns for use with a DropDownList web control 
         /// </summary> 
         public static SuppliersCollection SelectSuppliersDropDownListData() 
         { 
              string storedProcName = "[dbo].[Suppliers_SelectDropDownListData]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              SuppliersCollection objSuppliersCol = new SuppliersCollection(); 
              Suppliers objSuppliers; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objSuppliers = new Suppliers(); 
                     objSuppliers.SupplierID = (int)dr["SupplierID"]; 
                     objSuppliers.CompanyName = (string)(dr["CompanyName"]); 
 
                     objSuppliersCol.Add(objSuppliers);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objSuppliersCol; 
         } 
 
         public static SuppliersCollection SelectShared(string storedProcName, string param, object paramValue) 
         { 
              SqlConnection connection = Dbase.GetConnection(); 
              SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              SuppliersCollection objSuppliersCol = new SuppliersCollection(); 
              Suppliers objSuppliers; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objSuppliers = new Suppliers(); 
                     objSuppliers.SupplierID = (int)dr["SupplierID"]; 
                     objSuppliers.CompanyName = dr["CompanyName"].ToString(); 
 
                     if (dr["ContactName"] != System.DBNull.Value) 
                         objSuppliers.ContactName = dr["ContactName"].ToString(); 
                     else 
                         objSuppliers.ContactName = null; 
 
                     if (dr["ContactTitle"] != System.DBNull.Value) 
                         objSuppliers.ContactTitle = dr["ContactTitle"].ToString(); 
                     else 
                         objSuppliers.ContactTitle = null; 
 
                     if (dr["Address"] != System.DBNull.Value) 
                         objSuppliers.Address = dr["Address"].ToString(); 
                     else 
                         objSuppliers.Address = null; 
 
                     if (dr["City"] != System.DBNull.Value) 
                         objSuppliers.City = dr["City"].ToString(); 
                     else 
                         objSuppliers.City = null; 
 
                     if (dr["Region"] != System.DBNull.Value) 
                         objSuppliers.Region = dr["Region"].ToString(); 
                     else 
                         objSuppliers.Region = null; 
 
                     if (dr["PostalCode"] != System.DBNull.Value) 
                         objSuppliers.PostalCode = dr["PostalCode"].ToString(); 
                     else 
                         objSuppliers.PostalCode = null; 
 
                     if (dr["Country"] != System.DBNull.Value) 
                         objSuppliers.Country = dr["Country"].ToString(); 
                     else 
                         objSuppliers.Country = null; 
 
                     if (dr["Phone"] != System.DBNull.Value) 
                         objSuppliers.Phone = dr["Phone"].ToString(); 
                     else 
                         objSuppliers.Phone = null; 
 
                     if (dr["Fax"] != System.DBNull.Value) 
                         objSuppliers.Fax = dr["Fax"].ToString(); 
                     else 
                         objSuppliers.Fax = null; 
 
                     if (dr["HomePage"] != System.DBNull.Value) 
                         objSuppliers.HomePage = dr["HomePage"].ToString(); 
                     else 
                         objSuppliers.HomePage = null; 
 
                     objSuppliersCol.Add(objSuppliers);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objSuppliersCol; 
         } 
 
         /// <summary>
         /// Inserts a record 
         /// </summary> 
         public static int Insert(Suppliers objSuppliers) 
         { 
             string storedProcName = "[dbo].[Suppliers_Insert]"; 
             return InsertUpdate(objSuppliers, false, storedProcName); 
         } 
 
         /// <summary>
         /// Updates a record 
         /// </summary>
         public static void Update(Suppliers objSuppliers) 
         { 
             string storedProcName = "[dbo].[Suppliers_Update]"; 
             InsertUpdate(objSuppliers, true, storedProcName); 
         } 
 
         private static int InsertUpdate(Suppliers objSuppliers, bool isUpdate, string storedProcName) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
             object contactName = objSuppliers.ContactName; 
             object contactTitle = objSuppliers.ContactTitle; 
             object address = objSuppliers.Address; 
             object city = objSuppliers.City; 
             object region = objSuppliers.Region; 
             object postalCode = objSuppliers.PostalCode; 
             object country = objSuppliers.Country; 
             object phone = objSuppliers.Phone; 
             object fax = objSuppliers.Fax; 
             object homePage = objSuppliers.HomePage; 
 
             if (String.IsNullOrEmpty(objSuppliers.ContactName)) 
                 contactName = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.ContactTitle)) 
                 contactTitle = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.Address)) 
                 address = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.City)) 
                 city = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.Region)) 
                 region = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.PostalCode)) 
                 postalCode = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.Country)) 
                 country = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.Phone)) 
                 phone = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.Fax)) 
                 fax = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objSuppliers.HomePage)) 
                 homePage = System.DBNull.Value; 
 
             // for update only 
             if (isUpdate) 
             { 
                 command.Parameters.AddWithValue("@supplierID", objSuppliers.SupplierID); 
             } 
 
             command.Parameters.AddWithValue("@companyName", objSuppliers.CompanyName); 
             command.Parameters.AddWithValue("@contactName", contactName); 
             command.Parameters.AddWithValue("@contactTitle", contactTitle); 
             command.Parameters.AddWithValue("@address", address); 
             command.Parameters.AddWithValue("@city", city); 
             command.Parameters.AddWithValue("@region", region); 
             command.Parameters.AddWithValue("@postalCode", postalCode); 
             command.Parameters.AddWithValue("@country", country); 
             command.Parameters.AddWithValue("@phone", phone); 
             command.Parameters.AddWithValue("@fax", fax); 
             command.Parameters.AddWithValue("@homePage", homePage); 
 
             // execute and return value 
             int newlyCreatedSupplierID = objSuppliers.SupplierID; 
 
             if (isUpdate) 
                 command.ExecuteNonQuery(); 
             else 
                 newlyCreatedSupplierID = (int)command.ExecuteScalar(); 
 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
 
             return newlyCreatedSupplierID; 
         } 
 
         /// <summary>
         /// Deletes a record based on primary key(s) 
         /// </summary>
         public static void Delete(int supplierID) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand("[dbo].[Suppliers_Delete]", connection); 
 
             command.Parameters.AddWithValue("@supplierID", supplierID); 
 
             // execute stored proc 
             command.ExecuteNonQuery(); 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
         } 
     }
}
