using System;
using System.Data;
using System.Data.SqlClient;
using Northwind.BusinessObject;
 
namespace Northwind.DataLayer.Base
{
     /// <summary>
     /// Base class for ProductsDataLayer.  Do not make changes to this class,
     /// instead, put additional code in the ProductsDataLayer class 
     /// </summary>
     public class ProductsDataLayerBase
     {
         // constructor 
         public ProductsDataLayerBase()
         {
         }

         /// <summary>
         /// Selects a record by primary key(s)
         /// </summary>
         public static Products SelectByPrimaryKey(int productID)
         {
              string storedProcName = "[dbo].[Products_SelectByPrimaryKey]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);

              // parameters
              command.Parameters.AddWithValue("@productID", productID);

              DataSet ds = Dbase.GetDbaseDataSet(command);
              Products objProducts = null;

              if (ds.Tables[0].Rows.Count > 0)
              {
                  objProducts = new Products();
                  objProducts.ProductID = (int)ds.Tables[0].Rows[0]["ProductID"];
                  objProducts.ProductName = (string)ds.Tables[0].Rows[0]["ProductName"];

                  if (ds.Tables[0].Rows[0]["SupplierID"] != System.DBNull.Value)
                      objProducts.SupplierID = (int)ds.Tables[0].Rows[0]["SupplierID"];
                  else
                      objProducts.SupplierID = null;


                  if (ds.Tables[0].Rows[0]["CategoryID"] != System.DBNull.Value)
                      objProducts.CategoryID = (int)ds.Tables[0].Rows[0]["CategoryID"];
                  else
                      objProducts.CategoryID = null;


                  if (ds.Tables[0].Rows[0]["QuantityPerUnit"] != System.DBNull.Value)
                      objProducts.QuantityPerUnit = (string)ds.Tables[0].Rows[0]["QuantityPerUnit"];
                  else
                      objProducts.QuantityPerUnit = null;

                  if (ds.Tables[0].Rows[0]["UnitPrice"] != System.DBNull.Value)
                      objProducts.UnitPrice = (decimal)ds.Tables[0].Rows[0]["UnitPrice"];
                  else
                      objProducts.UnitPrice = null;

                  if (ds.Tables[0].Rows[0]["UnitsInStock"] != System.DBNull.Value)
                      objProducts.UnitsInStock = (Int16)ds.Tables[0].Rows[0]["UnitsInStock"];
                  else
                      objProducts.UnitsInStock = null;

                  if (ds.Tables[0].Rows[0]["UnitsOnOrder"] != System.DBNull.Value)
                      objProducts.UnitsOnOrder = (Int16)ds.Tables[0].Rows[0]["UnitsOnOrder"];
                  else
                      objProducts.UnitsOnOrder = null;

                  if (ds.Tables[0].Rows[0]["ReorderLevel"] != System.DBNull.Value)
                      objProducts.ReorderLevel = (Int16)ds.Tables[0].Rows[0]["ReorderLevel"];
                  else
                      objProducts.ReorderLevel = null;
                  objProducts.Discontinued = (bool)ds.Tables[0].Rows[0]["Discontinued"];

              }
              command.Dispose();
              connection.Close();
              connection.Dispose();
              ds.Dispose();

              return objProducts;
         }
 
         /// <summary>
         /// Selects all Products 
         /// </summary> 
         public static ProductsCollection SelectAll() 
         { 
             return SelectShared("[dbo].[Products_SelectAll]", String.Empty, null); 
         } 
 
         /// <summary>
         /// Selects all Products by Suppliers, related to column SupplierID 
         /// </summary> 
         public static ProductsCollection SelectProductsCollectionBySuppliers(int supplierID) 
         { 
             return SelectShared("[dbo].[Products_SelectAllBySuppliers]", "supplierID", supplierID); 
         } 
 
         /// <summary>
         /// Selects all Products by Categories, related to column CategoryID 
         /// </summary> 
         public static ProductsCollection SelectProductsCollectionByCategories(int categoryID) 
         { 
             return SelectShared("[dbo].[Products_SelectAllByCategories]", "categoryID", categoryID); 
         } 
 
         /// <summary>
         /// Selects ProductID and ProductName columns for use with a DropDownList web control 
         /// </summary> 
         public static ProductsCollection SelectProductsDropDownListData() 
         { 
              string storedProcName = "[dbo].[Products_SelectDropDownListData]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              ProductsCollection objProductsCol = new ProductsCollection(); 
              Products objProducts; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objProducts = new Products(); 
                     objProducts.ProductID = (int)dr["ProductID"]; 
                     objProducts.ProductName = (string)(dr["ProductName"]); 
 
                     objProductsCol.Add(objProducts);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objProductsCol; 
         } 
 
         public static ProductsCollection SelectShared(string storedProcName, string param, object paramValue) 
         { 
              SqlConnection connection = Dbase.GetConnection(); 
              SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
              // parameters 
              switch (param) 
              { 
                  case "supplierID": 
                      command.Parameters.AddWithValue("@supplierID", paramValue); 
                      break; 
                  case "categoryID": 
                      command.Parameters.AddWithValue("@categoryID", paramValue); 
                      break; 
                  default: 
                      break; 
              } 
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              ProductsCollection objProductsCol = new ProductsCollection(); 
              Products objProducts; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objProducts = new Products(); 
                     objProducts.ProductID = (int)dr["ProductID"]; 
                     objProducts.ProductName = dr["ProductName"].ToString(); 
 
                     if (dr["SupplierID"] != System.DBNull.Value) 
                         objProducts.SupplierID = (int)dr["SupplierID"];
                     else
                         objProducts.SupplierID = null;
 
 
                     if (dr["CategoryID"] != System.DBNull.Value) 
                         objProducts.CategoryID = (int)dr["CategoryID"];
                     else
                         objProducts.CategoryID = null;
 
 
                     if (dr["QuantityPerUnit"] != System.DBNull.Value) 
                         objProducts.QuantityPerUnit = dr["QuantityPerUnit"].ToString(); 
                     else 
                         objProducts.QuantityPerUnit = null; 
 
                     if (dr["UnitPrice"] != System.DBNull.Value) 
                         objProducts.UnitPrice = (decimal)dr["UnitPrice"]; 
                     else 
                         objProducts.UnitPrice = null; 
 
                     if (dr["UnitsInStock"] != System.DBNull.Value) 
                         objProducts.UnitsInStock = (Int16)dr["UnitsInStock"]; 
                     else 
                         objProducts.UnitsInStock = null; 
 
                     if (dr["UnitsOnOrder"] != System.DBNull.Value) 
                         objProducts.UnitsOnOrder = (Int16)dr["UnitsOnOrder"]; 
                     else 
                         objProducts.UnitsOnOrder = null; 
 
                     if (dr["ReorderLevel"] != System.DBNull.Value) 
                         objProducts.ReorderLevel = (Int16)dr["ReorderLevel"]; 
                     else 
                         objProducts.ReorderLevel = null; 
                     objProducts.Discontinued = (bool)dr["Discontinued"]; 
 
                     objProductsCol.Add(objProducts);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objProductsCol; 
         } 
 
         /// <summary>
         /// Inserts a record 
         /// </summary> 
         public static int Insert(Products objProducts) 
         { 
             string storedProcName = "[dbo].[Products_Insert]"; 
             return InsertUpdate(objProducts, false, storedProcName); 
         } 
 
         /// <summary>
         /// Updates a record 
         /// </summary>
         public static void Update(Products objProducts) 
         { 
             string storedProcName = "[dbo].[Products_Update]"; 
             InsertUpdate(objProducts, true, storedProcName); 
         } 
 
         private static int InsertUpdate(Products objProducts, bool isUpdate, string storedProcName) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
             object supplierID = objProducts.SupplierID; 
             object categoryID = objProducts.CategoryID; 
             object quantityPerUnit = objProducts.QuantityPerUnit; 
             object unitPrice = objProducts.UnitPrice; 
             object unitsInStock = objProducts.UnitsInStock; 
             object unitsOnOrder = objProducts.UnitsOnOrder; 
             object reorderLevel = objProducts.ReorderLevel; 
 
             if (objProducts.SupplierID == null) 
                 supplierID = System.DBNull.Value; 
 
             if (objProducts.CategoryID == null) 
                 categoryID = System.DBNull.Value; 
 
             if (String.IsNullOrEmpty(objProducts.QuantityPerUnit)) 
                 quantityPerUnit = System.DBNull.Value; 
 
             if (objProducts.UnitPrice == null) 
                 unitPrice = System.DBNull.Value; 
 
             if (objProducts.UnitsInStock == null) 
                 unitsInStock = System.DBNull.Value; 
 
             if (objProducts.UnitsOnOrder == null) 
                 unitsOnOrder = System.DBNull.Value; 
 
             if (objProducts.ReorderLevel == null) 
                 reorderLevel = System.DBNull.Value; 
 
             // for update only 
             if (isUpdate) 
             { 
                 command.Parameters.AddWithValue("@productID", objProducts.ProductID); 
             } 
 
             command.Parameters.AddWithValue("@productName", objProducts.ProductName); 
             command.Parameters.AddWithValue("@supplierID", supplierID); 
             command.Parameters.AddWithValue("@categoryID", categoryID); 
             command.Parameters.AddWithValue("@quantityPerUnit", quantityPerUnit); 
             command.Parameters.AddWithValue("@unitPrice", unitPrice); 
             command.Parameters.AddWithValue("@unitsInStock", unitsInStock); 
             command.Parameters.AddWithValue("@unitsOnOrder", unitsOnOrder); 
             command.Parameters.AddWithValue("@reorderLevel", reorderLevel); 
             command.Parameters.AddWithValue("@discontinued", objProducts.Discontinued); 
 
             // execute and return value 
             int newlyCreatedProductID = objProducts.ProductID; 
 
             if (isUpdate) 
                 command.ExecuteNonQuery(); 
             else 
                 newlyCreatedProductID = (int)command.ExecuteScalar(); 
 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
 
             return newlyCreatedProductID; 
         } 
 
         /// <summary>
         /// Deletes a record based on primary key(s) 
         /// </summary>
         public static void Delete(int productID) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand("[dbo].[Products_Delete]", connection); 
 
             command.Parameters.AddWithValue("@productID", productID); 
 
             // execute stored proc 
             command.ExecuteNonQuery(); 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
         } 
     }
}
