using System;
using System.Data;
using System.Data.SqlClient;
using Northwind.BusinessObject;
 
namespace Northwind.DataLayer.Base
{
     /// <summary>
     /// Base class for CategoriesDataLayer.  Do not make changes to this class,
     /// instead, put additional code in the CategoriesDataLayer class 
     /// </summary>
     public class CategoriesDataLayerBase
     {
         // constructor 
         public CategoriesDataLayerBase()
         {
         }

         /// <summary>
         /// Selects a record by primary key(s)
         /// </summary>
         public static Categories SelectByPrimaryKey(int categoryID)
         {
              string storedProcName = "[dbo].[Categories_SelectByPrimaryKey]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);

              // parameters
              command.Parameters.AddWithValue("@categoryID", categoryID);

              DataSet ds = Dbase.GetDbaseDataSet(command);
              Categories objCategories = null;

              if (ds.Tables[0].Rows.Count > 0)
              {
                  objCategories = new Categories();
                  objCategories.CategoryID = (int)ds.Tables[0].Rows[0]["CategoryID"];
                  objCategories.CategoryName = (string)ds.Tables[0].Rows[0]["CategoryName"];

                  if (ds.Tables[0].Rows[0]["Description"] != System.DBNull.Value)
                      objCategories.Description = (string)ds.Tables[0].Rows[0]["Description"];
                  else
                      objCategories.Description = null;

              }
              command.Dispose();
              connection.Close();
              connection.Dispose();
              ds.Dispose();

              return objCategories;
         }
 
         /// <summary>
         /// Selects all Categories 
         /// </summary> 
         public static CategoriesCollection SelectAll() 
         { 
             return SelectShared("[dbo].[Categories_SelectAll]", String.Empty, null); 
         } 
 
         /// <summary>
         /// Selects CategoryID and CategoryName columns for use with a DropDownList web control 
         /// </summary> 
         public static CategoriesCollection SelectCategoriesDropDownListData() 
         { 
              string storedProcName = "[dbo].[Categories_SelectDropDownListData]";
              SqlConnection connection = Dbase.GetConnection();
              SqlCommand command = Dbase.GetCommand(storedProcName, connection);
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              CategoriesCollection objCategoriesCol = new CategoriesCollection(); 
              Categories objCategories; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objCategories = new Categories(); 
                     objCategories.CategoryID = (int)dr["CategoryID"]; 
                     objCategories.CategoryName = (string)(dr["CategoryName"]); 
 
                     objCategoriesCol.Add(objCategories);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objCategoriesCol; 
         } 
 
         public static CategoriesCollection SelectShared(string storedProcName, string param, object paramValue) 
         { 
              SqlConnection connection = Dbase.GetConnection(); 
              SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
              DataSet ds = Dbase.GetDbaseDataSet(command); 
              CategoriesCollection objCategoriesCol = new CategoriesCollection(); 
              Categories objCategories; 
 
              if (ds.Tables[0].Rows.Count > 0) 
              { 
                 foreach(DataRow dr in ds.Tables[0].Rows) 
                 { 
                     objCategories = new Categories(); 
                     objCategories.CategoryID = (int)dr["CategoryID"]; 
                     objCategories.CategoryName = dr["CategoryName"].ToString(); 
 
                     if (dr["Description"] != System.DBNull.Value) 
                         objCategories.Description = dr["Description"].ToString(); 
                     else 
                         objCategories.Description = null; 
 
                     objCategoriesCol.Add(objCategories);
                 } 
              } 
 
              command.Dispose(); 
              connection.Close(); 
              connection.Dispose(); 
              ds.Dispose(); 
 
              return objCategoriesCol; 
         } 
 
         /// <summary>
         /// Inserts a record 
         /// </summary> 
         public static int Insert(Categories objCategories) 
         { 
             string storedProcName = "[dbo].[Categories_Insert]"; 
             return InsertUpdate(objCategories, false, storedProcName); 
         } 
 
         /// <summary>
         /// Updates a record 
         /// </summary>
         public static void Update(Categories objCategories) 
         { 
             string storedProcName = "[dbo].[Categories_Update]"; 
             InsertUpdate(objCategories, true, storedProcName); 
         } 
 
         private static int InsertUpdate(Categories objCategories, bool isUpdate, string storedProcName) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand(storedProcName, connection); 
 
             object description = objCategories.Description; 
 
             if (String.IsNullOrEmpty(objCategories.Description)) 
                 description = System.DBNull.Value; 
 
             // for update only 
             if (isUpdate) 
             { 
                 command.Parameters.AddWithValue("@categoryID", objCategories.CategoryID); 
             } 
 
             command.Parameters.AddWithValue("@categoryName", objCategories.CategoryName); 
             command.Parameters.AddWithValue("@description", description); 
 
             // execute and return value 
             int newlyCreatedCategoryID = objCategories.CategoryID; 
 
             if (isUpdate) 
                 command.ExecuteNonQuery(); 
             else 
                 newlyCreatedCategoryID = (int)command.ExecuteScalar(); 
 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
 
             return newlyCreatedCategoryID; 
         } 
 
         /// <summary>
         /// Deletes a record based on primary key(s) 
         /// </summary>
         public static void Delete(int categoryID) 
         { 
             SqlConnection connection = Dbase.GetConnection(); 
             SqlCommand command = Dbase.GetCommand("[dbo].[Categories_Delete]", connection); 
 
             command.Parameters.AddWithValue("@categoryID", categoryID); 
 
             // execute stored proc 
             command.ExecuteNonQuery(); 
             command.Dispose(); 
             connection.Close(); 
             connection.Dispose(); 
         } 
     }
}
