using System; 
using System.Data; 
using Northwind.DataLayer; 
using Northwind.BusinessObject; 
using System.Web.Script.Serialization; 
 
namespace Northwind.BusinessObject.Base 
{ 
     /// <summary>
     /// Base class for Suppliers.  Do not make changes to this class,
     /// instead, put additional code in the Suppliers class 
     /// </summary>
     public class SuppliersBase
     { 
         /// <summary> 
         /// Gets or Sets SupplierID 
         /// </summary> 
         public int SupplierID { get; set; } 
 
         /// <summary> 
         /// Gets or Sets CompanyName 
         /// </summary> 
         public string CompanyName { get; set; } 
 
         /// <summary> 
         /// Gets or Sets ContactName 
         /// </summary> 
         public string ContactName { get; set; } 
 
         /// <summary> 
         /// Gets or Sets ContactTitle 
         /// </summary> 
         public string ContactTitle { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Address 
         /// </summary> 
         public string Address { get; set; } 
 
         /// <summary> 
         /// Gets or Sets City 
         /// </summary> 
         public string City { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Region 
         /// </summary> 
         public string Region { get; set; } 
 
         /// <summary> 
         /// Gets or Sets PostalCode 
         /// </summary> 
         public string PostalCode { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Country 
         /// </summary> 
         public string Country { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Phone 
         /// </summary> 
         public string Phone { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Fax 
         /// </summary> 
         public string Fax { get; set; } 
 
         /// <summary> 
         /// Gets or Sets HomePage 
         /// </summary> 
         public string HomePage { get; set; } 
 
         /// <summary> 
         /// Gets or sets the related Products(s) by SupplierID 
         /// </summary> 
         [ScriptIgnore] 
         public Lazy<ProductsCollection> ProductsCollection 
         { 
             get 
             { 
                 int value; 
                 bool hasValue = Int32.TryParse(SupplierID.ToString(), out value); 
 
                 if (hasValue) 
                     return new Lazy<ProductsCollection>(() => Northwind.BusinessObject.Products.SelectProductsCollectionBySuppliers(value)); 
                 else 
                     return null; 
             } 
             set { } 
         } 
 
 
         /// <summary> 
         /// Constructor 
         /// </summary> 
         public SuppliersBase() 
         { 
         } 
 
         /// <summary>
         /// Selects a record by primary key(s) 
         /// </summary>
         public static Suppliers SelectByPrimaryKey(int supplierID) 
         { 
             return SuppliersDataLayer.SelectByPrimaryKey(supplierID); 
         } 
 
         /// <summary> 
         /// Selects all records as a collection (List) of Suppliers 
         /// </summary> 
         public static SuppliersCollection SelectAll() 
         { 
             return SuppliersDataLayer.SelectAll(); 
         } 
 
         /// <summary> 
         /// Selects all records as a collection (List) of Suppliers sorted by the sort expression 
         /// </summary> 
         public static SuppliersCollection SelectAll(string sortExpression) 
         { 
             SuppliersCollection objSuppliersCol = SuppliersDataLayer.SelectAll();
             return SortByExpression(objSuppliersCol, sortExpression);
         } 
 
         /// <summary>
         /// Selects SupplierID and CompanyName columns for use with a DropDownList web control, ComboBox, CheckedBoxList, ListView, ListBox, etc 
         /// </summary> 
         public static SuppliersCollection SelectSuppliersDropDownListData() 
         { 
             return SuppliersDataLayer.SelectSuppliersDropDownListData(); 
         } 
 
         /// <summary>
         /// Sorts the SuppliersCollection by sort expression 
         /// </summary> 
         public static SuppliersCollection SortByExpression(SuppliersCollection objSuppliersCol, string sortExpression) 
         { 
             bool isSortDescending = sortExpression.Contains(" DESC");

             if (isSortDescending)
                 sortExpression = sortExpression.Replace(" DESC", "");

             switch (sortExpression)
             {
                 case "SupplierID":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.BySupplierID);
                     break;
                 case "CompanyName":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCompanyName);
                     break;
                 case "ContactName":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByContactName);
                     break;
                 case "ContactTitle":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByContactTitle);
                     break;
                 case "Address":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByAddress);
                     break;
                 case "City":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCity);
                     break;
                 case "Region":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByRegion);
                     break;
                 case "PostalCode":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByPostalCode);
                     break;
                 case "Country":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByCountry);
                     break;
                 case "Phone":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByPhone);
                     break;
                 case "Fax":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByFax);
                     break;
                 case "HomePage":
                     objSuppliersCol.Sort(Northwind.BusinessObject.Suppliers.ByHomePage);
                     break;
                 default:
                     break;
             }

             if (isSortDescending) 
                 objSuppliersCol.Reverse();

             return objSuppliersCol;
         } 
 
         /// <summary>
         /// Inserts a record 
         /// </summary> 
         public int Insert() 
         { 
             Suppliers objSuppliers = (Suppliers)this; 
             return SuppliersDataLayer.Insert(objSuppliers); 
         } 
 
         /// <summary>
         /// Updates a record 
         /// </summary> 
         public void Update() 
         { 
             Suppliers objSuppliers = (Suppliers)this; 
             SuppliersDataLayer.Update(objSuppliers); 
         } 
 
         /// <summary>
         /// Deletes a record based on primary key(s) 
         /// </summary>
         public static void Delete(int supplierID) 
         { 
             SuppliersDataLayer.Delete(supplierID); 
         } 
 
         /// <summary> 
         /// Compares SupplierID used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> BySupplierID = delegate(Suppliers x, Suppliers y) 
         { 
             return x.SupplierID.CompareTo(y.SupplierID); 
         }; 
 
         /// <summary> 
         /// Compares CompanyName used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByCompanyName = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.CompanyName ?? String.Empty; 
             string value2 = y.CompanyName ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares ContactName used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByContactName = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.ContactName ?? String.Empty; 
             string value2 = y.ContactName ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares ContactTitle used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByContactTitle = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.ContactTitle ?? String.Empty; 
             string value2 = y.ContactTitle ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Address used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByAddress = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.Address ?? String.Empty; 
             string value2 = y.Address ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares City used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByCity = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.City ?? String.Empty; 
             string value2 = y.City ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Region used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByRegion = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.Region ?? String.Empty; 
             string value2 = y.Region ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares PostalCode used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByPostalCode = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.PostalCode ?? String.Empty; 
             string value2 = y.PostalCode ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Country used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByCountry = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.Country ?? String.Empty; 
             string value2 = y.Country ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Phone used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByPhone = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.Phone ?? String.Empty; 
             string value2 = y.Phone ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Fax used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByFax = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.Fax ?? String.Empty; 
             string value2 = y.Fax ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares HomePage used for sorting 
         /// </summary> 
         public static Comparison<Suppliers> ByHomePage = delegate(Suppliers x, Suppliers y) 
         { 
             string value1 = x.HomePage ?? String.Empty; 
             string value2 = y.HomePage ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
     } 
} 
