using System; 
using System.Data; 
using Northwind.DataLayer; 
using Northwind.BusinessObject; 
using System.Web.Script.Serialization; 
 
namespace Northwind.BusinessObject.Base 
{ 
     /// <summary>
     /// Base class for Categories.  Do not make changes to this class,
     /// instead, put additional code in the Categories class 
     /// </summary>
     public class CategoriesBase
     { 
         /// <summary> 
         /// Gets or Sets CategoryID 
         /// </summary> 
         public int CategoryID { get; set; } 
 
         /// <summary> 
         /// Gets or Sets CategoryName 
         /// </summary> 
         public string CategoryName { get; set; } 
 
         /// <summary> 
         /// Gets or Sets Description 
         /// </summary> 
         public string Description { get; set; } 
 
         /// <summary> 
         /// Gets or sets the related Products(s) by CategoryID 
         /// </summary> 
         [ScriptIgnore] 
         public Lazy<ProductsCollection> ProductsCollection 
         { 
             get 
             { 
                 int value; 
                 bool hasValue = Int32.TryParse(CategoryID.ToString(), out value); 
 
                 if (hasValue) 
                     return new Lazy<ProductsCollection>(() => Northwind.BusinessObject.Products.SelectProductsCollectionByCategories(value)); 
                 else 
                     return null; 
             } 
             set { } 
         } 
 
 
         /// <summary> 
         /// Constructor 
         /// </summary> 
         public CategoriesBase() 
         { 
         } 
 
         /// <summary>
         /// Selects a record by primary key(s) 
         /// </summary>
         public static Categories SelectByPrimaryKey(int categoryID) 
         { 
             return CategoriesDataLayer.SelectByPrimaryKey(categoryID); 
         } 
 
         /// <summary> 
         /// Selects all records as a collection (List) of Categories 
         /// </summary> 
         public static CategoriesCollection SelectAll() 
         { 
             return CategoriesDataLayer.SelectAll(); 
         } 
 
         /// <summary> 
         /// Selects all records as a collection (List) of Categories sorted by the sort expression 
         /// </summary> 
         public static CategoriesCollection SelectAll(string sortExpression) 
         { 
             CategoriesCollection objCategoriesCol = CategoriesDataLayer.SelectAll();
             return SortByExpression(objCategoriesCol, sortExpression);
         } 
 
         /// <summary>
         /// Selects CategoryID and CategoryName columns for use with a DropDownList web control, ComboBox, CheckedBoxList, ListView, ListBox, etc 
         /// </summary> 
         public static CategoriesCollection SelectCategoriesDropDownListData() 
         { 
             return CategoriesDataLayer.SelectCategoriesDropDownListData(); 
         } 
 
         /// <summary>
         /// Sorts the CategoriesCollection by sort expression 
         /// </summary> 
         public static CategoriesCollection SortByExpression(CategoriesCollection objCategoriesCol, string sortExpression) 
         { 
             bool isSortDescending = sortExpression.Contains(" DESC");

             if (isSortDescending)
                 sortExpression = sortExpression.Replace(" DESC", "");

             switch (sortExpression)
             {
                 case "CategoryID":
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByCategoryID);
                     break;
                 case "CategoryName":
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByCategoryName);
                     break;
                 case "Description":
                     objCategoriesCol.Sort(Northwind.BusinessObject.Categories.ByDescription);
                     break;
                 default:
                     break;
             }

             if (isSortDescending) 
                 objCategoriesCol.Reverse();

             return objCategoriesCol;
         } 
 
         /// <summary>
         /// Inserts a record 
         /// </summary> 
         public int Insert() 
         { 
             Categories objCategories = (Categories)this; 
             return CategoriesDataLayer.Insert(objCategories); 
         } 
 
         /// <summary>
         /// Updates a record 
         /// </summary> 
         public void Update() 
         { 
             Categories objCategories = (Categories)this; 
             CategoriesDataLayer.Update(objCategories); 
         } 
 
         /// <summary>
         /// Deletes a record based on primary key(s) 
         /// </summary>
         public static void Delete(int categoryID) 
         { 
             CategoriesDataLayer.Delete(categoryID); 
         } 
 
         /// <summary> 
         /// Compares CategoryID used for sorting 
         /// </summary> 
         public static Comparison<Categories> ByCategoryID = delegate(Categories x, Categories y) 
         { 
             return x.CategoryID.CompareTo(y.CategoryID); 
         }; 
 
         /// <summary> 
         /// Compares CategoryName used for sorting 
         /// </summary> 
         public static Comparison<Categories> ByCategoryName = delegate(Categories x, Categories y) 
         { 
             string value1 = x.CategoryName ?? String.Empty; 
             string value2 = y.CategoryName ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
         /// <summary> 
         /// Compares Description used for sorting 
         /// </summary> 
         public static Comparison<Categories> ByDescription = delegate(Categories x, Categories y) 
         { 
             string value1 = x.Description ?? String.Empty; 
             string value2 = y.Description ?? String.Empty; 
             return value1.CompareTo(value2); 
         }; 
 
     } 
} 
