﻿Imports System
Imports System.Web
Imports System.Web.UI

<Assembly: WebResource("JavaScriptLibrary.ShowMessage.js", "application/x-javascript")> 
<Assembly: WebResource("JavaScriptLibrary.GreetUser.js", "application/x-javascript")> 
<Assembly: WebResource("JavaScriptLibrary.DummyFile.js", "application/x-javascript")> 

''' <summary>
''' Helps include JavaScript files in pages.
''' </summary>
Public Class JavaScriptHelper

#Region "Constants"

    Private Const TEMPLATE_SCRIPT As String = "<script type=""text/javascript"" src=""{0}""></script>\r\n"
    Private Const NAME_SHOW_MESSAGE As String = "JavaScriptLibrary.ShowMessage.js"
    Private Const NAME_GREET_USER As String = "JavaScriptLibrary.GreetUser.js"
    Private Const NAME_DUMMY_FILE As String = "JavaScriptLibrary.DummyFile.js"
    Private Const NAME_JQUERY As String = "jQuery"
    Private Const URL_JQUERY As String = "http://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.5.1.js"
    Private Const URL_JQUERY_HTTPS As String = "https://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.5.1.js"

#End Region

#Region "Public Methods"

    ''' <summary>
    ''' Includes ShowMessage.js in the page.
    ''' </summary>
    ''' <param name="manager">Accessible via Page.ClientScript.</param>
    ''' <param name="late">Include the JavaScript at the bottom of the HTML?</param>
    Public Shared Sub Include_ShowMessage(ByVal manager As ClientScriptManager, Optional ByVal late As Boolean = False)
        IncludeJavaScript(manager, NAME_SHOW_MESSAGE, late)
    End Sub

    ''' <summary>
    ''' Includes GreetUser.js (and all dependencies) in the page.
    ''' </summary>
    ''' <param name="manager">Accessible via Page.ClientScript.</param>
    ''' <param name="late">Include the JavaScript at the bottom of the HTML?</param>
    Public Shared Sub Include_GreetUser(ByVal manager As ClientScriptManager, Optional ByVal late As Boolean = False)

        ' Dependency (ShowMessage.js).
        Include_ShowMessage(manager, late)

        ' Include GreetUser.js.
        IncludeJavaScript(manager, NAME_GREET_USER, late)

    End Sub

    ''' <summary>
    ''' Includes jQuery.js in the page.
    ''' </summary>
    ''' <param name="page">The current page. Pass in null to get the current page from the HTTP context.</param>
    ''' <param name="late">Include the JavaScript at the bottom of the HTML?</param>
    Public Shared Sub Include_jQuery(ByVal page As Page, Optional ByVal late As Boolean = False)
        If page Is Nothing Then
            page = DirectCast(HttpContext.Current.Handler, Page)
        End If
        IncludeExternalJavaScript(page, NAME_JQUERY, URL_JQUERY, URL_JQUERY_HTTPS, late)
    End Sub

    ''' <summary>
    ''' Excludes jQuery.js from the page.
    ''' </summary>
    ''' <param name="manager">Accessible via Page.ClientScript.</param>
    Public Shared Sub Exclude_jQuery(ByVal manager As ClientScriptManager)
        ExcludeJavaScript(manager, NAME_JQUERY)
    End Sub

#End Region

#Region "Private Methods"

    ''' <summary>
    ''' Includes the specified embedded JavaScript file in the page.
    ''' </summary>
    ''' <param name="manager">Accessible via Page.ClientScript.</param>
    ''' <param name="resourceName">The name used to identify the embedded JavaScript file.</param>
    ''' <param name="late">Include the JavaScript at the bottom of the HTML?</param>
    Private Shared Sub IncludeJavaScript(ByVal manager As ClientScriptManager, ByVal resourceName As String, ByVal late As Boolean)
        Dim type = GetType(JavaScriptLibrary.JavaScriptHelper)
        If Not manager.IsStartupScriptRegistered(type, resourceName) Then
            If late Then
                Dim url As String = manager.GetWebResourceUrl(type, resourceName)
                Dim scriptBlock As String = String.Format(TEMPLATE_SCRIPT, HttpUtility.HtmlEncode(url))
                manager.RegisterStartupScript(type, resourceName, scriptBlock)
            Else
                manager.RegisterClientScriptResource(type, resourceName)
                manager.RegisterStartupScript(type, resourceName, String.Empty)
            End If
        End If
    End Sub

    ''' <summary>
    ''' Includes the specified external JavaScript file in the page.
    ''' </summary>
    ''' <param name="page">The current page.</param>
    ''' <param name="key">The name used to uniquely identify the external JavaScript file.</param>
    ''' <param name="httpUrl">The URL of the external JavaScript file.</param>
    ''' <param name="httpsUrl">The URL of the external JavaScript file when SSL is enabled.</param>
    ''' <param name="late">Include the JavaScript at the bottom of the HTML?</param>
    Private Shared Sub IncludeExternalJavaScript(ByVal page As Page, ByVal key As String, ByVal httpUrl As String, ByVal httpsUrl As String, ByVal late As Boolean)
        Dim manager = page.ClientScript
        Dim type = GetType(JavaScriptLibrary.JavaScriptHelper)
        Dim isStartupRegistered As Boolean = manager.IsStartupScriptRegistered(type, key)
        Dim isScriptRegistered As Boolean = manager.IsClientScriptIncludeRegistered(type, key)
        If Not (isStartupRegistered OrElse isScriptRegistered) Then
            Dim url As String
            If page.Request.Url.Scheme.ToLower() = "http" Then
                url = httpUrl
            Else
                url = httpsUrl
            End If
            If (late) Then
                manager.RegisterStartupScript(type, key, String.Format(TEMPLATE_SCRIPT, HttpUtility.HtmlEncode(url)))
            Else
                manager.RegisterClientScriptInclude(type, key, url)
            End If
        End If
    End Sub

    ''' <summary>
    ''' Registers a dummy script to prevent the inclusion of the real JavaScript.
    ''' </summary>
    ''' <param name="manager">Accessible via Page.ClientScript.</param>
    ''' <param name="key">The name used to uniquely identify the JavaScript file.</param>
    Private Shared Sub ExcludeJavaScript(ByVal manager As ClientScriptManager, ByVal key As String)
        Dim type = GetType(JavaScriptLibrary.JavaScriptHelper)
        Dim url As String = manager.GetWebResourceUrl(type, NAME_DUMMY_FILE)
        manager.RegisterStartupScript(type, key, String.Empty)
        manager.RegisterClientScriptInclude(type, key, url)
    End Sub

#End Region

End Class
