﻿Imports Microsoft.VisualBasic

Imports System.IO
Imports System.Text
Imports System.Text.RegularExpressions

Public Class TOCFilter
    Inherits MemoryStream

#Region " HeaderClass "

    Private Class HeaderClass
        Private pRank As String
        Private pTag As XElement

        Public ReadOnly Property Id() As String
            Get
                If pTag Is Nothing Then Throw New Exception("Member 'Tag' was not instantiated.")

                If pTag.Attribute("id") IsNot Nothing Then
                    Return pTag.Attribute("id").Value
                Else
                    Return pTag.Value
                End If
            End Get
        End Property

        Public ReadOnly Property Length() As Integer
            Get
                Return pTag.ToString.Length
            End Get
        End Property

        Public ReadOnly Property Rank() As String
            Get
                Return pRank
            End Get
        End Property

        Public ReadOnly Property Tag() As XElement
            Get
                Return pTag
            End Get
        End Property

        Public ReadOnly Property TagReplacement() As String
            Get
                If pTag Is Nothing Then Throw New Exception("Member 'Tag' was not instantiated.")

                Dim NewTag As New XElement(pTag) 'Create a copy of pTag
                NewTag.SetAttributeValue("id", "{0}_" + Me.Id.Replace(" ", "_")) 'Force it to have an id prepended by a replacement token
                Return NewTag.ToString 'Return it
            End Get
        End Property

        Public ReadOnly Property Text() As String
            Get
                If pTag Is Nothing Then Throw New Exception("Member 'Tag' was not instantiated.")

                Return pTag.Value
            End Get
        End Property

        Public Sub New(ByVal Rank As String, ByVal Tag As String)
            pRank = Rank
            Try
                pTag = XElement.Parse(Tag)
            Catch ex As Exception
                Throw New ArgumentException("Not a valid element.", "Tag", ex)
            End Try
        End Sub

    End Class

#End Region

#Region " Storage "

    Private Output As Stream
    Private HTML As StringBuilder
    Private EOP As Regex

#End Region

#Region " Constructors "

    Public Sub New(ByVal LinkedStream As System.IO.Stream)
        Output = LinkedStream
        HTML = New StringBuilder
        EOP = New Regex("</html>", RegexOptions.IgnoreCase)
    End Sub

#End Region

#Region " Methods "

    Private Function StringContains(ByVal ThisString As String, ByVal SearchText As String) As Boolean
        Dim i As Integer = ThisString.IndexOf(SearchText, StringComparison.CurrentCultureIgnoreCase)
        Return (i <> 0)
    End Function

    Private Function StringReplace(ByVal ThisString As String, ByVal Pattern As String, ByVal ReplacementText As String) As String
        Return Regex.Replace(ThisString, Pattern, ReplacementText, RegexOptions.IgnoreCase)
    End Function

#End Region

#Region " Overrides "

    Public Overrides Sub Write(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer)
        'Use the encoding scheme of your web pages. UTF-8 is most common nowadays
        Dim BufferStr As String = UTF8Encoding.UTF8.GetString(buffer)

        HTML.Append(BufferStr)
        If EOP.IsMatch(BufferStr) Then
            Dim PageContent As String = HTML.ToString
            If StringContains(PageContent, "{{toc}}") Then
                Dim Headers As New SortedList(Of Integer, HeaderClass)
                Dim Tag As String = ""
                Dim i As Integer = 0
                Dim j As Integer = 0

                i = PageContent.IndexOf("<h3", StringComparison.CurrentCultureIgnoreCase)
                Do While i > 0 'As long as there are still more 
                    j = PageContent.IndexOf("</h3>", i + 1, StringComparison.CurrentCultureIgnoreCase)
                    Tag = PageContent.Substring(i, j - i + 6)
                    Headers.Add(i, New HeaderClass("H3", Tag))
                    i = PageContent.IndexOf("<h3", j, StringComparison.CurrentCultureIgnoreCase)
                Loop

                i = PageContent.IndexOf("<h4", StringComparison.CurrentCultureIgnoreCase)
                Do While i > 0
                    j = PageContent.IndexOf("</h4>", i + 1, StringComparison.CurrentCultureIgnoreCase)
                    Tag = PageContent.Substring(i, j - i + 6)
                    Headers.Add(i, New HeaderClass("H4", Tag))
                    i = PageContent.IndexOf("<h4", j, StringComparison.CurrentCultureIgnoreCase)
                Loop

                i = PageContent.IndexOf("<h5", StringComparison.CurrentCultureIgnoreCase)
                Do While i > 0
                    j = PageContent.IndexOf("</h5>", i + 1, StringComparison.CurrentCultureIgnoreCase)
                    Tag = PageContent.Substring(i, j - i + 6)
                    Headers.Add(i, New HeaderClass("H5", Tag))
                    i = PageContent.IndexOf("<h5", j, StringComparison.CurrentCultureIgnoreCase)
                Loop

                If Headers.Count > 0 Then
                    Dim TocStr As New StringBuilder
                    Dim H3 As Integer = 0
                    Dim H4 As Integer = 0
                    Dim H5 As Integer = 0
                    Dim Index As String = ""
                    Dim NewBufferStr As StringBuilder = Nothing
                    Dim shift As Integer = 0
                    Dim fudge As Integer = 0

                    TocStr.AppendLine("<table id=""TOC"">")
                    TocStr.AppendLine(" <tr><th id=""TOC_Header"">Contents [<span id=""TOC_Toggle"" onclick=""ShowHideToc();"">Hide</span>]</th></tr>")
                    TocStr.AppendLine(" <tr style=""display:block;"" id=""TOC_Content"">")
                    TocStr.AppendLine("  <td><table>")

                    For Each kvp As KeyValuePair(Of Integer, HeaderClass) In Headers
                        Select Case kvp.Value.Rank
                            Case "H3"
                                H3 += 1
                                H4 = 0
                                H5 = 0
                                Index = String.Format("{0}.", H3)
                                fudge = 3 - Index.Length

                            Case "H4"
                                H4 += 1
                                H5 = 0
                                Index = String.Format("{0}.{1}.", H3, H4)
                                fudge = 3 - Index.Length

                            Case "H5"
                                H5 += 1
                                Index = String.Format("{0}.{1}.{2}.", H3, H4, H5)
                                fudge = 3 - Index.Length
                        End Select

                        NewBufferStr = New StringBuilder
                        NewBufferStr.Append(PageContent.Substring(0, shift + kvp.Key))
                        NewBufferStr.AppendFormat(kvp.Value.TagReplacement, Index.Replace(".", "_"))
                        NewBufferStr.Append(PageContent.Substring(shift + kvp.Key + kvp.Value.Length))

                        shift += (kvp.Value.TagReplacement.Length - fudge - kvp.Value.Tag.ToString.Length)

                        TocStr.AppendFormat("<tr><td class=""TOC_level_{0}"">", kvp.Value.Rank)
                        TocStr.AppendFormat("<a href=""#{0}_{1}"">{2}&nbsp;&nbsp;{3}</a>", _
                                            Index.Replace(".", "_"), kvp.Value.Id.Replace(" ", "_"), Index, kvp.Value.Text)
                        TocStr.AppendLine("</td></tr>")

                        PageContent = NewBufferStr.ToString
                    Next

                    TocStr.AppendLine("  </table></td>")
                    TocStr.AppendLine(" </tr>")
                    TocStr.AppendLine("</table>")

                    PageContent = StringReplace(PageContent, "{{toc}}", TocStr.ToString)
                Else
                    PageContent = StringReplace(PageContent, "{{toc}}", "")
                End If
            End If

            Output.Write(UTF8Encoding.UTF8.GetBytes(PageContent), offset, UTF8Encoding.UTF8.GetByteCount(PageContent))
        End If
    End Sub

#End Region

End Class