﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Xml;
using System.Text;
using System.Web.Script.Services;

namespace ArticleDean.web.Service
{
    /// <summary>
    /// Summary description for WSDataService
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [ScriptService]
    public class WSDataService : System.Web.Services.WebService
    {
        [WebMethod]
        public string GetStates()
        {
            StringBuilder sbStates = new StringBuilder();
            
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath("~/Data/States.xml"));
            try
            {
                foreach (XmlElement xnl in doc.DocumentElement.ChildNodes)
                {
                    sbStates.AppendFormat("{0}:",xnl.Attributes["name"].Value);
                }

                sbStates = sbStates.Remove(sbStates.Length - 1, 1); //Removes the extra ":"
            }
            catch (Exception ex)
            {
                string exp = ex.ToString(); //Setup a breakpoint here to verify any exceptions raised.
            }
            return sbStates.ToString();
        }

        [WebMethod]
        [ScriptMethod(ResponseFormat = ResponseFormat.Json)]
        public List<State> GetStatesWithAbbr()
        {
            List<State> sbStates = new List<State>();

            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath("~/Data/States.xml"));
            try
            {
                foreach (XmlElement xnl in doc.DocumentElement.ChildNodes)
                {
                    State st = new State();
                    st.Name = xnl.Attributes["name"].Value;
                    st.Abbreviation = xnl.Attributes["abbreviation"].Value;
                    st.value = xnl.Attributes["name"].Value;
                    sbStates.Add(st);
                }
            }
            catch (Exception ex)
            {
                string exp = ex.ToString(); //Setup a breakpoint here to verify any exceptions raised.
            }
            return sbStates;
        }
    }

    public class State
    {
        string _name;
        string _value;

        public string value
        {
            get { return _value; }
            set { _value = value; }
        }

        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        string _abbr;

        public string Abbreviation
        {
            get { return _abbr; }
            set { _abbr = value; }
        }
    }
}
