using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvHover.DataSource = GetDataTable();
            gvHover.DataBind();
        }
    }

    protected DataTable GetDataTable()
    {
        DataTable dTable = new DataTable();
        DataRow dRow = null;
        Random rnd = new Random();
        dTable.Columns.Add("n");
        dTable.Columns.Add("qbrtn");
        dTable.Columns.Add("sqrtn");

        for (int n = 1; n <= 10; ++n)
        {
            dRow = dTable.NewRow();

            dRow["n"] = n + ".";
            dRow["qbrtn"] = Math.Pow(n, 1D / 3D) + "";
            dRow["sqrtn"] = Math.Sqrt(n) + "";

            dTable.Rows.Add(dRow);
            dTable.AcceptChanges();
        }

        return dTable;
    }

    protected void gvHover_RowCreated(object sender, GridViewRowEventArgs e)
    {
        //Add CSS class on header row.
        if (e.Row.RowType == DataControlRowType.Header)
            e.Row.CssClass = "header";

        //Add CSS class on normal row.
        if (e.Row.RowType == DataControlRowType.DataRow && e.Row.RowState == DataControlRowState.Normal)
            e.Row.CssClass = "normal";

        //Add CSS class on alternate row.
        if (e.Row.RowType == DataControlRowType.DataRow && e.Row.RowState == DataControlRowState.Alternate)
            e.Row.CssClass = "alternate";
    }
}
