Imports System.IO

Partial Public Class _Default
    Inherits System.Web.UI.Page
    Implements System.Web.UI.ICallbackEventHandler


    ''' <summary>
    ''' Holds the result that will be send to the Page
    ''' </summary>
    Protected CallBackResult As String



    ''' <summary>
    ''' Register propper callbacks
    ''' </summary>
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        'Register the method that receives the call back result
        Dim ReceiverCallBackMethod As String
        ReceiverCallBackMethod = Page.ClientScript.GetCallbackEventReference(Me, "arg", "ReceiveCallBackResult", "context")
        'Register the method that makes the callback call
        Dim callbackMethod As String
        callbackMethod = "function CallServer(arg, context) { " & ReceiverCallBackMethod & "} ;"
        Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "CallServer", callbackMethod, True)

    End Sub


    ''' <summary>
    ''' Creates HTML code 
    ''' </summary>
    ''' <returns>The HTML</returns>
    Public Function ShowTheData() As String

        'The data source
        Dim DS As New DataSet
        'Check if the file exists
        Dim file As New FileInfo(Server.MapPath(Request.ApplicationPath) & "/Data.xml")
        If Not file.Exists Then
            DS.Tables.Add("Users")
            DS.Tables("Users").Columns.Add("User Name", GetType(String))
            DS.Tables("Users").Columns.Add("Age", GetType(Integer))
            DS.WriteXml(file.FullName, XmlWriteMode.WriteSchema)
        Else
            DS.ReadXml(file.FullName)
        End If

        'The HTML
        Dim HTML As String = "<Table border=1>"
        'Add the headers
        HTML &= "<tr><td>Name</td><td>Age</td></tr>"

        'Create the Rows
        For Each Row As DataRow In DS.Tables("Users").Rows
            Dim TR As String = "<tr>"
            'show the name and Age
            TR &= "<td>" & Row(0).ToString & "</td>"
            TR &= "<td>" & Row(1).ToString & "</td>"
            TR &= "</tr>"
            HTML &= TR
        Next

        Return HTML & "</Table>"
    End Function


    ''' <summary>
    ''' The Event that proccess the Call Back
    ''' </summary>
    ''' <param name="eventArgument">Send values to proccess here</param>
    Public Sub RaiseCallbackEvent(ByVal eventArgument As String) _
    Implements System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent

        'In this case we dont need to proccess nothing 

    End Sub


    ''' <summary>
    ''' This will return some data to the Caller Page
    ''' </summary>
    ''' <returns>HTML string with all the users</returns>
    Public Function GetCallbackResult() _
    As String Implements _
    System.Web.UI.ICallbackEventHandler.GetCallbackResult

        'return the value
        Return ShowTheData()

    End Function

End Class